<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/14
 * @copyright
 */

namespace SMG\ThirdApi\WeiKe\Rest;

use GuzzleHttp\Client;
use SMG\ThirdApi\WeiKe\Base;

class Power extends Base
{
    const PATH = [
        'pushOrder' => 'rest/Power/pushOrder',
        'query'     => 'rest/Power/query',
    ];

    /**
     * 电费充值
     * @desc
     *
     * @param $params
     *
     * @return false|string
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @since     2023/10/14
     * @modify
     * @author    [ZZM]
     */
    public function pushOrder($params)
    {
        return $this->sendRequest(self::PATH['pushOrder'], $params);
    }

    /**
     * 电费订单查询
     * @desc
     *
     * @param $params
     *
     * @return mixed
     * @throws \Exception
     * @since     2023/10/14
     * @modify
     * @author    [ZZM]
     */
    public function query($params)
    {
        return $this->sendRequest(self::PATH['query'], $params);
    }
}