<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/14
 * @copyright
 */

namespace SMG\ThirdApi\WeiKe;

use GuzzleHttp\Client;
use SMG\ThirdApi\WeiKe\Rest\Power;

class Base
{
    protected $base_uri = 'https://router.wikeyun.cn/';

    protected $config = [];

    public function __construct($config=null) {
        if($config){
            $this->config = $config;
        }else{
            $this->config = config('third_api.weike');
        }
        if(empty($this->config['app_key'])){
            throw new \Exception("缺少 app_key");
        }
        if(empty($this->config['app_secret'])){
            throw new \Exception("缺少 app_secret");
        }
    }

    /**
     * 发送请求
     * @desc
     *
     * @param $path
     * @param $params
     *
     * @return mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @author    [ZZM]
     * @since     2023/10/14
     * @modify
     */
    protected function sendRequest($path,$params){
        $url = $this->base_uri.$path;

        $client = new Client();

        $common_params = [
            'app_key' => $this->config['app_key'],
            'timestamp' => time(),
            'client' => getClientIP(),
            'v' => '1.0',
            'format' => 'json',
        ];
        $common_params['sign'] = $this->getSign(array_merge($common_params,$params));

        $url = $url. '?' . http_build_query($common_params);
        $response = $client->post($url, [
            'headers' => [
                'Content-Type' => 'application/x-www-form-urlencoded',
            ],
            'form_params' => $params,
        ]);
        if ($response->getStatusCode() === 200) {
            $body = $response->getBody()->getContents();
            return json_decode($body);
        } else {
            throw new \Exception("请求失败，状态码：{$response->getStatusCode()}");
        }
    }

    /**
     * 签名
     * @desc
     *
     * @param $params
     *
     * @return string
     * @author    [ZZM]
     * @since     2023/10/14
     * @modify
     */
    protected function getSign($params){
        $str = '';

        #首字母以ASCII方式升序排列
        uksort($params, function($a, $b) {
            return strcmp($a, $b);
        });

        foreach ($params as $key => $value){
            $str .= $key.$value;
        }

        $str = $this->config['app_secret']."{$str}".$this->config['app_secret'];
        return strtoupper(md5($str));
    }
}