<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

$api = app('Dingo\Api\Routing\Router');
$api->version('v1', [
    'namespace' => 'Modules\Customers\Http\Controllers',
    'prefix'    => 'api/customer',
], function ($api) {
    $api->group(['middleware' => ['api.auth', 'admin.permission', 'admin.log_operation']], function ($api) {
        ###我的客户
        #客户列表
        $api->get('private/list', 'PrivateCustomersController@list')->name('customer.private.list');
        #新增客户
        $api->post('private/add', 'PrivateCustomersController@add')->name('customer.private.add');
        #批量导入客户
        $api->post('private/add_import', 'PrivateCustomersController@addImport')->name('customer.private.add_import');
        #编辑客户-基本信息
        $api->put('private/{id}/edit', 'PrivateCustomersController@edit')->name('customer.private.edit');
        #编辑客户-私密资料
        $api->put('private/{id}/edit_private', 'PrivateCustomersController@editPrivate')->name('customer.private.edit_private');
        #客户信息
        $api->get('private/{id}/show', 'PrivateCustomersController@show')->name('customer.private.show');
        #写跟进
        $api->put('private/{id}/follow', 'PrivateCustomersController@updateFollowStatus')->name('customer.private.follow');
        #跟进列表
        $api->get('private/{id}/follow_list', 'PrivateCustomersController@followList')->name('customer.private.follow_list');
        #退回公海
        $api->put('private/back_public', 'PrivateCustomersController@backPublic')->name('customer.private.back_public');
        #数据字段
        $api->get('private/data_maps', 'PrivateCustomersController@dataMaps')->name('customer.private.data_maps');

        ###公海客户
        #客户列表
        $api->get('public/list', 'PublicCustomersController@list')->name('customer.public.list');
        #新增客户
        $api->post('public/add', 'PublicCustomersController@add')->name('customer.public.add');
        #批量导入客户
        $api->post('public/add_import', 'PublicCustomersController@addImport')->name('customer.public.add_import');
        #编辑客户-基本信息
        $api->put('public/{id}/edit', 'PublicCustomersController@edit')->name('customer.public.edit');
        #编辑客户-私密资料
        $api->put('public/{id}/edit_private', 'PublicCustomersController@editPrivate')->name('customer.public.edit_private');
        #客户信息
        $api->get('public/{id}/show', 'PublicCustomersController@show')->name('customer.public.show');
        #写跟进
        $api->put('public/{id}/follow', 'PublicCustomersController@updateFollowStatus')->name('customer.public.follow');
        #跟进列表
        $api->get('public/{id}/follow_list', 'PublicCustomersController@followList')->name('customer.public.follow_list');
        #退回公海
        $api->put('public/receive_private', 'PublicCustomersController@receivePrivate')->name('customer.public.receive_private');
        #数据字段
        $api->get('public/data_maps', 'PublicCustomersController@dataMaps')->name('customer.public.data_maps');

        ###商机
        #商机列表
        $api->get('opportunity/list', 'BusinessOpportunityController@list')->name('customer.opportunity.list');
        #新增商机
        $api->post('opportunity/add', 'BusinessOpportunityController@add')->name('customer.opportunity.add');
        #编辑商机
        $api->put('opportunity/{id}/edit', 'BusinessOpportunityController@edit')->name('customer.opportunity.edit');
        #商机信息
        $api->get('opportunity/{id}/show', 'BusinessOpportunityController@show')->name('customer.opportunity.show');
        #数据字段
        $api->get('opportunity/data_maps', 'BusinessOpportunityController@dataMaps')->name('customer.opportunity.data_maps');

    });

});
