<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/2
 * @copyright
 */

namespace Modules\Customers\Http\Service;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Cache;
use Modules\Admin\Entities\Area;
use Modules\Customers\Entities\Customer;
use Modules\Customers\Entities\CustomerFollow;

class CustomerService
{
    /**
     * 格式化待更新参数
     * @desc
     *
     * @param Customer $customer 数据模型
     * @param array    $params   请求参数
     *
     * @return array
     * @since     2023/11/2
     * @modify
     * @author    [ZZM]
     */
    static public function formatUpdateParams(Customer $customer, array $params): array
    {
        $update = [];
        foreach ($params as $field => $value)
        {
            switch ($field)
            {
                case "province":
                case "city":
                case "area":
                case "from":
                case "type":
                case "follow_status":
                    $value = $value ?: 0;
                    break;
                default:
                    $value = $value ?: '';
                    break;
            }

            if ($customer->{$field} != $value)
            {
                $update[ $field ] = $value;
            }
        }


        return $update;
    }

    /**
     * 格式化导入数据
     * @desc
     *
     * @param array  $data
     * @param string $type
     *
     * @return array
     * @author    [ZZM]
     * @since     2023/11/2
     * @modify
     */
    static public function formatImportData(array $data, string $type = 'public'): array
    {
        $user = auth()->user();
        $now  = Carbon::now();

        $default_field = [
            'name'          => '',
            'company'       => '',
            'industry'      => '',
            'department'    => '',
            'duties'        => '',
            'tel_phone'     => '',
            'mobile_phone'  => '',
            'wechat'        => '',
            'dy'            => '',
            'email'         => '',
            'address'       => '',
            'follow_status' => '0',
            'from'          => '0',
            'type'          => '0',
        ];
        $required_field         = ['name', 'company', 'industry', 'department', 'duties',];
        $required_field_message = [
            'name'       => '客户名称不能为空',
            'company'    => '公司名称不能为空',
            'industry'   => '行业不能为空',
            'department' => '部门不能为空',
            'duties'     => '职业不能为空',
        ];
        $insert                 = [];
        foreach ($data as $key => $item)
        {
            if (empty($item))
            {
                continue;
            }

            $insert_item = [];
            foreach ($default_field as $field => $default_value)
            {
                $value = trim($item[$field]??$default_value);

                #必选字段
                if (in_array($field, $required_field) && empty($value))
                {
                    abort(500, "第".($key + 1)."行数据有误：{$required_field_message[$field]}");
                }

                #跟进状态
                if ($field == 'follow_status' && empty(CustomerFollow::$status_maps[$value]))
                {
                    $value = 0;
                }

                #客户来源
                if ($field == 'from' && empty(Customer::$from_maps[$value]))
                {
                    $value = 0;
                }

                #客户类型
                if ($field == 'type' && empty(Customer::$type_maps[$value]))
                {
                    $value = 0;
                }

                $insert_item[ $field ] = $value;
            }

            $insert_item['founder']    = $user->id;
            $insert_item['created_at'] = $now;
            $insert_item['updated_at'] = $now;

            if ($type == 'private')
            {
                $insert_item['owner'] = $user->id;
            }

            $insert[] = $insert_item;
        }

        return $insert;
    }
}