<?php

namespace Modules\Customers\Http\Requests;

use Illuminate\Validation\Rule;
use Modules\Admin\Entities\AdminUser;
use Modules\Customers\Entities\Customer;
use Modules\Customers\Entities\CustomerFollow;

class CustomerRequest extends BaseRequest
{

    public function addRules()
    {
        return [
            'name' => 'bail|required',
            'company' => 'bail|required',
            'industry' => 'bail|required',
            'department' => 'bail|required',
            'duties' => 'bail|required',
        ];
    }

    public function editRules()
    {
        return [
            'name' => 'bail|required',
            'company' => 'bail|required',
            'industry' => 'bail|required',
            'department' => 'bail|required',
            'duties' => 'bail|required',
        ];
    }

    public function updateFollowStatusRules()
    {
        return [
            'type' => ['bail','required',Rule::in(array_keys(CustomerFollow::$type_maps))],
            'status' => ['bail','required',Rule::in(array_keys(CustomerFollow::$status_maps))],
            'next_follow_time' => ['bail','required','date_format:Y-m-d H:i:s','after:now'],
            'content' => ['bail','required'],
        ];
    }


    public function commonMessages()
    {
        return [
            'name.required' => '客户名称不能为空',
            'company.required' => '公司名称不能为空',
            'industry.required' => '行业不能为空',
            'department.required' => '部门不能为空',
            'duties.required' => '职业不能为空',
        ];
    }

    public function updateFollowStatusMessages()
    {
        return [
            'type.required' => '类型不能为空',
            'type.in' => '类型不存在',
            'status.required' => '状态不能为空',
            'status.in' => '状态不存在',
            'next_follow_time.required' => '下次跟进时间不能为空',
            'next_follow_time.date_format' => '下次跟进时间格式错误',
            'next_follow_time.after' => '下次跟进时间必须大于当前时间',
            'content.required' => '内容不能为空',
        ];
    }
}
