<?php

namespace Modules\Customers\Http\Controllers;

use Modules\Customers\Entities\Customer;
use Modules\Customers\Http\Requests\CustomerRequest;

class PrivateCustomersController extends CustomersController
{
    protected $type = 'private';

    /**
     * 客户退回公海 可批量
     * @desc
     * @author    [ZZM]
     * @since     2023/11/2
     * @modify
     */
    public function backPublic(CustomerRequest $request)
    {
        $ids = $request->input('id', []);

        if($ids){
            Customer::whereIn('id', $ids)->private()->update(['owner' => 0]);
        }

        return $this->response->noContent();
    }

}
