<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/2
 * @copyright
 */

namespace Modules\Customers\Entities;

class CustomerFollow extends BaseModel
{
    protected $fillable = [
        'customer_id', 'type', 'before_status', 'status', 'follow_time', 'next_follow_time', 'content',
    ];

    static public $type_maps = [
        1  => '个人',
        2  => '企业',
        99 => '其他',
    ];

    static public $status_maps = [
        1  => '初访',
        2  => '意向',
        3  => '报价',
        4  => '成交',
        5  => '暂时搁置',
        6  => '未成交',
    ];

    public function getStatusTextAttribute()
    {
        return static::$status_maps[$this->status] ?? '';
    }

    public function getTypeTextAttribute()
    {
        return static::$type_maps[$this->type] ?? '';
    }
}