<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/2
 * @copyright
 */

namespace Modules\Customers\Entities;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class BusinessOpportunity extends BaseModel
{
    protected $fillable = [
        'customer_id', 'product_type', 'title', 'demand_doc', 'customer_desire_time', 'customer_expect_money',
        'expect_date', 'estimate_status', 'estimate_hour', 'estimate_price', 'estimate_people', 'estimate_time',
    ];

    protected $search = [
        'expect_date',  'customer_name', 'customer_phone','title', 'id',
    ];

    static public $product_type_maps = [
        1  => '标准产品',
        2  => '定制开发服务',
    ];

    static public $estimate_status_maps = [
        1  => '等待评估',
        2  => '评估中',
        3  => '评估完成',
    ];

    protected function searchRule($query,$key,$value){
        switch ($key){
            case "customer_name":
                $query->whereHas('customer',function ($query)use ($value) {
                    $query->where('name', 'like',"%{$value}%");
                });
                break;
            case "customer_phone":
                $query->whereHas('customer',function ($query)use ($value) {
                    $query->where('mobile_phone',$value);
                });
                break;
            case "title":
                $query->where($key,'like',"%{$value}%");
                break;
            default:
                $query->where($key,$value);
                break;
        }
        return $query;
    }

    public function getProductTypeTextAttribute()
    {
        return static::$product_type_maps[$this->product_type] ?? '';
    }

    public function getEstimateStatusTextAttribute()
    {
        return static::$estimate_status_maps[$this->estimate_status] ?? '';
    }

    public function customer(): BelongsTo{
        return $this->belongsTo(Customer::class);
    }
}