<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_follows', function (Blueprint $table) {
            $table->comment('客户跟进记录表');
            $table->id();
            $table->integer('customer_id')->default(0)->comment('客户ID');
            $table->tinyInteger('type')->default(0)->comment('跟进类型');
            $table->tinyInteger('before_status')->default(0)->comment('上次跟进状态');
            $table->tinyInteger('status')->default(0)->comment('跟进状态');
            $table->dateTime('follow_time')->nullable()->comment('跟进时间');
            $table->dateTime('next_follow_time')->nullable()->comment('下次跟进时间');
            $table->string('content')->default('')->comment('跟进内容');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_follows');
    }
};
