<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->comment('客户表');
            $table->id();
            $table->string('name')->default('')->comment('客户名称');
            $table->string('company')->default('')->comment('公司名称');
            $table->string('industry')->default('')->comment('行业');
            $table->string('department')->default('')->comment('部门');
            $table->string('duties')->default('')->comment('职务');
            $table->string('tel_phone')->default('')->comment('电话');
            $table->string('mobile_phone')->default('')->comment('手机号码');
            $table->string('wechat')->default('')->comment('微信号');
            $table->string('dy')->default('')->comment('抖音号');
            $table->string('email')->default('')->comment('邮箱');
            $table->integer('province')->default(0)->comment('省');
            $table->integer('city')->default(0)->comment('市');
            $table->integer('area')->default(0)->comment('区');
            $table->string('address')->default('')->comment('详细地址');
            $table->tinyInteger('follow_status')->default(0)->comment('跟进状态');
            $table->tinyInteger('from')->default(0)->comment('客户来源');
            $table->tinyInteger('type')->default(0)->comment('客户类型');
            $table->integer('founder')->default(0)->comment('创建人');
            $table->integer('owner')->default(0)->comment('持有人');
            $table->string('business_license')->default('')->comment('营业执照');
            $table->string('identity')->default('')->comment('身份证');
            $table->string('bank_account')->default('')->comment('银行对公账户');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
};
