<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/23
 * @copyright
 */

namespace Modules\Customers\ApiDocs;

/**
 * @OA\Get(
 *     tags={"客户"},
 *     summary="客户列表",
 *     path="api/customer/{type}/list",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\Parameter(
 *         name="search",
 *         in="query",
 *         description="搜索条件，如 search[follow_status]=1,
 * ''follow_status','type', 'from', 'name', 'mobile_phone', 'created_at，逗号分割 如 2023-11-02 12:05:41,2023-11-02 12:14:53', 'wechat'",
 *         required=false,
 *         @OA\Schema(
 *             type="array",
 *             @OA\Items(type="string"),
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *             mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(
 *                      property="data",
 *                      type="array",
 *                      @OA\Items(ref="#/components/schemas/Customer"),
 *                      description="列表"
 *                  ),
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Post(
 *     tags={"客户"},
 *     summary="新增客户",
 *     path="api/customer/{type}/add",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\RequestBody(
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 type="object",
 *                 required={"name","company","industry","department","duties",},
 *                 @OA\Property(
 *                     property="name",
 *                     type="string",
 *                     description="客户名称",
 *                 ),
 *                 @OA\Property(
 *                     property="company",
 *                     type="string",
 *                     description="公司名称",
 *                 ),
 *                 @OA\Property(
 *                     property="industry",
 *                     type="string",
 *                     description="行业",
 *                 ),
 *                 @OA\Property(
 *                     property="department",
 *                     type="string",
 *                     description="部门",
 *                 ),
 *                 @OA\Property(
 *                     property="duties",
 *                     type="string",
 *                     description="职位",
 *                 ),
 *                 @OA\Property(
 *                     property="tel_phone",
 *                     type="string",
 *                     description="电话",
 *                 ),
 *                 @OA\Property(
 *                     property="mobile_phone",
 *                     type="string",
 *                     description="手机号码",
 *                 ),
 *                 @OA\Property(
 *                     property="wechat",
 *                     type="string",
 *                     description="微信号",
 *                 ),
 *                 @OA\Property(
 *                     property="dy",
 *                     type="string",
 *                     description="抖音号",
 *                 ),
 *                 @OA\Property(
 *                     property="email",
 *                     type="string",
 *                     description="邮箱",
 *                 ),
 *                 @OA\Property(
 *                     property="province",
 *                     type="string",
 *                     description="省",
 *                 ),
 *                 @OA\Property(
 *                     property="city",
 *                     type="string",
 *                     description="市",
 *                 ),
 *                 @OA\Property(
 *                     property="area",
 *                     type="string",
 *                     description="区",
 *                 ),
 *                 @OA\Property(
 *                     property="address",
 *                     type="string",
 *                     description="地址",
 *                 ),
 *                 @OA\Property(
 *                     property="from",
 *                     type="string",
 *                     description="客户来源",
 *                 ),
 *                 @OA\Property(
 *                     property="type",
 *                     type="string",
 *                     description="客户类型",
 *                 ),
 *
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *              mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(property="data", type="object", ref="#/components/schemas/Customer")
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Post(
 *     tags={"客户"},
 *     summary="批量导入客户",
 *     path="api/customer/{type}/add_import",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\RequestBody(
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 type="object",
 *                 required={"data"},
 *                 @OA\Property(
 *                     property="name",
 *                     type="string",
 *                     description="导入数据，json数组格式，字段同新增接口",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response="201",
 *          description="",
 *      )
 * )
 *
 * @OA\Put(
 *     tags={"客户"},
 *     summary="编辑客户-普通资料",
 *     path="api/customer/{type}/{id}/edit",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\RequestBody(
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 type="object",
 *                 required={"name","company","industry","department","duties",},
 *                 @OA\Property(
 *                     property="name",
 *                     type="string",
 *                     description="客户名称",
 *                 ),
 *                 @OA\Property(
 *                     property="company",
 *                     type="string",
 *                     description="公司名称",
 *                 ),
 *                 @OA\Property(
 *                     property="industry",
 *                     type="string",
 *                     description="行业",
 *                 ),
 *                 @OA\Property(
 *                     property="department",
 *                     type="string",
 *                     description="部门",
 *                 ),
 *                 @OA\Property(
 *                     property="duties",
 *                     type="string",
 *                     description="职位",
 *                 ),
 *                 @OA\Property(
 *                     property="tel_phone",
 *                     type="string",
 *                     description="电话",
 *                 ),
 *                 @OA\Property(
 *                     property="mobile_phone",
 *                     type="string",
 *                     description="手机号码",
 *                 ),
 *                 @OA\Property(
 *                     property="wechat",
 *                     type="string",
 *                     description="微信号",
 *                 ),
 *                 @OA\Property(
 *                     property="dy",
 *                     type="string",
 *                     description="抖音号",
 *                 ),
 *                 @OA\Property(
 *                     property="email",
 *                     type="string",
 *                     description="邮箱",
 *                 ),
 *                 @OA\Property(
 *                     property="province",
 *                     type="string",
 *                     description="省",
 *                 ),
 *                 @OA\Property(
 *                     property="city",
 *                     type="string",
 *                     description="市",
 *                 ),
 *                 @OA\Property(
 *                     property="area",
 *                     type="string",
 *                     description="区",
 *                 ),
 *                 @OA\Property(
 *                     property="address",
 *                     type="string",
 *                     description="地址",
 *                 ),
 *                 @OA\Property(
 *                     property="from",
 *                     type="string",
 *                     description="客户来源",
 *                 ),
 *                 @OA\Property(
 *                     property="type",
 *                     type="string",
 *                     description="客户类型",
 *                 ),
 *
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *              mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(property="data", type="object", ref="#/components/schemas/Customer")
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Get(
 *     tags={"客户"},
 *     summary="详情",
 *     path="api/customer/{type}/{id}/detail",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *              mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(property="data", type="object", ref="#/components/schemas/Customer")
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Put(
 *     tags={"客户"},
 *     summary="编辑客户-私密资料",
 *     path="api/customer/{type}/{id}/edit_private",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\RequestBody(
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 type="object",
 *                 required={},
 *                 @OA\Property(
 *                     property="business_license",
 *                     type="string",
 *                     description="营业执照",
 *                 ),
 *                 @OA\Property(
 *                     property="identity",
 *                     type="string",
 *                     description="身份证",
 *                 ),
 *                 @OA\Property(
 *                     property="bank_account",
 *                     type="string",
 *                     description="银行账户",
 *                 ),
 *                 @OA\Property(
 *                     property="mobile_phone",
 *                     type="string",
 *                     description="手机号",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *              mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(property="data", type="object", ref="#/components/schemas/Customer")
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Put(
 *     tags={"客户"},
 *     summary="写跟进",
 *     path="api/customer/{type}/{id}/follow",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\RequestBody(
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 type="object",
 *                 required={"type","status","next_follow_time","content",},
 *                 @OA\Property(
 *                     property="type",
 *                     type="string",
 *                     description="跟进类型",
 *                 ),
 *                 @OA\Property(
 *                     property="status",
 *                     type="string",
 *                     description="跟进状态",
 *                 ),
 *                 @OA\Property(
 *                     property="next_follow_time",
 *                     type="string",
 *                     description="下次跟进时间",
 *                 ),
 *                 @OA\Property(
 *                     property="content",
 *                     type="string",
 *                     description="跟进内容",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response="204",
 *          description="",
 *      )
 * )
 *
 * @OA\Get(
 *     tags={"客户"},
 *     summary="字段数据",
 *     path="api/customer/{type}/data_maps",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="type",
 *         in="path",
 *         description="客户类型 private=我的客户 public=公海客户 ",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *             default="default",
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="类型、状态字段数据",
 *      )
 * )
 *
 */
class CustomerDoc
{

}