<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/3
 * @copyright
 */

namespace Modules\Customers\ApiDocs;

/**
 * @OA\Get(
 *     tags={"客户"},
 *     summary="商机列表",
 *     path="api/customer/opportunity/list",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Parameter(
 *         name="search",
 *         in="query",
 *         description="搜索条件，如 search[customer_name]=1,
 * ''expect_date','customer_name', 'customer_phone', 'title', 'id',",
 *         required=false,
 *         @OA\Schema(
 *             type="array",
 *             @OA\Items(type="string"),
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *             mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(
 *                      property="data",
 *                      type="array",
 *                      @OA\Items(ref="#/components/schemas/BusinessOpportunity"),
 *                      description="列表"
 *                  ),
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Post(
 *     tags={"客户"},
 *     summary="新增商机",
 *     path="api/customer/opportunity/add",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\RequestBody(
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 type="object",
 *                 required={"customer_id","product_type","title","demand_doc","customer_desire_time","customer_expect_money",},
 *                 @OA\Property(
 *                     property="customer_id",
 *                     type="string",
 *                     description="客户ID",
 *                 ),
 *                 @OA\Property(
 *                     property="product_type",
 *                     type="string",
 *                     description="产品类型",
 *                 ),
 *                 @OA\Property(
 *                     property="title",
 *                     type="string",
 *                     description="标题",
 *                 ),
 *                 @OA\Property(
 *                     property="demand_doc",
 *                     type="string",
 *                     description="需求文档",
 *                 ),
 *                 @OA\Property(
 *                     property="customer_desire_time",
 *                     type="string",
 *                     description="客户期望时间",
 *                 ),
 *                 @OA\Property(
 *                     property="customer_expect_money",
 *                     type="string",
 *                     description="客户预计金额",
 *                 ),*
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *              mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(property="data", type="object", ref="#/components/schemas/BusinessOpportunity")
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Put(
 *     tags={"客户"},
 *     summary="编辑商机",
 *     path="api/customer/opportunity/{id}/edit",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\RequestBody(
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 type="object",
 *                 required={"customer_id","product_type","title","demand_doc","customer_desire_time","customer_expect_money",},
 *                 @OA\Property(
 *                     property="customer_id",
 *                     type="string",
 *                     description="客户ID",
 *                 ),
 *                 @OA\Property(
 *                     property="product_type",
 *                     type="string",
 *                     description="产品类型",
 *                 ),
 *                 @OA\Property(
 *                     property="title",
 *                     type="string",
 *                     description="标题",
 *                 ),
 *                 @OA\Property(
 *                     property="demand_doc",
 *                     type="string",
 *                     description="需求文档",
 *                 ),
 *                 @OA\Property(
 *                     property="customer_desire_time",
 *                     type="string",
 *                     description="客户期望时间",
 *                 ),
 *                 @OA\Property(
 *                     property="customer_expect_money",
 *                     type="string",
 *                     description="客户预计金额",
 *                 ),
 *                 @OA\Property(
 *                     property="expect_date",
 *                     type="string",
 *                     description="预计签单日期",
 *                 ),
 *                 @OA\Property(
 *                     property="estimate_status",
 *                     type="string",
 *                     description="评估状态",
 *                 ),
 *                 @OA\Property(
 *                     property="estimate_hour",
 *                     type="string",
 *                     description="工时",
 *                 ),
 *                 @OA\Property(
 *                     property="estimate_price",
 *                     type="string",
 *                     description="评估价格",
 *                 ),
 *                 @OA\Property(
 *                     property="estimate_people",
 *                     type="string",
 *                     description="评估人",
 *                 ),
 *                 @OA\Property(
 *                     property="estimate_time",
 *                     type="string",
 *                     description="评估时间",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *              mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(property="data", type="object", ref="#/components/schemas/BusinessOpportunity")
 *              )
 *          )
 *      )
 * )
 *
 * @OA\Get(
 *     tags={"客户"},
 *     summary="商机详情",
 *     path="api/customer/opportunity/{id}/detail",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Response(
 *          response="200",
 *          description="",
 *          @OA\MediaType(
 *              mediaType="application/json",
 *              @OA\Schema(
 *                  type="object",
 *                  @OA\Property(property="data", type="object", ref="#/components/schemas/BusinessOpportunity")
 *              )
 *          )
 *      )
 * )
 *
 *
 * @OA\Get(
 *     tags={"客户"},
 *     summary="商机-字段数据",
 *     path="api/customer/opportunity/data_maps",
 *     security={
 *         {"jwt_auth": {}}
 *     },
 *     @OA\Response(
 *          response="200",
 *          description="类型、状态字段数据",
 *      )
 * )
 *
 *
 *
 *
 */
class BusinessOpportunityDoc
{

}