<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformer;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\AdminRole;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Utils\Helper;

class AdminRoleTransformer extends BaseTransformer
{
    use Macroable;
    protected $show_menu;
    public function __construct($show_menu = true)
    {
        $this->show_menu = $show_menu;
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="角色信息",
     *     type="object",
     *     schema="Role",
     *     @OA\Property(property="name", type="integer", description="名称"),
     *     @OA\Property(property="slug", type="string", description="描述"),
     *     @OA\Property(property="is_admin", type="string", description="是否超级管理员"),
     *     @OA\Property(property="menus", type="string", description="菜单id列表"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */
    public function transform(AdminRole $role)
    {
        $return = ['id','name','slug','menus','created_at'];
        $return = Helper::mapAttr($role,$return);
        $return['is_admin'] = Helper::isAdministrator($return['id']);
        return $return;
    }
}
