<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformer;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\AdminMenu;
use Modules\Admin\Entities\AdminRole;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Utils\Helper;

class AdminMenuTransformer extends BaseTransformer
{
    use Macroable;
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="菜单信息",
     *     type="object",
     *     schema="Menu",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="parent_id", type="string", description="上级ID"),
     *     @OA\Property(property="order", type="integer", description="排序"),
     *     @OA\Property(property="title", type="string", description="标题"),
     *     @OA\Property(property="icon", type="string", description="图标"),
     *     @OA\Property(property="key", type="string", description="路由标识"),
     *     @OA\Property(property="is_menu", type="integer", description="是否菜单"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */
    public function transform(AdminMenu $menu)
    {

        $return = ['id','parent_id','order','title','key','icon','api','is_menu','created_at'];

        return Helper::mapAttr($menu,$return);
    }
}
