<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Validation\Rule;
use Modules\Admin\Entities\AdminUser;

class AnnouncementRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function postRules()
    {
        return [
            'title' => 'bail|required',
            'content' => 'bail|required',
        ];
    }

    public function putRules()
    {
        return [
            'title' => 'bail|required',
            'content' => 'bail|required',
        ];
    }

    public function messages()
    {
        return [
            'title.required' => '标题不能为空',
            'content.required' => '内容不能为空',
        ];
    }
}
