<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/2
 * @copyright
 */

namespace Modules\Admin\Http\Controllers;

use Illuminate\Support\Facades\Cache;
use Modules\Admin\Entities\Area;

class AreaController extends BaseController
{
    /**
     *  * @OA\Get(
     *     tags={"地区"},
     *     summary="地区列表所有值",
     *     path="/api/package/areas/all",
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(ref="#/components/schemas/Area"),
     *                      description="列表"
     *                  ),
     *              )
     *          )
     *      )
     * )
     * @OA\Schema(
     *     description="地区列表",
     *     type="object",
     *     schema="Area",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="名称"),
     *     @OA\Property(property="depth", type="integer", description="区域级别"),
     *     @OA\Property(property="parent_id", type="integer", description="父ID"),
     *     @OA\Property(property="children", type="array", description="子地区", @OA\Items(ref="#/components/schemas/Area"))
     * )
     */
    public function all()
    {
        $fields = ['id', 'name', 'parent_id', '_lft','_rgt', 'code'];
        $data = Cache::rememberForever(Area::CACHE_KEY_AREAS_ALL, function () use ($fields) {
            return Area::get($fields)->toTree()->toArray();
        });

        return $this->response->array(['data' => $data]);
    }

}