<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/21
 * @copyright
 */

namespace Modules\Admin\Entities;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Auth;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class AdminUser extends Authenticatable implements JWTSubject
{
    protected $fillable = [
        'username','password', 'name', 'avatar', 'salt', 'role_id',
        'phone','entry_time','department_id','skill','job_name','job_number','contract_id',
    ];

    protected $casts = [
        'skill' => 'json',
    ];
    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public  function apiLoginAndGetTokenInfo()
    {
        $auth = auth('api');
        return [
            'access_token' => $auth->login($this),
            'token_type' => 'Bearer',
            'expires_in' => $auth->factory()->getTTL() * 60,
        ];
    }

    public  function apiRefreshTokenTokenInfo()
    {
        $auth = auth('api');
        return [
            'access_token' => $auth->refresh(true,true),
            'token_type' => 'Bearer',
            'expires_in' => $auth->factory()->getTTL() * 60,
        ];
    }

    public function role(){
        return $this->belongsTo(AdminRole::class);
    }

    public function department(){
        return $this->belongsTo(Department::class);
    }
}