<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('area', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->comment('地区名称');
            $table->tinyInteger('disabled')->default(0)->comment('是否禁用');
            $table->timestamps();

            $table->nestedSet();
            $table->unsignedInteger('code')->unique()->nullable()->comment('编号');
        });

        $sql1 = "INSERT INTO `area` (`id`, `name`, `disabled`, `created_at`, `updated_at`, `_lft`, `_rgt`, `parent_id`, `code`) VALUES
(1, '北京', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 1, 36, NULL, 11000000),
(2, '北京市', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 2, 35, 1, 11010000),
(3, '东城区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 3, 4, 2, 11010100),
(4, '西城区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 5, 6, 2, 11010200),
(5, '朝阳区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 7, 8, 2, 11010300),
(6, '丰台区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 9, 10, 2, 11010400),
(7, '石景山区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 11, 12, 2, 11010500),
(8, '海淀区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 13, 14, 2, 11010600),
(9, '门头沟区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 15, 16, 2, 11010700),
(10, '房山区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 17, 18, 2, 11010800),
(11, '通州区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 19, 20, 2, 11010900),
(12, '顺义区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 21, 22, 2, 11011000),
(13, '昌平区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 23, 24, 2, 11011100),
(14, '大兴区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 25, 26, 2, 11011200),
(15, '怀柔区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 27, 28, 2, 11011300),
(16, '平谷区', 0, '2018-07-03 09:21:02', '2019-07-06 06:29:29', 29, 30, 2, 11011400),
(17, '密云区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 31, 32, 2, 11011500),
(18, '延庆区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 33, 34, 2, 11011600),
(19, '天津', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 37, 72, NULL, 12000000),
(20, '天津市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 38, 71, 19, 12010000),
(21, '和平区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 39, 40, 20, 12010100),
(22, '河东区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 41, 42, 20, 12010200),
(23, '河西区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 43, 44, 20, 12010300),
(24, '南开区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 45, 46, 20, 12010400),
(25, '河北区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 47, 48, 20, 12010500),
(26, '红桥区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 49, 50, 20, 12010600),
(27, '东丽区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 51, 52, 20, 12010700),
(28, '西青区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 53, 54, 20, 12010800),
(29, '津南区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 55, 56, 20, 12010900),
(30, '北辰区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 57, 58, 20, 12011000),
(31, '武清区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 59, 60, 20, 12011100),
(32, '宝坻区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 61, 62, 20, 12011200),
(33, '滨海新区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 63, 64, 20, 12011300),
(34, '宁河区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 65, 66, 20, 12011400),
(35, '静海区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 67, 68, 20, 12011500),
(36, '蓟州区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 69, 70, 20, 12011600),
(37, '河北省', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 73, 436, NULL, 13000000),
(38, '石家庄市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 74, 117, 37, 13010000),
(39, '长安区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 75, 76, 38, 13010100),
(40, '桥西区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 77, 78, 38, 13010200),
(41, '新华区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 79, 80, 38, 13010300),
(42, '井陉矿区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 81, 82, 38, 13010400),
(43, '裕华区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 83, 84, 38, 13010500),
(44, '藁城区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 85, 86, 38, 13010600),
(45, '鹿泉区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 87, 88, 38, 13010700),
(46, '栾城区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 89, 90, 38, 13010800),
(47, '井陉县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 91, 92, 38, 13010900),
(48, '正定县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 93, 94, 38, 13011000),
(49, '行唐县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 95, 96, 38, 13011100),
(50, '灵寿县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 97, 98, 38, 13011200),
(51, '高邑县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 99, 100, 38, 13011300),
(52, '深泽县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 101, 102, 38, 13011400),
(53, '赞皇县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 103, 104, 38, 13011500),
(54, '无极县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 105, 106, 38, 13011600),
(55, '平山县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 107, 108, 38, 13011700),
(56, '元氏县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 109, 110, 38, 13011800),
(57, '赵县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 111, 112, 38, 13011900),
(58, '晋州市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 113, 114, 38, 13012000),
(59, '新乐市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 115, 116, 38, 13012100),
(60, '唐山市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 118, 147, 37, 13020000),
(61, '路南区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 119, 120, 60, 13020100),
(62, '路北区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 121, 122, 60, 13020200),
(63, '古冶区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 123, 124, 60, 13020300),
(64, '开平区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 125, 126, 60, 13020400),
(65, '丰南区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 127, 128, 60, 13020500),
(66, '丰润区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 129, 130, 60, 13020600),
(67, '曹妃甸区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 131, 132, 60, 13020700),
(68, '滦县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 133, 134, 60, 13020800),
(69, '滦南县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 135, 136, 60, 13020900),
(70, '乐亭县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 137, 138, 60, 13021000),
(71, '迁西县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 139, 140, 60, 13021100),
(72, '玉田县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 141, 142, 60, 13021200),
(73, '遵化市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 143, 144, 60, 13021300),
(74, '迁安市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:29', 145, 146, 60, 13021400),
(75, '秦皇岛市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 148, 163, 37, 13030000),
(76, '海港区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 149, 150, 75, 13030100),
(77, '山海关区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 151, 152, 75, 13030200),
(78, '北戴河区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 153, 154, 75, 13030300),
(79, '抚宁区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 155, 156, 75, 13030400),
(80, '青龙满族自治县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 157, 158, 75, 13030500),
(81, '昌黎县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 159, 160, 75, 13030600),
(82, '卢龙县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 161, 162, 75, 13030700),
(83, '邯郸市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 164, 203, 37, 13040000),
(84, '邯山区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 165, 166, 83, 13040100),
(85, '丛台区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 167, 168, 83, 13040200),
(86, '复兴区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 169, 170, 83, 13040300),
(87, '峰峰矿区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 171, 172, 83, 13040400),
(88, '邯郸县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 173, 174, 83, 13040500),
(89, '临漳县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 175, 176, 83, 13040600),
(90, '成安县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 177, 178, 83, 13040700),
(91, '大名县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 179, 180, 83, 13040800),
(92, '涉县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 181, 182, 83, 13040900),
(93, '磁县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 183, 184, 83, 13041000),
(94, '肥乡县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 185, 186, 83, 13041100),
(95, '永年县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 187, 188, 83, 13041200),
(96, '邱县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 189, 190, 83, 13041300),
(97, '鸡泽县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 191, 192, 83, 13041400),
(98, '广平县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 193, 194, 83, 13041500),
(99, '馆陶县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 195, 196, 83, 13041600),
(100, '魏县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 197, 198, 83, 13041700),
(101, '曲周县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 199, 200, 83, 13041800),
(102, '武安市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 201, 202, 83, 13041900),
(103, '邢台市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 204, 243, 37, 13050000),
(104, '桥东区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 205, 206, 103, 13050100),
(105, '桥西区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 207, 208, 103, 13050200),
(106, '邢台县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 209, 210, 103, 13050300),
(107, '临城县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 211, 212, 103, 13050400),
(108, '内丘县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 213, 214, 103, 13050500),
(109, '柏乡县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 215, 216, 103, 13050600),
(110, '隆尧县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 217, 218, 103, 13050700),
(111, '任县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 219, 220, 103, 13050800),
(112, '南和县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 221, 222, 103, 13050900),
(113, '宁晋县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 223, 224, 103, 13051000),
(114, '巨鹿县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 225, 226, 103, 13051100),
(115, '新河县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 227, 228, 103, 13051200),
(116, '广宗县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 229, 230, 103, 13051300),
(117, '平乡县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 231, 232, 103, 13051400),
(118, '威县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 233, 234, 103, 13051500),
(119, '清河县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 235, 236, 103, 13051600),
(120, '临西县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 237, 238, 103, 13051700),
(121, '南宫市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 239, 240, 103, 13051800),
(122, '沙河市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 241, 242, 103, 13051900),
(123, '保定市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 244, 291, 37, 13060000),
(124, '竞秀区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 245, 246, 123, 13060100),
(125, '莲池区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 247, 248, 123, 13060200),
(126, '满城区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 249, 250, 123, 13060300),
(127, '清苑区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 251, 252, 123, 13060400),
(128, '徐水区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 253, 254, 123, 13060500),
(129, '涞水县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 255, 256, 123, 13060600),
(130, '阜平县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 257, 258, 123, 13060700),
(131, '定兴县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 259, 260, 123, 13060800),
(132, '唐县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 261, 262, 123, 13060900),
(133, '高阳县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 263, 264, 123, 13061000),
(134, '容城县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 265, 266, 123, 13061100),
(135, '涞源县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 267, 268, 123, 13061200),
(136, '望都县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 269, 270, 123, 13061300),
(137, '安新县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 271, 272, 123, 13061400),
(138, '易县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 273, 274, 123, 13061500),
(139, '曲阳县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 275, 276, 123, 13061600),
(140, '蠡县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 277, 278, 123, 13061700),
(141, '顺平县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 279, 280, 123, 13061800),
(142, '博野县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 281, 282, 123, 13061900),
(143, '雄县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 283, 284, 123, 13062000),
(144, '涿州市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 285, 286, 123, 13062100),
(145, '安国市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 287, 288, 123, 13062200),
(146, '高碑店市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 289, 290, 123, 13062300),
(147, '张家口市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 292, 325, 37, 13070000),
(148, '桥东区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 293, 294, 147, 13070100),
(149, '桥西区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 295, 296, 147, 13070200),
(150, '宣化区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 297, 298, 147, 13070300),
(151, '下花园区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 299, 300, 147, 13070400),
(152, '万全区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 301, 302, 147, 13070500),
(153, '崇礼区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 303, 304, 147, 13070600),
(154, '张北县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 305, 306, 147, 13070700),
(155, '康保县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 307, 308, 147, 13070800),
(156, '沽源县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 309, 310, 147, 13070900),
(157, '尚义县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 311, 312, 147, 13071000),
(158, '蔚县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 313, 314, 147, 13071100),
(159, '阳原县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 315, 316, 147, 13071200),
(160, '怀安县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 317, 318, 147, 13071300),
(161, '怀来县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 319, 320, 147, 13071400),
(162, '涿鹿县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 321, 322, 147, 13071500),
(163, '赤城县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 323, 324, 147, 13071600),
(164, '承德市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 326, 349, 37, 13080000),
(165, '双桥区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 327, 328, 164, 13080100),
(166, '双滦区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 329, 330, 164, 13080200),
(167, '鹰手营子矿区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 331, 332, 164, 13080300),
(168, '承德县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 333, 334, 164, 13080400),
(169, '兴隆县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 335, 336, 164, 13080500),
(170, '平泉县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 337, 338, 164, 13080600),
(171, '滦平县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 339, 340, 164, 13080700),
(172, '隆化县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 341, 342, 164, 13080800),
(173, '丰宁满族自治县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 343, 344, 164, 13080900),
(174, '宽城满族自治县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 345, 346, 164, 13081000),
(175, '围场满族蒙古族自治县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 347, 348, 164, 13081100),
(176, '沧州市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 350, 383, 37, 13090000),
(177, '新华区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 351, 352, 176, 13090100),
(178, '运河区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 353, 354, 176, 13090200),
(179, '沧县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 355, 356, 176, 13090300),
(180, '青县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 357, 358, 176, 13090400),
(181, '东光县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 359, 360, 176, 13090500),
(182, '海兴县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 361, 362, 176, 13090600),
(183, '盐山县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 363, 364, 176, 13090700),
(184, '肃宁县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 365, 366, 176, 13090800),
(185, '南皮县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 367, 368, 176, 13090900),
(186, '吴桥县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 369, 370, 176, 13091000),
(187, '献县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 371, 372, 176, 13091100),
(188, '孟村回族自治县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 373, 374, 176, 13091200),
(189, '泊头市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 375, 376, 176, 13091300),
(190, '任丘市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 377, 378, 176, 13091400),
(191, '黄骅市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 379, 380, 176, 13091500),
(192, '河间市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 381, 382, 176, 13091600),
(193, '廊坊市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 384, 405, 37, 13100000),
(194, '安次区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 385, 386, 193, 13100100),
(195, '广阳区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 387, 388, 193, 13100200),
(196, '固安县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 389, 390, 193, 13100300),
(197, '永清县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 391, 392, 193, 13100400),
(198, '香河县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 393, 394, 193, 13100500),
(199, '大城县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 395, 396, 193, 13100600),
(200, '文安县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 397, 398, 193, 13100700),
(201, '大厂回族自治县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 399, 400, 193, 13100800),
(202, '霸州市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 401, 402, 193, 13100900),
(203, '三河市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 403, 404, 193, 13101000),
(204, '衡水市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 406, 429, 37, 13110000),
(205, '桃城区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 407, 408, 204, 13110100),
(206, '冀州区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 409, 410, 204, 13110200),
(207, '枣强县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 411, 412, 204, 13110300),
(208, '武邑县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 413, 414, 204, 13110400),
(209, '武强县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 415, 416, 204, 13110500),
(210, '饶阳县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 417, 418, 204, 13110600),
(211, '安平县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 419, 420, 204, 13110700),
(212, '故城县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 421, 422, 204, 13110800),
(213, '景县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 423, 424, 204, 13110900),
(214, '阜城县', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 425, 426, 204, 13111000),
(215, '深州市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 427, 428, 204, 13111100),
(216, '省直辖县级行政区划', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 430, 435, 37, 13120000),
(217, '定州市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 431, 432, 216, 13120100),
(218, '辛集市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 433, 434, 216, 13120200),
(219, '山西省', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 437, 698, NULL, 14000000),
(220, '太原市', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 438, 459, 219, 14010000),
(221, '小店区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 439, 440, 220, 14010100),
(222, '迎泽区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 441, 442, 220, 14010200),
(223, '杏花岭区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 443, 444, 220, 14010300),
(224, '尖草坪区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 445, 446, 220, 14010400),
(225, '万柏林区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 447, 448, 220, 14010500),
(226, '晋源区', 0, '2018-07-03 09:21:03', '2019-07-06 06:29:30', 449, 450, 220, 14010600),
(227, '清徐县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 451, 452, 220, 14010700),
(228, '阳曲县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 453, 454, 220, 14010800),
(229, '娄烦县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 455, 456, 220, 14010900),
(230, '古交市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 457, 458, 220, 14011000),
(231, '大同市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 460, 483, 219, 14020000),
(232, '城区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 461, 462, 231, 14020100),
(233, '矿区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 463, 464, 231, 14020200),
(234, '南郊区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 465, 466, 231, 14020300),
(235, '新荣区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 467, 468, 231, 14020400),
(236, '阳高县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 469, 470, 231, 14020500),
(237, '天镇县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 471, 472, 231, 14020600),
(238, '广灵县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 473, 474, 231, 14020700),
(239, '灵丘县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 475, 476, 231, 14020800),
(240, '浑源县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 477, 478, 231, 14020900),
(241, '左云县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 479, 480, 231, 14021000),
(242, '大同县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 481, 482, 231, 14021100),
(243, '阳泉市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 484, 495, 219, 14030000),
(244, '城区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 485, 486, 243, 14030100),
(245, '矿区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 487, 488, 243, 14030200),
(246, '郊区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 489, 490, 243, 14030300),
(247, '平定县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 491, 492, 243, 14030400),
(248, '盂县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 493, 494, 243, 14030500),
(249, '长治市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 496, 523, 219, 14040000),
(250, '城区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 497, 498, 249, 14040100),
(251, '郊区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 499, 500, 249, 14040200),
(252, '长治县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 501, 502, 249, 14040300),
(253, '襄垣县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 503, 504, 249, 14040400),
(254, '屯留县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 505, 506, 249, 14040500),
(255, '平顺县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 507, 508, 249, 14040600),
(256, '黎城县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 509, 510, 249, 14040700),
(257, '壶关县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 511, 512, 249, 14040800),
(258, '长子县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 513, 514, 249, 14040900),
(259, '武乡县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 515, 516, 249, 14041000),
(260, '沁县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 517, 518, 249, 14041100),
(261, '沁源县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 519, 520, 249, 14041200),
(262, '潞城市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 521, 522, 249, 14041300),
(263, '晋城市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 524, 537, 219, 14050000),
(264, '城区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 525, 526, 263, 14050100),
(265, '沁水县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 527, 528, 263, 14050200),
(266, '阳城县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 529, 530, 263, 14050300),
(267, '陵川县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 531, 532, 263, 14050400),
(268, '泽州县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 533, 534, 263, 14050500),
(269, '高平市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 535, 536, 263, 14050600),
(270, '朔州市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 538, 551, 219, 14060000),
(271, '朔城区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 539, 540, 270, 14060100),
(272, '平鲁区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 541, 542, 270, 14060200),
(273, '山阴县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 543, 544, 270, 14060300),
(274, '应县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 545, 546, 270, 14060400),
(275, '右玉县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 547, 548, 270, 14060500),
(276, '怀仁县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 549, 550, 270, 14060600),
(277, '晋中市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 552, 575, 219, 14070000),
(278, '榆次区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 553, 554, 277, 14070100),
(279, '榆社县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 555, 556, 277, 14070200),
(280, '左权县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 557, 558, 277, 14070300),
(281, '和顺县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 559, 560, 277, 14070400),
(282, '昔阳县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 561, 562, 277, 14070500),
(283, '寿阳县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 563, 564, 277, 14070600),
(284, '太谷县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 565, 566, 277, 14070700),
(285, '祁县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 567, 568, 277, 14070800),
(286, '平遥县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 569, 570, 277, 14070900),
(287, '灵石县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 571, 572, 277, 14071000),
(288, '介休市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 573, 574, 277, 14071100),
(289, '运城市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 576, 603, 219, 14080000),
(290, '盐湖区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 577, 578, 289, 14080100),
(291, '临猗县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 579, 580, 289, 14080200),
(292, '万荣县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 581, 582, 289, 14080300),
(293, '闻喜县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 583, 584, 289, 14080400),
(294, '稷山县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 585, 586, 289, 14080500),
(295, '新绛县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 587, 588, 289, 14080600),
(296, '绛县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 589, 590, 289, 14080700),
(297, '垣曲县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 591, 592, 289, 14080800),
(298, '夏县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 593, 594, 289, 14080900),
(299, '平陆县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 595, 596, 289, 14081000),
(300, '芮城县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 597, 598, 289, 14081100),
(301, '永济市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 599, 600, 289, 14081200),
(302, '河津市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 601, 602, 289, 14081300),
(303, '忻州市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 604, 633, 219, 14090000),
(304, '忻府区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 605, 606, 303, 14090100),
(305, '定襄县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 607, 608, 303, 14090200),
(306, '五台县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 609, 610, 303, 14090300),
(307, '代县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 611, 612, 303, 14090400),
(308, '繁峙县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 613, 614, 303, 14090500),
(309, '宁武县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 615, 616, 303, 14090600),
(310, '静乐县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 617, 618, 303, 14090700),
(311, '神池县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 619, 620, 303, 14090800),
(312, '五寨县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 621, 622, 303, 14090900),
(313, '岢岚县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:30', 623, 624, 303, 14091000),
(314, '河曲县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 625, 626, 303, 14091100),
(315, '保德县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 627, 628, 303, 14091200),
(316, '偏关县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 629, 630, 303, 14091300),
(317, '原平市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 631, 632, 303, 14091400),
(318, '临汾市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 634, 669, 219, 14100000),
(319, '尧都区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 635, 636, 318, 14100100),
(320, '曲沃县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 637, 638, 318, 14100200),
(321, '翼城县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 639, 640, 318, 14100300),
(322, '襄汾县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 641, 642, 318, 14100400),
(323, '洪洞县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 643, 644, 318, 14100500),
(324, '古县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 645, 646, 318, 14100600),
(325, '安泽县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 647, 648, 318, 14100700),
(326, '浮山县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 649, 650, 318, 14100800),
(327, '吉县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 651, 652, 318, 14100900),
(328, '乡宁县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 653, 654, 318, 14101000),
(329, '大宁县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 655, 656, 318, 14101100),
(330, '隰县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 657, 658, 318, 14101200),
(331, '永和县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 659, 660, 318, 14101300),
(332, '蒲县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 661, 662, 318, 14101400),
(333, '汾西县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 663, 664, 318, 14101500),
(334, '侯马市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 665, 666, 318, 14101600),
(335, '霍州市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 667, 668, 318, 14101700),
(336, '吕梁市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 670, 697, 219, 14110000),
(337, '离石区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 671, 672, 336, 14110100),
(338, '文水县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 673, 674, 336, 14110200),
(339, '交城县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 675, 676, 336, 14110300),
(340, '兴县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 677, 678, 336, 14110400),
(341, '临县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 679, 680, 336, 14110500),
(342, '柳林县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 681, 682, 336, 14110600),
(343, '石楼县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 683, 684, 336, 14110700),
(344, '岚县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 685, 686, 336, 14110800),
(345, '方山县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 687, 688, 336, 14110900),
(346, '中阳县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 689, 690, 336, 14111000),
(347, '交口县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 691, 692, 336, 14111100),
(348, '孝义市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 693, 694, 336, 14111200),
(349, '汾阳市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 695, 696, 336, 14111300),
(350, '内蒙古自治区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 699, 930, NULL, 15000000),
(351, '呼和浩特市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 700, 719, 350, 15010000),
(352, '新城区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 701, 702, 351, 15010100),
(353, '回民区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 703, 704, 351, 15010200),
(354, '玉泉区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 705, 706, 351, 15010300),
(355, '赛罕区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 707, 708, 351, 15010400),
(356, '土默特左旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 709, 710, 351, 15010500),
(357, '托克托县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 711, 712, 351, 15010600),
(358, '和林格尔县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 713, 714, 351, 15010700),
(359, '清水河县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 715, 716, 351, 15010800),
(360, '武川县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 717, 718, 351, 15010900),
(361, '包头市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 720, 739, 350, 15020000),
(362, '东河区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 721, 722, 361, 15020100),
(363, '昆都仑区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 723, 724, 361, 15020200),
(364, '青山区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 725, 726, 361, 15020300),
(365, '石拐区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 727, 728, 361, 15020400),
(366, '白云鄂博矿区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 729, 730, 361, 15020500),
(367, '九原区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 731, 732, 361, 15020600),
(368, '土默特右旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 733, 734, 361, 15020700),
(369, '固阳县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 735, 736, 361, 15020800),
(370, '达尔罕茂明安联合旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 737, 738, 361, 15020900),
(371, '乌海市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 740, 747, 350, 15030000),
(372, '海勃湾区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 741, 742, 371, 15030100),
(373, '海南区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 743, 744, 371, 15030200),
(374, '乌达区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 745, 746, 371, 15030300),
(375, '赤峰市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 748, 773, 350, 15040000),
(376, '红山区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 749, 750, 375, 15040100),
(377, '元宝山区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 751, 752, 375, 15040200),
(378, '松山区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 753, 754, 375, 15040300),
(379, '阿鲁科尔沁旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 755, 756, 375, 15040400),
(380, '巴林左旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 757, 758, 375, 15040500),
(381, '巴林右旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 759, 760, 375, 15040600),
(382, '林西县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 761, 762, 375, 15040700),
(383, '克什克腾旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 763, 764, 375, 15040800),
(384, '翁牛特旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 765, 766, 375, 15040900),
(385, '喀喇沁旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 767, 768, 375, 15041000),
(386, '宁城县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 769, 770, 375, 15041100),
(387, '敖汉旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 771, 772, 375, 15041200),
(388, '通辽市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 774, 791, 350, 15050000),
(389, '科尔沁区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 775, 776, 388, 15050100),
(390, '科尔沁左翼中旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 777, 778, 388, 15050200),
(391, '科尔沁左翼后旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 779, 780, 388, 15050300),
(392, '开鲁县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 781, 782, 388, 15050400),
(393, '库伦旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 783, 784, 388, 15050500),
(394, '奈曼旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 785, 786, 388, 15050600),
(395, '扎鲁特旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 787, 788, 388, 15050700),
(396, '霍林郭勒市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 789, 790, 388, 15050800),
(397, '鄂尔多斯市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 792, 811, 350, 15060000),
(398, '东胜区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 793, 794, 397, 15060100),
(399, '康巴什区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 795, 796, 397, 15060200),
(400, '达拉特旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 797, 798, 397, 15060300),
(401, '准格尔旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 799, 800, 397, 15060400),
(402, '鄂托克前旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 801, 802, 397, 15060500),
(403, '鄂托克旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 803, 804, 397, 15060600),
(404, '杭锦旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 805, 806, 397, 15060700),
(405, '乌审旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 807, 808, 397, 15060800),
(406, '伊金霍洛旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 809, 810, 397, 15060900),
(407, '呼伦贝尔市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 812, 841, 350, 15070000),
(408, '海拉尔区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 813, 814, 407, 15070100),
(409, '扎赉诺尔区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 815, 816, 407, 15070200),
(410, '阿荣旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 817, 818, 407, 15070300),
(411, '莫力达瓦达斡尔族自治旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 819, 820, 407, 15070400),
(412, '鄂伦春自治旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 821, 822, 407, 15070500),
(413, '鄂温克族自治旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 823, 824, 407, 15070600),
(414, '陈巴尔虎旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 825, 826, 407, 15070700),
(415, '新巴尔虎左旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 827, 828, 407, 15070800),
(416, '新巴尔虎右旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 829, 830, 407, 15070900),
(417, '满洲里市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 831, 832, 407, 15071000),
(418, '牙克石市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 833, 834, 407, 15071100),
(419, '扎兰屯市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 835, 836, 407, 15071200),
(420, '额尔古纳市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 837, 838, 407, 15071300),
(421, '根河市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 839, 840, 407, 15071400),
(422, '巴彦淖尔市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 842, 857, 350, 15080000),
(423, '临河区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 843, 844, 422, 15080100),
(424, '五原县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 845, 846, 422, 15080200),
(425, '磴口县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 847, 848, 422, 15080300),
(426, '乌拉特前旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 849, 850, 422, 15080400),
(427, '乌拉特中旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 851, 852, 422, 15080500),
(428, '乌拉特后旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 853, 854, 422, 15080600),
(429, '杭锦后旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 855, 856, 422, 15080700),
(430, '乌兰察布市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 858, 881, 350, 15090000),
(431, '集宁区', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 859, 860, 430, 15090100),
(432, '卓资县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 861, 862, 430, 15090200),
(433, '化德县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 863, 864, 430, 15090300),
(434, '商都县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 865, 866, 430, 15090400),
(435, '兴和县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 867, 868, 430, 15090500),
(436, '凉城县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 869, 870, 430, 15090600),
(437, '察哈尔右翼前旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 871, 872, 430, 15090700),
(438, '察哈尔右翼中旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 873, 874, 430, 15090800),
(439, '察哈尔右翼后旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 875, 876, 430, 15090900),
(440, '四子王旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 877, 878, 430, 15091000),
(441, '丰镇市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 879, 880, 430, 15091100),
(442, '兴安盟', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 882, 895, 350, 15100000),
(443, '乌兰浩特市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 883, 884, 442, 15100100),
(444, '阿尔山市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 885, 886, 442, 15100200),
(445, '科尔沁右翼前旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 887, 888, 442, 15100300),
(446, '科尔沁右翼中旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 889, 890, 442, 15100400),
(447, '扎赉特旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 891, 892, 442, 15100500),
(448, '突泉县', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 893, 894, 442, 15100600),
(449, '锡林郭勒盟', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 896, 921, 350, 15110000),
(450, '二连浩特市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 897, 898, 449, 15110100),
(451, '锡林浩特市', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 899, 900, 449, 15110200),
(452, '阿巴嘎旗', 0, '2018-07-03 09:21:04', '2019-07-06 06:29:31', 901, 902, 449, 15110300),
(453, '苏尼特左旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 903, 904, 449, 15110400),
(454, '苏尼特右旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 905, 906, 449, 15110500),
(455, '东乌珠穆沁旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 907, 908, 449, 15110600),
(456, '西乌珠穆沁旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 909, 910, 449, 15110700),
(457, '太仆寺旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 911, 912, 449, 15110800),
(458, '镶黄旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 913, 914, 449, 15110900),
(459, '正镶白旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 915, 916, 449, 15111000),
(460, '正蓝旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 917, 918, 449, 15111100),
(461, '多伦县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 919, 920, 449, 15111200),
(462, '阿拉善盟', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 922, 929, 350, 15120000),
(463, '阿拉善左旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 923, 924, 462, 15120100),
(464, '阿拉善右旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 925, 926, 462, 15120200),
(465, '额济纳旗', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 927, 928, 462, 15120300),
(466, '辽宁省', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 931, 1160, NULL, 16000000),
(467, '沈阳市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 932, 959, 466, 16010000),
(468, '和平区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 933, 934, 467, 16010100),
(469, '沈河区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 935, 936, 467, 16010200),
(470, '大东区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 937, 938, 467, 16010300),
(471, '皇姑区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 939, 940, 467, 16010400),
(472, '铁西区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 941, 942, 467, 16010500),
(473, '苏家屯区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 943, 944, 467, 16010600),
(474, '浑南区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 945, 946, 467, 16010700),
(475, '沈北新区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 947, 948, 467, 16010800),
(476, '于洪区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 949, 950, 467, 16010900),
(477, '辽中区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 951, 952, 467, 16011000),
(478, '康平县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 953, 954, 467, 16011100),
(479, '法库县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 955, 956, 467, 16011200),
(480, '新民市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 957, 958, 467, 16011300),
(481, '大连市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 960, 981, 466, 16020000),
(482, '中山区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 961, 962, 481, 16020100),
(483, '西岗区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 963, 964, 481, 16020200),
(484, '沙河口区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 965, 966, 481, 16020300),
(485, '甘井子区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 967, 968, 481, 16020400),
(486, '旅顺口区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 969, 970, 481, 16020500),
(487, '金州区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 971, 972, 481, 16020600),
(488, '普兰店区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 973, 974, 481, 16020700),
(489, '长海县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 975, 976, 481, 16020800),
(490, '瓦房店市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 977, 978, 481, 16020900),
(491, '庄河市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 979, 980, 481, 16021000),
(492, '鞍山市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 982, 997, 466, 16030000),
(493, '铁东区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 983, 984, 492, 16030100),
(494, '铁西区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 985, 986, 492, 16030200),
(495, '立山区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 987, 988, 492, 16030300),
(496, '千山区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 989, 990, 492, 16030400),
(497, '台安县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 991, 992, 492, 16030500),
(498, '岫岩满族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 993, 994, 492, 16030600),
(499, '海城市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 995, 996, 492, 16030700),
(500, '抚顺市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 998, 1013, 466, 16040000),
(501, '新抚区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 999, 1000, 500, 16040100),
(502, '东洲区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1001, 1002, 500, 16040200),
(503, '望花区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1003, 1004, 500, 16040300),
(504, '顺城区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1005, 1006, 500, 16040400),
(505, '抚顺县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1007, 1008, 500, 16040500),
(506, '新宾满族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1009, 1010, 500, 16040600),
(507, '清原满族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1011, 1012, 500, 16040700),
(508, '本溪市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1014, 1027, 466, 16050000),
(509, '平山区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1015, 1016, 508, 16050100),
(510, '溪湖区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1017, 1018, 508, 16050200),
(511, '明山区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1019, 1020, 508, 16050300),
(512, '南芬区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1021, 1022, 508, 16050400),
(513, '本溪满族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1023, 1024, 508, 16050500),
(514, '桓仁满族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1025, 1026, 508, 16050600),
(515, '丹东市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1028, 1041, 466, 16060000),
(516, '元宝区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1029, 1030, 515, 16060100),
(517, '振兴区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1031, 1032, 515, 16060200),
(518, '振安区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1033, 1034, 515, 16060300),
(519, '宽甸满族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1035, 1036, 515, 16060400),
(520, '东港市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1037, 1038, 515, 16060500),
(521, '凤城市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1039, 1040, 515, 16060600),
(522, '锦州市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1042, 1057, 466, 16070000),
(523, '古塔区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1043, 1044, 522, 16070100),
(524, '凌河区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1045, 1046, 522, 16070200),
(525, '太和区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1047, 1048, 522, 16070300),
(526, '黑山县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1049, 1050, 522, 16070400),
(527, '义县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1051, 1052, 522, 16070500),
(528, '凌海市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1053, 1054, 522, 16070600),
(529, '北镇市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1055, 1056, 522, 16070700),
(530, '营口市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1058, 1071, 466, 16080000),
(531, '站前区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1059, 1060, 530, 16080100),
(532, '西市区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1061, 1062, 530, 16080200),
(533, '鲅鱼圈区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1063, 1064, 530, 16080300),
(534, '老边区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1065, 1066, 530, 16080400),
(535, '盖州市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1067, 1068, 530, 16080500),
(536, '大石桥市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1069, 1070, 530, 16080600),
(537, '阜新市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1072, 1087, 466, 16090000),
(538, '海州区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1073, 1074, 537, 16090100),
(539, '新邱区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1075, 1076, 537, 16090200),
(540, '太平区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1077, 1078, 537, 16090300),
(541, '清河门区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1079, 1080, 537, 16090400),
(542, '细河区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1081, 1082, 537, 16090500),
(543, '阜新蒙古族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:31', 1083, 1084, 537, 16090600),
(544, '彰武县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1085, 1086, 537, 16090700),
(545, '辽阳市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1088, 1103, 466, 16100000),
(546, '白塔区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1089, 1090, 545, 16100100),
(547, '文圣区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1091, 1092, 545, 16100200),
(548, '宏伟区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1093, 1094, 545, 16100300),
(549, '弓长岭区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1095, 1096, 545, 16100400),
(550, '太子河区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1097, 1098, 545, 16100500),
(551, '辽阳县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1099, 1100, 545, 16100600),
(552, '灯塔市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1101, 1102, 545, 16100700),
(553, '盘锦市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1104, 1113, 466, 16110000),
(554, '双台子区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1105, 1106, 553, 16110100),
(555, '兴隆台区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1107, 1108, 553, 16110200),
(556, '大洼区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1109, 1110, 553, 16110300),
(557, '盘山县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1111, 1112, 553, 16110400),
(558, '铁岭市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1114, 1129, 466, 16120000),
(559, '银州区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1115, 1116, 558, 16120100),
(560, '清河区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1117, 1118, 558, 16120200),
(561, '铁岭县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1119, 1120, 558, 16120300),
(562, '西丰县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1121, 1122, 558, 16120400),
(563, '昌图县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1123, 1124, 558, 16120500),
(564, '调兵山市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1125, 1126, 558, 16120600),
(565, '开原市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1127, 1128, 558, 16120700),
(566, '朝阳市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1130, 1145, 466, 16130000),
(567, '双塔区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1131, 1132, 566, 16130100),
(568, '龙城区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1133, 1134, 566, 16130200),
(569, '朝阳县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1135, 1136, 566, 16130300),
(570, '建平县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1137, 1138, 566, 16130400),
(571, '喀喇沁左翼蒙古族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1139, 1140, 566, 16130500),
(572, '北票市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1141, 1142, 566, 16130600),
(573, '凌源市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1143, 1144, 566, 16130700),
(574, '葫芦岛市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1146, 1159, 466, 16140000),
(575, '连山区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1147, 1148, 574, 16140100),
(576, '龙港区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1149, 1150, 574, 16140200),
(577, '南票区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1151, 1152, 574, 16140300),
(578, '绥中县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1153, 1154, 574, 16140400),
(579, '建昌县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1155, 1156, 574, 16140500);";
        $sql2 = "INSERT INTO `area` (`id`, `name`, `disabled`, `created_at`, `updated_at`, `_lft`, `_rgt`, `parent_id`, `code`) VALUES
(580, '兴城市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1157, 1158, 574, 16140600),
(581, '吉林省', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1161, 1300, NULL, 17000000),
(582, '长春市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1162, 1183, 581, 17010000),
(583, '南关区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1163, 1164, 582, 17010100),
(584, '宽城区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1165, 1166, 582, 17010200),
(585, '朝阳区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1167, 1168, 582, 17010300),
(586, '二道区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1169, 1170, 582, 17010400),
(587, '绿园区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1171, 1172, 582, 17010500),
(588, '双阳区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1173, 1174, 582, 17010600),
(589, '九台区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1175, 1176, 582, 17010700),
(590, '农安县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1177, 1178, 582, 17010800),
(591, '榆树市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1179, 1180, 582, 17010900),
(592, '德惠市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1181, 1182, 582, 17011000),
(593, '吉林市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1184, 1203, 581, 17020000),
(594, '昌邑区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1185, 1186, 593, 17020100),
(595, '龙潭区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1187, 1188, 593, 17020200),
(596, '船营区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1189, 1190, 593, 17020300),
(597, '丰满区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1191, 1192, 593, 17020400),
(598, '永吉县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1193, 1194, 593, 17020500),
(599, '蛟河市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1195, 1196, 593, 17020600),
(600, '桦甸市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1197, 1198, 593, 17020700),
(601, '舒兰市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1199, 1200, 593, 17020800),
(602, '磐石市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1201, 1202, 593, 17020900),
(603, '四平市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1204, 1217, 581, 17030000),
(604, '铁西区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1205, 1206, 603, 17030100),
(605, '铁东区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1207, 1208, 603, 17030200),
(606, '梨树县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1209, 1210, 603, 17030300),
(607, '伊通满族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1211, 1212, 603, 17030400),
(608, '公主岭市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1213, 1214, 603, 17030500),
(609, '双辽市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1215, 1216, 603, 17030600),
(610, '辽源市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1218, 1227, 581, 17040000),
(611, '龙山区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1219, 1220, 610, 17040100),
(612, '西安区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1221, 1222, 610, 17040200),
(613, '东丰县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1223, 1224, 610, 17040300),
(614, '东辽县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1225, 1226, 610, 17040400),
(615, '通化市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1228, 1243, 581, 17050000),
(616, '东昌区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1229, 1230, 615, 17050100),
(617, '二道江区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1231, 1232, 615, 17050200),
(618, '通化县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1233, 1234, 615, 17050300),
(619, '辉南县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1235, 1236, 615, 17050400),
(620, '柳河县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1237, 1238, 615, 17050500),
(621, '梅河口市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1239, 1240, 615, 17050600),
(622, '集安市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1241, 1242, 615, 17050700),
(623, '白山市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1244, 1257, 581, 17060000),
(624, '浑江区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1245, 1246, 623, 17060100),
(625, '江源区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1247, 1248, 623, 17060200),
(626, '抚松县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1249, 1250, 623, 17060300),
(627, '靖宇县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1251, 1252, 623, 17060400),
(628, '长白朝鲜族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1253, 1254, 623, 17060500),
(629, '临江市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1255, 1256, 623, 17060600),
(630, '松原市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1258, 1269, 581, 17070000),
(631, '宁江区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1259, 1260, 630, 17070100),
(632, '前郭尔罗斯蒙古族自治县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1261, 1262, 630, 17070200),
(633, '长岭县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1263, 1264, 630, 17070300),
(634, '乾安县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1265, 1266, 630, 17070400),
(635, '扶余市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1267, 1268, 630, 17070500),
(636, '白城市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1270, 1281, 581, 17080000),
(637, '洮北区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1271, 1272, 636, 17080100),
(638, '镇赉县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1273, 1274, 636, 17080200),
(639, '通榆县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1275, 1276, 636, 17080300),
(640, '洮南市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1277, 1278, 636, 17080400),
(641, '大安市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1279, 1280, 636, 17080500),
(642, '延边朝鲜族自治州', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1282, 1299, 581, 17090000),
(643, '延吉市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1283, 1284, 642, 17090100),
(644, '图们市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1285, 1286, 642, 17090200),
(645, '敦化市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1287, 1288, 642, 17090300),
(646, '珲春市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1289, 1290, 642, 17090400),
(647, '龙井市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1291, 1292, 642, 17090500),
(648, '和龙市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1293, 1294, 642, 17090600),
(649, '汪清县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1295, 1296, 642, 17090700),
(650, '安图县', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1297, 1298, 642, 17090800),
(651, '黑龙江省', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1301, 1584, NULL, 18000000),
(652, '哈尔滨市', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1302, 1339, 651, 18010000),
(653, '道里区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1303, 1304, 652, 18010100),
(654, '南岗区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1305, 1306, 652, 18010200),
(655, '道外区', 0, '2018-07-03 09:21:05', '2019-07-06 06:29:32', 1307, 1308, 652, 18010300),
(656, '平房区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1309, 1310, 652, 18010400),
(657, '松北区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1311, 1312, 652, 18010500),
(658, '香坊区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1313, 1314, 652, 18010600),
(659, '呼兰区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1315, 1316, 652, 18010700),
(660, '阿城区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1317, 1318, 652, 18010800),
(661, '双城区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1319, 1320, 652, 18010900),
(662, '依兰县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1321, 1322, 652, 18011000),
(663, '方正县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1323, 1324, 652, 18011100),
(664, '宾县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1325, 1326, 652, 18011200),
(665, '巴彦县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1327, 1328, 652, 18011300),
(666, '木兰县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1329, 1330, 652, 18011400),
(667, '通河县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1331, 1332, 652, 18011500),
(668, '延寿县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1333, 1334, 652, 18011600),
(669, '尚志市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1335, 1336, 652, 18011700),
(670, '五常市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1337, 1338, 652, 18011800),
(671, '齐齐哈尔市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1340, 1373, 651, 18020000),
(672, '龙沙区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1341, 1342, 671, 18020100),
(673, '建华区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1343, 1344, 671, 18020200),
(674, '铁锋区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1345, 1346, 671, 18020300),
(675, '昂昂溪区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1347, 1348, 671, 18020400),
(676, '富拉尔基区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1349, 1350, 671, 18020500),
(677, '碾子山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1351, 1352, 671, 18020600),
(678, '梅里斯达斡尔族区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1353, 1354, 671, 18020700),
(679, '龙江县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1355, 1356, 671, 18020800),
(680, '依安县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1357, 1358, 671, 18020900),
(681, '泰来县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1359, 1360, 671, 18021000),
(682, '甘南县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1361, 1362, 671, 18021100),
(683, '富裕县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1363, 1364, 671, 18021200),
(684, '克山县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1365, 1366, 671, 18021300),
(685, '克东县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1367, 1368, 671, 18021400),
(686, '拜泉县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1369, 1370, 671, 18021500),
(687, '讷河市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1371, 1372, 671, 18021600),
(688, '鸡西市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1374, 1393, 651, 18030000),
(689, '鸡冠区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1375, 1376, 688, 18030100),
(690, '恒山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1377, 1378, 688, 18030200),
(691, '滴道区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1379, 1380, 688, 18030300),
(692, '梨树区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1381, 1382, 688, 18030400),
(693, '城子河区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1383, 1384, 688, 18030500),
(694, '麻山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1385, 1386, 688, 18030600),
(695, '鸡东县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1387, 1388, 688, 18030700),
(696, '虎林市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1389, 1390, 688, 18030800),
(697, '密山市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1391, 1392, 688, 18030900),
(698, '鹤岗市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1394, 1411, 651, 18040000),
(699, '向阳区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1395, 1396, 698, 18040100),
(700, '工农区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1397, 1398, 698, 18040200),
(701, '南山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1399, 1400, 698, 18040300),
(702, '兴安区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1401, 1402, 698, 18040400),
(703, '东山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1403, 1404, 698, 18040500),
(704, '兴山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1405, 1406, 698, 18040600),
(705, '萝北县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1407, 1408, 698, 18040700),
(706, '绥滨县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1409, 1410, 698, 18040800),
(707, '双鸭山市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1412, 1429, 651, 18050000),
(708, '尖山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1413, 1414, 707, 18050100),
(709, '岭东区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1415, 1416, 707, 18050200),
(710, '四方台区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1417, 1418, 707, 18050300),
(711, '宝山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1419, 1420, 707, 18050400),
(712, '集贤县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1421, 1422, 707, 18050500),
(713, '友谊县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1423, 1424, 707, 18050600),
(714, '宝清县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1425, 1426, 707, 18050700),
(715, '饶河县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1427, 1428, 707, 18050800),
(716, '大庆市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1430, 1449, 651, 18060000),
(717, '萨尔图区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1431, 1432, 716, 18060100),
(718, '龙凤区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1433, 1434, 716, 18060200),
(719, '让胡路区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1435, 1436, 716, 18060300),
(720, '红岗区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1437, 1438, 716, 18060400),
(721, '大同区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1439, 1440, 716, 18060500),
(722, '肇州县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1441, 1442, 716, 18060600),
(723, '肇源县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1443, 1444, 716, 18060700),
(724, '林甸县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1445, 1446, 716, 18060800),
(725, '杜尔伯特蒙古族自治县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1447, 1448, 716, 18060900),
(726, '伊春市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1450, 1485, 651, 18070000),
(727, '伊春区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1451, 1452, 726, 18070100),
(728, '南岔区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1453, 1454, 726, 18070200),
(729, '友好区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1455, 1456, 726, 18070300),
(730, '西林区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1457, 1458, 726, 18070400),
(731, '翠峦区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1459, 1460, 726, 18070500),
(732, '新青区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1461, 1462, 726, 18070600),
(733, '美溪区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1463, 1464, 726, 18070700),
(734, '金山屯区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1465, 1466, 726, 18070800),
(735, '五营区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1467, 1468, 726, 18070900),
(736, '乌马河区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1469, 1470, 726, 18071000),
(737, '汤旺河区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1471, 1472, 726, 18071100),
(738, '带岭区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1473, 1474, 726, 18071200),
(739, '乌伊岭区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1475, 1476, 726, 18071300),
(740, '红星区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1477, 1478, 726, 18071400),
(741, '上甘岭区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1479, 1480, 726, 18071500),
(742, '嘉荫县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1481, 1482, 726, 18071600),
(743, '铁力市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1483, 1484, 726, 18071700),
(744, '佳木斯市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1486, 1507, 651, 18080000),
(745, '向阳区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1487, 1488, 744, 18080100),
(746, '前进区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1489, 1490, 744, 18080200),
(747, '东风区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1491, 1492, 744, 18080300),
(748, '郊区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1493, 1494, 744, 18080400),
(749, '桦南县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1495, 1496, 744, 18080500),
(750, '桦川县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1497, 1498, 744, 18080600),
(751, '汤原县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1499, 1500, 744, 18080700),
(752, '同江市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1501, 1502, 744, 18080800),
(753, '富锦市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1503, 1504, 744, 18080900),
(754, '抚远市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1505, 1506, 744, 18081000),
(755, '七台河市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1508, 1517, 651, 18090000),
(756, '新兴区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1509, 1510, 755, 18090100),
(757, '桃山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1511, 1512, 755, 18090200),
(758, '茄子河区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1513, 1514, 755, 18090300),
(759, '勃利县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1515, 1516, 755, 18090400),
(760, '牡丹江市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1518, 1539, 651, 18100000),
(761, '东安区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1519, 1520, 760, 18100100),
(762, '阳明区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1521, 1522, 760, 18100200),
(763, '爱民区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1523, 1524, 760, 18100300),
(764, '西安区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1525, 1526, 760, 18100400),
(765, '林口县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1527, 1528, 760, 18100500),
(766, '绥芬河市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1529, 1530, 760, 18100600),
(767, '海林市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1531, 1532, 760, 18100700),
(768, '宁安市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1533, 1534, 760, 18100800),
(769, '穆棱市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1535, 1536, 760, 18100900),
(770, '东宁市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1537, 1538, 760, 18101000),
(771, '黑河市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1540, 1553, 651, 18110000),
(772, '爱辉区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1541, 1542, 771, 18110100),
(773, '嫩江县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1543, 1544, 771, 18110200),
(774, '逊克县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1545, 1546, 771, 18110300),
(775, '孙吴县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1547, 1548, 771, 18110400),
(776, '北安市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1549, 1550, 771, 18110500),
(777, '五大连池市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1551, 1552, 771, 18110600),
(778, '绥化市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1554, 1575, 651, 18120000),
(779, '北林区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1555, 1556, 778, 18120100),
(780, '望奎县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:32', 1557, 1558, 778, 18120200),
(781, '兰西县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1559, 1560, 778, 18120300),
(782, '青冈县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1561, 1562, 778, 18120400),
(783, '庆安县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1563, 1564, 778, 18120500),
(784, '明水县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1565, 1566, 778, 18120600),
(785, '绥棱县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1567, 1568, 778, 18120700),
(786, '安达市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1569, 1570, 778, 18120800),
(787, '肇东市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1571, 1572, 778, 18120900),
(788, '海伦市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1573, 1574, 778, 18121000),
(789, '大兴安岭地区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1576, 1583, 651, 18130000),
(790, '呼玛县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1577, 1578, 789, 18130100),
(791, '塔河县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1579, 1580, 789, 18130200),
(792, '漠河县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1581, 1582, 789, 18130300),
(793, '上海', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1585, 1620, NULL, 19000000),
(794, '上海市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1586, 1619, 793, 19010000),
(795, '黄浦区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1587, 1588, 794, 19010100),
(796, '徐汇区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1589, 1590, 794, 19010200),
(797, '长宁区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1591, 1592, 794, 19010300),
(798, '静安区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1593, 1594, 794, 19010400),
(799, '普陀区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1595, 1596, 794, 19010500),
(800, '虹口区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1597, 1598, 794, 19010600),
(801, '杨浦区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1599, 1600, 794, 19010700),
(802, '闵行区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1601, 1602, 794, 19010800),
(803, '宝山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1603, 1604, 794, 19010900),
(804, '嘉定区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1605, 1606, 794, 19011000),
(805, '浦东新区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1607, 1608, 794, 19011100),
(806, '金山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1609, 1610, 794, 19011200),
(807, '松江区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1611, 1612, 794, 19011300),
(808, '青浦区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1613, 1614, 794, 19011400),
(809, '奉贤区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1615, 1616, 794, 19011500),
(810, '崇明区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1617, 1618, 794, 19011600),
(811, '江苏省', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1621, 1840, NULL, 20000000),
(812, '南京市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1622, 1645, 811, 20010000),
(813, '玄武区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1623, 1624, 812, 20010100),
(814, '秦淮区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1625, 1626, 812, 20010200),
(815, '建邺区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1627, 1628, 812, 20010300),
(816, '鼓楼区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1629, 1630, 812, 20010400),
(817, '浦口区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1631, 1632, 812, 20010500),
(818, '栖霞区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1633, 1634, 812, 20010600),
(819, '雨花台区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1635, 1636, 812, 20010700),
(820, '江宁区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1637, 1638, 812, 20010800),
(821, '六合区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1639, 1640, 812, 20010900),
(822, '溧水区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1641, 1642, 812, 20011000),
(823, '高淳区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1643, 1644, 812, 20011100),
(824, '无锡市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1646, 1661, 811, 20020000),
(825, '锡山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1647, 1648, 824, 20020100),
(826, '惠山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1649, 1650, 824, 20020200),
(827, '滨湖区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1651, 1652, 824, 20020300),
(828, '梁溪区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1653, 1654, 824, 20020400),
(829, '新吴区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1655, 1656, 824, 20020500),
(830, '江阴市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1657, 1658, 824, 20020600),
(831, '宜兴市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1659, 1660, 824, 20020700),
(832, '徐州市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1662, 1683, 811, 20030000),
(833, '鼓楼区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1663, 1664, 832, 20030100),
(834, '云龙区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1665, 1666, 832, 20030200),
(835, '贾汪区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1667, 1668, 832, 20030300),
(836, '泉山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1669, 1670, 832, 20030400),
(837, '铜山区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1671, 1672, 832, 20030500),
(838, '丰县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1673, 1674, 832, 20030600),
(839, '沛县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1675, 1676, 832, 20030700),
(840, '睢宁县', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1677, 1678, 832, 20030800),
(841, '新沂市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1679, 1680, 832, 20030900),
(842, '邳州市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1681, 1682, 832, 20031000),
(843, '常州市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1684, 1697, 811, 20040000),
(844, '天宁区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1685, 1686, 843, 20040100),
(845, '钟楼区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1687, 1688, 843, 20040200),
(846, '新北区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1689, 1690, 843, 20040300),
(847, '武进区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1691, 1692, 843, 20040400),
(848, '金坛区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1693, 1694, 843, 20040500),
(849, '溧阳市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1695, 1696, 843, 20040600),
(850, '苏州市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1698, 1717, 811, 20050000),
(851, '虎丘区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1699, 1700, 850, 20050100),
(852, '吴中区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1701, 1702, 850, 20050200),
(853, '相城区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1703, 1704, 850, 20050300),
(854, '姑苏区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1705, 1706, 850, 20050400),
(855, '吴江区', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1707, 1708, 850, 20050500),
(856, '常熟市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1709, 1710, 850, 20050600),
(857, '张家港市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1711, 1712, 850, 20050700),
(858, '昆山市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1713, 1714, 850, 20050800),
(859, '太仓市', 0, '2018-07-03 09:21:06', '2019-07-06 06:29:33', 1715, 1716, 850, 20050900),
(860, '南通市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1718, 1735, 811, 20060000),
(861, '崇川区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1719, 1720, 860, 20060100),
(862, '港闸区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1721, 1722, 860, 20060200),
(863, '通州区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1723, 1724, 860, 20060300),
(864, '海安县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1725, 1726, 860, 20060400),
(865, '如东县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1727, 1728, 860, 20060500),
(866, '启东市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1729, 1730, 860, 20060600),
(867, '如皋市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1731, 1732, 860, 20060700),
(868, '海门市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1733, 1734, 860, 20060800),
(869, '连云港市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1736, 1749, 811, 20070000),
(870, '连云区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1737, 1738, 869, 20070100),
(871, '海州区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1739, 1740, 869, 20070200),
(872, '赣榆区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1741, 1742, 869, 20070300),
(873, '东海县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1743, 1744, 869, 20070400),
(874, '灌云县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1745, 1746, 869, 20070500),
(875, '灌南县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1747, 1748, 869, 20070600),
(876, '淮安市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1750, 1765, 811, 20080000),
(877, '淮安区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1751, 1752, 876, 20080100),
(878, '淮阴区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1753, 1754, 876, 20080200),
(879, '清江浦区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1755, 1756, 876, 20080300),
(880, '洪泽区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1757, 1758, 876, 20080400),
(881, '涟水县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1759, 1760, 876, 20080500),
(882, '盱眙县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1761, 1762, 876, 20080600),
(883, '金湖县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1763, 1764, 876, 20080700),
(884, '盐城市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1766, 1785, 811, 20090000),
(885, '亭湖区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1767, 1768, 884, 20090100),
(886, '盐都区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1769, 1770, 884, 20090200),
(887, '大丰区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1771, 1772, 884, 20090300),
(888, '响水县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1773, 1774, 884, 20090400),
(889, '滨海县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1775, 1776, 884, 20090500),
(890, '阜宁县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1777, 1778, 884, 20090600),
(891, '射阳县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1779, 1780, 884, 20090700),
(892, '建湖县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1781, 1782, 884, 20090800),
(893, '东台市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1783, 1784, 884, 20090900),
(894, '扬州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1786, 1799, 811, 20100000),
(895, '广陵区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1787, 1788, 894, 20100100),
(896, '邗江区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1789, 1790, 894, 20100200),
(897, '江都区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1791, 1792, 894, 20100300),
(898, '宝应县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1793, 1794, 894, 20100400),
(899, '仪征市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1795, 1796, 894, 20100500),
(900, '高邮市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1797, 1798, 894, 20100600),
(901, '镇江市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1800, 1813, 811, 20110000),
(902, '京口区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1801, 1802, 901, 20110100),
(903, '润州区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1803, 1804, 901, 20110200),
(904, '丹徒区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1805, 1806, 901, 20110300),
(905, '丹阳市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1807, 1808, 901, 20110400),
(906, '扬中市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1809, 1810, 901, 20110500),
(907, '句容市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1811, 1812, 901, 20110600),
(908, '泰州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1814, 1827, 811, 20120000),
(909, '海陵区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1815, 1816, 908, 20120100),
(910, '高港区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1817, 1818, 908, 20120200),
(911, '姜堰区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1819, 1820, 908, 20120300),
(912, '兴化市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1821, 1822, 908, 20120400),
(913, '靖江市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1823, 1824, 908, 20120500),
(914, '泰兴市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1825, 1826, 908, 20120600),
(915, '宿迁市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1828, 1839, 811, 20130000),
(916, '宿城区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1829, 1830, 915, 20130100),
(917, '宿豫区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1831, 1832, 915, 20130200),
(918, '沭阳县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1833, 1834, 915, 20130300),
(919, '泗阳县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1835, 1836, 915, 20130400),
(920, '泗洪县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1837, 1838, 915, 20130500),
(921, '浙江省', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1841, 2044, NULL, 21000000),
(922, '杭州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1842, 1869, 921, 21010000),
(923, '上城区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1843, 1844, 922, 21010100),
(924, '下城区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1845, 1846, 922, 21010200),
(925, '江干区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1847, 1848, 922, 21010300),
(926, '拱墅区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1849, 1850, 922, 21010400),
(927, '西湖区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1851, 1852, 922, 21010500),
(928, '滨江区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1853, 1854, 922, 21010600),
(929, '萧山区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1855, 1856, 922, 21010700),
(930, '余杭区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1857, 1858, 922, 21010800),
(931, '富阳区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1859, 1860, 922, 21010900),
(932, '桐庐县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1861, 1862, 922, 21011000),
(933, '淳安县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1863, 1864, 922, 21011100),
(934, '建德市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1865, 1866, 922, 21011200),
(935, '临安市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1867, 1868, 922, 21011300),
(936, '宁波市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1870, 1893, 921, 21020000),
(937, '海曙区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1871, 1872, 936, 21020100),
(938, '江东区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1873, 1874, 936, 21020200),
(939, '江北区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1875, 1876, 936, 21020300),
(940, '北仑区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1877, 1878, 936, 21020400),
(941, '镇海区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1879, 1880, 936, 21020500),
(942, '鄞州区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1881, 1882, 936, 21020600),
(943, '象山县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1883, 1884, 936, 21020700),
(944, '宁海县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1885, 1886, 936, 21020800),
(945, '余姚市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1887, 1888, 936, 21020900),
(946, '慈溪市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1889, 1890, 936, 21021000),
(947, '奉化市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1891, 1892, 936, 21021100),
(948, '温州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1894, 1917, 921, 21030000),
(949, '鹿城区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1895, 1896, 948, 21030100),
(950, '龙湾区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1897, 1898, 948, 21030200),
(951, '瓯海区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1899, 1900, 948, 21030300),
(952, '洞头区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1901, 1902, 948, 21030400),
(953, '永嘉县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1903, 1904, 948, 21030500),
(954, '平阳县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1905, 1906, 948, 21030600),
(955, '苍南县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1907, 1908, 948, 21030700),
(956, '文成县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1909, 1910, 948, 21030800),
(957, '泰顺县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1911, 1912, 948, 21030900),
(958, '瑞安市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1913, 1914, 948, 21031000),
(959, '乐清市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1915, 1916, 948, 21031100),
(960, '嘉兴市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1918, 1933, 921, 21040000),
(961, '南湖区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1919, 1920, 960, 21040100),
(962, '秀洲区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1921, 1922, 960, 21040200),
(963, '嘉善县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1923, 1924, 960, 21040300),
(964, '海盐县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1925, 1926, 960, 21040400),
(965, '海宁市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1927, 1928, 960, 21040500),
(966, '平湖市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1929, 1930, 960, 21040600),
(967, '桐乡市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1931, 1932, 960, 21040700),
(968, '湖州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1934, 1945, 921, 21050000),
(969, '吴兴区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1935, 1936, 968, 21050100),
(970, '南浔区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1937, 1938, 968, 21050200),
(971, '德清县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1939, 1940, 968, 21050300),
(972, '长兴县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1941, 1942, 968, 21050400),
(973, '安吉县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1943, 1944, 968, 21050500),
(974, '绍兴市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1946, 1959, 921, 21060000),
(975, '越城区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1947, 1948, 974, 21060100),
(976, '柯桥区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1949, 1950, 974, 21060200),
(977, '上虞区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1951, 1952, 974, 21060300),
(978, '新昌县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1953, 1954, 974, 21060400),
(979, '诸暨市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1955, 1956, 974, 21060500),
(980, '嵊州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1957, 1958, 974, 21060600),
(981, '金华市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1960, 1979, 921, 21070000),
(982, '婺城区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1961, 1962, 981, 21070100),
(983, '金东区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1963, 1964, 981, 21070200),
(984, '武义县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1965, 1966, 981, 21070300),
(985, '浦江县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1967, 1968, 981, 21070400),
(986, '磐安县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1969, 1970, 981, 21070500),
(987, '兰溪市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1971, 1972, 981, 21070600),
(988, '义乌市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1973, 1974, 981, 21070700),
(989, '东阳市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1975, 1976, 981, 21070800),
(990, '永康市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1977, 1978, 981, 21070900),
(991, '衢州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1980, 1993, 921, 21080000),
(992, '柯城区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1981, 1982, 991, 21080100),
(993, '衢江区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1983, 1984, 991, 21080200),
(994, '常山县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1985, 1986, 991, 21080300),
(995, '开化县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1987, 1988, 991, 21080400),
(996, '龙游县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1989, 1990, 991, 21080500),
(997, '江山市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1991, 1992, 991, 21080600),
(998, '舟山市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1994, 2003, 921, 21090000),
(999, '定海区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1995, 1996, 998, 21090100),
(1000, '普陀区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1997, 1998, 998, 21090200),
(1001, '岱山县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 1999, 2000, 998, 21090300),
(1002, '嵊泗县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2001, 2002, 998, 21090400),
(1003, '台州市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2004, 2023, 921, 21100000),
(1004, '椒江区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2005, 2006, 1003, 21100100),
(1005, '黄岩区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2007, 2008, 1003, 21100200),
(1006, '路桥区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2009, 2010, 1003, 21100300),
(1007, '玉环县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2011, 2012, 1003, 21100400),
(1008, '三门县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2013, 2014, 1003, 21100500),
(1009, '天台县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2015, 2016, 1003, 21100600),
(1010, '仙居县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2017, 2018, 1003, 21100700),
(1011, '温岭市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2019, 2020, 1003, 21100800),
(1012, '临海市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2021, 2022, 1003, 21100900),
(1013, '丽水市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2024, 2043, 921, 21110000),
(1014, '莲都区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2025, 2026, 1013, 21110100),
(1015, '青田县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2027, 2028, 1013, 21110200),
(1016, '缙云县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2029, 2030, 1013, 21110300),
(1017, '遂昌县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:33', 2031, 2032, 1013, 21110400),
(1018, '松阳县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2033, 2034, 1013, 21110500),
(1019, '云和县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2035, 2036, 1013, 21110600),
(1020, '庆元县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2037, 2038, 1013, 21110700),
(1021, '景宁畲族自治县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2039, 2040, 1013, 21110800),
(1022, '龙泉市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2041, 2042, 1013, 21110900),
(1023, '安徽省', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2045, 2288, NULL, 22000000),
(1024, '合肥市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2046, 2065, 1023, 22010000),
(1025, '瑶海区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2047, 2048, 1024, 22010100),
(1026, '庐阳区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2049, 2050, 1024, 22010200),
(1027, '蜀山区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2051, 2052, 1024, 22010300),
(1028, '包河区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2053, 2054, 1024, 22010400),
(1029, '长丰县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2055, 2056, 1024, 22010500),
(1030, '肥东县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2057, 2058, 1024, 22010600),
(1031, '肥西县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2059, 2060, 1024, 22010700),
(1032, '庐江县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2061, 2062, 1024, 22010800),
(1033, '巢湖市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2063, 2064, 1024, 22010900),
(1034, '芜湖市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2066, 2083, 1023, 22020000),
(1035, '镜湖区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2067, 2068, 1034, 22020100),
(1036, '弋江区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2069, 2070, 1034, 22020200),
(1037, '鸠江区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2071, 2072, 1034, 22020300),
(1038, '三山区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2073, 2074, 1034, 22020400),
(1039, '芜湖县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2075, 2076, 1034, 22020500),
(1040, '繁昌县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2077, 2078, 1034, 22020600),
(1041, '南陵县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2079, 2080, 1034, 22020700),
(1042, '无为县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2081, 2082, 1034, 22020800),
(1043, '蚌埠市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2084, 2099, 1023, 22030000),
(1044, '龙子湖区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2085, 2086, 1043, 22030100),
(1045, '蚌山区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2087, 2088, 1043, 22030200),
(1046, '禹会区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2089, 2090, 1043, 22030300),
(1047, '淮上区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2091, 2092, 1043, 22030400),
(1048, '怀远县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2093, 2094, 1043, 22030500),
(1049, '五河县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2095, 2096, 1043, 22030600),
(1050, '固镇县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2097, 2098, 1043, 22030700),
(1051, '淮南市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2100, 2115, 1023, 22040000),
(1052, '大通区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2101, 2102, 1051, 22040100),
(1053, '田家庵区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2103, 2104, 1051, 22040200),
(1054, '谢家集区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2105, 2106, 1051, 22040300),
(1055, '八公山区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2107, 2108, 1051, 22040400),
(1056, '潘集区', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2109, 2110, 1051, 22040500),
(1057, '凤台县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2111, 2112, 1051, 22040600),
(1058, '寿县', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2113, 2114, 1051, 22040700),
(1059, '马鞍山市', 0, '2018-07-03 09:21:07', '2019-07-06 06:29:34', 2116, 2129, 1023, 22050000),
(1060, '花山区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2117, 2118, 1059, 22050100),
(1061, '雨山区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2119, 2120, 1059, 22050200),
(1062, '博望区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2121, 2122, 1059, 22050300),
(1063, '当涂县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2123, 2124, 1059, 22050400),
(1064, '含山县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2125, 2126, 1059, 22050500),
(1065, '和县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2127, 2128, 1059, 22050600),
(1066, '淮北市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2130, 2139, 1023, 22060000),
(1067, '杜集区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2131, 2132, 1066, 22060100),
(1068, '相山区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2133, 2134, 1066, 22060200),
(1069, '烈山区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2135, 2136, 1066, 22060300),
(1070, '濉溪县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2137, 2138, 1066, 22060400),
(1071, '铜陵市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2140, 2149, 1023, 22070000),
(1072, '铜官区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2141, 2142, 1071, 22070100),
(1073, '义安区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2143, 2144, 1071, 22070200),
(1074, '郊区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2145, 2146, 1071, 22070300),
(1075, '枞阳县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2147, 2148, 1071, 22070400),
(1076, '安庆市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2150, 2171, 1023, 22080000),
(1077, '迎江区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2151, 2152, 1076, 22080100),
(1078, '大观区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2153, 2154, 1076, 22080200),
(1079, '宜秀区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2155, 2156, 1076, 22080300),
(1080, '怀宁县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2157, 2158, 1076, 22080400),
(1081, '潜山县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2159, 2160, 1076, 22080500),
(1082, '太湖县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2161, 2162, 1076, 22080600),
(1083, '宿松县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2163, 2164, 1076, 22080700),
(1084, '望江县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2165, 2166, 1076, 22080800),
(1085, '岳西县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2167, 2168, 1076, 22080900),
(1086, '桐城市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2169, 2170, 1076, 22081000),
(1087, '黄山市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2172, 2187, 1023, 22090000),
(1088, '屯溪区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2173, 2174, 1087, 22090100),
(1089, '黄山区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2175, 2176, 1087, 22090200),
(1090, '徽州区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2177, 2178, 1087, 22090300),
(1091, '歙县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2179, 2180, 1087, 22090400),
(1092, '休宁县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2181, 2182, 1087, 22090500),
(1093, '黟县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2183, 2184, 1087, 22090600),
(1094, '祁门县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2185, 2186, 1087, 22090700),
(1095, '滁州市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2188, 2205, 1023, 22100000),
(1096, '琅琊区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2189, 2190, 1095, 22100100),
(1097, '南谯区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2191, 2192, 1095, 22100200),
(1098, '来安县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2193, 2194, 1095, 22100300),
(1099, '全椒县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2195, 2196, 1095, 22100400),
(1100, '定远县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2197, 2198, 1095, 22100500),
(1101, '凤阳县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2199, 2200, 1095, 22100600),
(1102, '天长市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2201, 2202, 1095, 22100700),
(1103, '明光市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2203, 2204, 1095, 22100800),
(1104, '阜阳市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2206, 2223, 1023, 22110000),
(1105, '颍州区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2207, 2208, 1104, 22110100),
(1106, '颍东区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2209, 2210, 1104, 22110200),
(1107, '颍泉区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2211, 2212, 1104, 22110300),
(1108, '临泉县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2213, 2214, 1104, 22110400),
(1109, '太和县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2215, 2216, 1104, 22110500),
(1110, '阜南县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2217, 2218, 1104, 22110600),
(1111, '颍上县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2219, 2220, 1104, 22110700),
(1112, '界首市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2221, 2222, 1104, 22110800),
(1113, '宿州市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2224, 2235, 1023, 22120000),
(1114, '�桥区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2225, 2226, 1113, 22120100),
(1115, '砀山县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2227, 2228, 1113, 22120200),
(1116, '萧县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2229, 2230, 1113, 22120300),
(1117, '灵璧县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2231, 2232, 1113, 22120400),
(1118, '泗县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2233, 2234, 1113, 22120500),
(1119, '六安市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2236, 2251, 1023, 22130000),
(1120, '金安区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2237, 2238, 1119, 22130100),
(1121, '裕安区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2239, 2240, 1119, 22130200),
(1122, '叶集区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2241, 2242, 1119, 22130300),
(1123, '霍邱县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2243, 2244, 1119, 22130400),
(1124, '舒城县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2245, 2246, 1119, 22130500),
(1125, '金寨县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2247, 2248, 1119, 22130600),
(1126, '霍山县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2249, 2250, 1119, 22130700),
(1127, '亳州市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2252, 2261, 1023, 22140000),
(1128, '谯城区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2253, 2254, 1127, 22140100),
(1129, '涡阳县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2255, 2256, 1127, 22140200),
(1130, '蒙城县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2257, 2258, 1127, 22140300),
(1131, '利辛县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2259, 2260, 1127, 22140400),
(1132, '池州市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2262, 2271, 1023, 22150000),
(1133, '贵池区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2263, 2264, 1132, 22150100),
(1134, '东至县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2265, 2266, 1132, 22150200),
(1135, '石台县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2267, 2268, 1132, 22150300),
(1136, '青阳县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2269, 2270, 1132, 22150400),
(1137, '宣城市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2272, 2287, 1023, 22160000),
(1138, '宣州区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2273, 2274, 1137, 22160100),
(1139, '郎溪县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2275, 2276, 1137, 22160200),
(1140, '广德县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2277, 2278, 1137, 22160300),
(1141, '泾县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2279, 2280, 1137, 22160400);";
        $sql3 = "INSERT INTO `area` (`id`, `name`, `disabled`, `created_at`, `updated_at`, `_lft`, `_rgt`, `parent_id`, `code`) VALUES
(1142, '绩溪县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2281, 2282, 1137, 22160500),
(1143, '旌德县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2283, 2284, 1137, 22160600),
(1144, '宁国市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2285, 2286, 1137, 22160700),
(1145, '福建省', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2289, 2476, NULL, 23000000),
(1146, '福州市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2290, 2317, 1145, 23010000),
(1147, '鼓楼区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2291, 2292, 1146, 23010100),
(1148, '台江区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2293, 2294, 1146, 23010200),
(1149, '仓山区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2295, 2296, 1146, 23010300),
(1150, '马尾区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2297, 2298, 1146, 23010400),
(1151, '晋安区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2299, 2300, 1146, 23010500),
(1152, '闽侯县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2301, 2302, 1146, 23010600),
(1153, '连江县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2303, 2304, 1146, 23010700),
(1154, '罗源县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2305, 2306, 1146, 23010800),
(1155, '闽清县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2307, 2308, 1146, 23010900),
(1156, '永泰县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2309, 2310, 1146, 23011000),
(1157, '平潭县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2311, 2312, 1146, 23011100),
(1158, '福清市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2313, 2314, 1146, 23011200),
(1159, '长乐市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2315, 2316, 1146, 23011300),
(1160, '厦门市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2318, 2331, 1145, 23020000),
(1161, '思明区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2319, 2320, 1160, 23020100),
(1162, '海沧区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2321, 2322, 1160, 23020200),
(1163, '湖里区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2323, 2324, 1160, 23020300),
(1164, '集美区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2325, 2326, 1160, 23020400),
(1165, '同安区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2327, 2328, 1160, 23020500),
(1166, '翔安区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2329, 2330, 1160, 23020600),
(1167, '莆田市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2332, 2343, 1145, 23030000),
(1168, '城厢区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2333, 2334, 1167, 23030100),
(1169, '涵江区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2335, 2336, 1167, 23030200),
(1170, '荔城区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2337, 2338, 1167, 23030300),
(1171, '秀屿区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2339, 2340, 1167, 23030400),
(1172, '仙游县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2341, 2342, 1167, 23030500),
(1173, '三明市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2344, 2369, 1145, 23040000),
(1174, '梅列区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2345, 2346, 1173, 23040100),
(1175, '三元区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2347, 2348, 1173, 23040200),
(1176, '明溪县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2349, 2350, 1173, 23040300),
(1177, '清流县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2351, 2352, 1173, 23040400),
(1178, '宁化县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2353, 2354, 1173, 23040500),
(1179, '大田县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2355, 2356, 1173, 23040600),
(1180, '尤溪县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2357, 2358, 1173, 23040700),
(1181, '沙县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2359, 2360, 1173, 23040800),
(1182, '将乐县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2361, 2362, 1173, 23040900),
(1183, '泰宁县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2363, 2364, 1173, 23041000),
(1184, '建宁县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2365, 2366, 1173, 23041100),
(1185, '永安市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2367, 2368, 1173, 23041200),
(1186, '泉州市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2370, 2393, 1145, 23050000),
(1187, '鲤城区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2371, 2372, 1186, 23050100),
(1188, '丰泽区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2373, 2374, 1186, 23050200),
(1189, '洛江区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2375, 2376, 1186, 23050300),
(1190, '泉港区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2377, 2378, 1186, 23050400),
(1191, '惠安县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2379, 2380, 1186, 23050500),
(1192, '安溪县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2381, 2382, 1186, 23050600),
(1193, '永春县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2383, 2384, 1186, 23050700),
(1194, '德化县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2385, 2386, 1186, 23050800),
(1195, '石狮市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2387, 2388, 1186, 23050900),
(1196, '晋江市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2389, 2390, 1186, 23051000),
(1197, '南安市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2391, 2392, 1186, 23051100),
(1198, '漳州市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2394, 2417, 1145, 23060000),
(1199, '芗城区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2395, 2396, 1198, 23060100),
(1200, '龙文区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2397, 2398, 1198, 23060200),
(1201, '云霄县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2399, 2400, 1198, 23060300),
(1202, '漳浦县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2401, 2402, 1198, 23060400),
(1203, '诏安县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2403, 2404, 1198, 23060500),
(1204, '长泰县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2405, 2406, 1198, 23060600),
(1205, '东山县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2407, 2408, 1198, 23060700),
(1206, '南靖县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2409, 2410, 1198, 23060800),
(1207, '平和县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2411, 2412, 1198, 23060900),
(1208, '华安县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2413, 2414, 1198, 23061000),
(1209, '龙海市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2415, 2416, 1198, 23061100),
(1210, '南平市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2418, 2439, 1145, 23070000),
(1211, '延平区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2419, 2420, 1210, 23070100),
(1212, '建阳区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2421, 2422, 1210, 23070200),
(1213, '顺昌县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2423, 2424, 1210, 23070300),
(1214, '浦城县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2425, 2426, 1210, 23070400),
(1215, '光泽县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2427, 2428, 1210, 23070500),
(1216, '松溪县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2429, 2430, 1210, 23070600),
(1217, '政和县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2431, 2432, 1210, 23070700),
(1218, '邵武市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2433, 2434, 1210, 23070800),
(1219, '武夷山市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2435, 2436, 1210, 23070900),
(1220, '建瓯市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2437, 2438, 1210, 23071000),
(1221, '龙岩市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2440, 2455, 1145, 23080000),
(1222, '新罗区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2441, 2442, 1221, 23080100),
(1223, '永定区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2443, 2444, 1221, 23080200),
(1224, '长汀县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2445, 2446, 1221, 23080300),
(1225, '上杭县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2447, 2448, 1221, 23080400),
(1226, '武平县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2449, 2450, 1221, 23080500),
(1227, '连城县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2451, 2452, 1221, 23080600),
(1228, '漳平市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2453, 2454, 1221, 23080700),
(1229, '宁德市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2456, 2475, 1145, 23090000),
(1230, '蕉城区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2457, 2458, 1229, 23090100),
(1231, '霞浦县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2459, 2460, 1229, 23090200),
(1232, '古田县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2461, 2462, 1229, 23090300),
(1233, '屏南县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2463, 2464, 1229, 23090400),
(1234, '寿宁县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2465, 2466, 1229, 23090500),
(1235, '周宁县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2467, 2468, 1229, 23090600),
(1236, '柘荣县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2469, 2470, 1229, 23090700),
(1237, '福安市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:34', 2471, 2472, 1229, 23090800),
(1238, '福鼎市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2473, 2474, 1229, 23090900),
(1239, '江西省', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2477, 2700, NULL, 24000000),
(1240, '南昌市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2478, 2497, 1239, 24010000),
(1241, '东湖区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2479, 2480, 1240, 24010100),
(1242, '西湖区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2481, 2482, 1240, 24010200),
(1243, '青云谱区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2483, 2484, 1240, 24010300),
(1244, '湾里区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2485, 2486, 1240, 24010400),
(1245, '青山湖区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2487, 2488, 1240, 24010500),
(1246, '新建区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2489, 2490, 1240, 24010600),
(1247, '南昌县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2491, 2492, 1240, 24010700),
(1248, '安义县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2493, 2494, 1240, 24010800),
(1249, '进贤县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2495, 2496, 1240, 24010900),
(1250, '景德镇市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2498, 2507, 1239, 24020000),
(1251, '昌江区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2499, 2500, 1250, 24020100),
(1252, '珠山区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2501, 2502, 1250, 24020200),
(1253, '浮梁县', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2503, 2504, 1250, 24020300),
(1254, '乐平市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2505, 2506, 1250, 24020400),
(1255, '萍乡市', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2508, 2519, 1239, 24030000),
(1256, '安源区', 0, '2018-07-03 09:21:08', '2019-07-06 06:29:35', 2509, 2510, 1255, 24030100),
(1257, '湘东区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2511, 2512, 1255, 24030200),
(1258, '莲花县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2513, 2514, 1255, 24030300),
(1259, '上栗县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2515, 2516, 1255, 24030400),
(1260, '芦溪县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2517, 2518, 1255, 24030500),
(1261, '九江市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2520, 2547, 1239, 24040000),
(1262, '濂溪区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2521, 2522, 1261, 24040100),
(1263, '浔阳区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2523, 2524, 1261, 24040200),
(1264, '九江县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2525, 2526, 1261, 24040300),
(1265, '武宁县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2527, 2528, 1261, 24040400),
(1266, '修水县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2529, 2530, 1261, 24040500),
(1267, '永修县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2531, 2532, 1261, 24040600),
(1268, '德安县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2533, 2534, 1261, 24040700),
(1269, '都昌县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2535, 2536, 1261, 24040800),
(1270, '湖口县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2537, 2538, 1261, 24040900),
(1271, '彭泽县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2539, 2540, 1261, 24041000),
(1272, '瑞昌市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2541, 2542, 1261, 24041100),
(1273, '共青城市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2543, 2544, 1261, 24041200),
(1274, '庐山市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2545, 2546, 1261, 24041300),
(1275, '新余市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2548, 2553, 1239, 24050000),
(1276, '渝水区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2549, 2550, 1275, 24050100),
(1277, '分宜县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2551, 2552, 1275, 24050200),
(1278, '鹰潭市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2554, 2561, 1239, 24060000),
(1279, '月湖区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2555, 2556, 1278, 24060100),
(1280, '余江县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2557, 2558, 1278, 24060200),
(1281, '贵溪市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2559, 2560, 1278, 24060300),
(1282, '赣州市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2562, 2599, 1239, 24070000),
(1283, '章贡区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2563, 2564, 1282, 24070100),
(1284, '南康区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2565, 2566, 1282, 24070200),
(1285, '赣县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2567, 2568, 1282, 24070300),
(1286, '信丰县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2569, 2570, 1282, 24070400),
(1287, '大余县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2571, 2572, 1282, 24070500),
(1288, '上犹县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2573, 2574, 1282, 24070600),
(1289, '崇义县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2575, 2576, 1282, 24070700),
(1290, '安远县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2577, 2578, 1282, 24070800),
(1291, '龙南县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2579, 2580, 1282, 24070900),
(1292, '定南县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2581, 2582, 1282, 24071000),
(1293, '全南县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2583, 2584, 1282, 24071100),
(1294, '宁都县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2585, 2586, 1282, 24071200),
(1295, '于都县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2587, 2588, 1282, 24071300),
(1296, '兴国县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2589, 2590, 1282, 24071400),
(1297, '会昌县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2591, 2592, 1282, 24071500),
(1298, '寻乌县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2593, 2594, 1282, 24071600),
(1299, '石城县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2595, 2596, 1282, 24071700),
(1300, '瑞金市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2597, 2598, 1282, 24071800),
(1301, '吉安市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2600, 2627, 1239, 24080000),
(1302, '吉州区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2601, 2602, 1301, 24080100),
(1303, '青原区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2603, 2604, 1301, 24080200),
(1304, '吉安县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2605, 2606, 1301, 24080300),
(1305, '吉水县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2607, 2608, 1301, 24080400),
(1306, '峡江县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2609, 2610, 1301, 24080500),
(1307, '新干县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2611, 2612, 1301, 24080600),
(1308, '永丰县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2613, 2614, 1301, 24080700),
(1309, '泰和县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2615, 2616, 1301, 24080800),
(1310, '遂川县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2617, 2618, 1301, 24080900),
(1311, '万安县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2619, 2620, 1301, 24081000),
(1312, '安福县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2621, 2622, 1301, 24081100),
(1313, '永新县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2623, 2624, 1301, 24081200),
(1314, '井冈山市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2625, 2626, 1301, 24081300),
(1315, '宜春市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2628, 2649, 1239, 24090000),
(1316, '袁州区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2629, 2630, 1315, 24090100),
(1317, '奉新县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2631, 2632, 1315, 24090200),
(1318, '万载县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2633, 2634, 1315, 24090300),
(1319, '上高县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2635, 2636, 1315, 24090400),
(1320, '宜丰县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2637, 2638, 1315, 24090500),
(1321, '靖安县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2639, 2640, 1315, 24090600),
(1322, '铜鼓县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2641, 2642, 1315, 24090700),
(1323, '丰城市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2643, 2644, 1315, 24090800),
(1324, '樟树市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2645, 2646, 1315, 24090900),
(1325, '高安市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2647, 2648, 1315, 24091000),
(1326, '抚州市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2650, 2673, 1239, 24100000),
(1327, '临川区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2651, 2652, 1326, 24100100),
(1328, '南城县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2653, 2654, 1326, 24100200),
(1329, '黎川县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2655, 2656, 1326, 24100300),
(1330, '南丰县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2657, 2658, 1326, 24100400),
(1331, '崇仁县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2659, 2660, 1326, 24100500),
(1332, '乐安县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2661, 2662, 1326, 24100600),
(1333, '宜黄县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2663, 2664, 1326, 24100700),
(1334, '金溪县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2665, 2666, 1326, 24100800),
(1335, '资溪县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2667, 2668, 1326, 24100900),
(1336, '东乡县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2669, 2670, 1326, 24101000),
(1337, '广昌县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2671, 2672, 1326, 24101100),
(1338, '上饶市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2674, 2699, 1239, 24110000),
(1339, '信州区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2675, 2676, 1338, 24110100),
(1340, '广丰区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2677, 2678, 1338, 24110200),
(1341, '上饶县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2679, 2680, 1338, 24110300),
(1342, '玉山县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2681, 2682, 1338, 24110400),
(1343, '铅山县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2683, 2684, 1338, 24110500),
(1344, '横峰县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2685, 2686, 1338, 24110600),
(1345, '弋阳县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2687, 2688, 1338, 24110700),
(1346, '余干县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2689, 2690, 1338, 24110800),
(1347, '鄱阳县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2691, 2692, 1338, 24110900),
(1348, '万年县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2693, 2694, 1338, 24111000),
(1349, '婺源县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2695, 2696, 1338, 24111100),
(1350, '德兴市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2697, 2698, 1338, 24111200),
(1351, '山东省', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2701, 3010, NULL, 25000000),
(1352, '济南市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2702, 2723, 1351, 25010000),
(1353, '历下区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2703, 2704, 1352, 25010100),
(1354, '市中区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2705, 2706, 1352, 25010200),
(1355, '槐荫区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2707, 2708, 1352, 25010300),
(1356, '天桥区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2709, 2710, 1352, 25010400),
(1357, '历城区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2711, 2712, 1352, 25010500),
(1358, '长清区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2713, 2714, 1352, 25010600),
(1359, '平阴县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2715, 2716, 1352, 25010700),
(1360, '济阳县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2717, 2718, 1352, 25010800),
(1361, '商河县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2719, 2720, 1352, 25010900),
(1362, '章丘市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2721, 2722, 1352, 25011000),
(1363, '青岛市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2724, 2745, 1351, 25020000),
(1364, '市南区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2725, 2726, 1363, 25020100),
(1365, '市北区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2727, 2728, 1363, 25020200),
(1366, '黄岛区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2729, 2730, 1363, 25020300),
(1367, '崂山区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2731, 2732, 1363, 25020400),
(1368, '李沧区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2733, 2734, 1363, 25020500),
(1369, '城阳区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2735, 2736, 1363, 25020600),
(1370, '胶州市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2737, 2738, 1363, 25020700),
(1371, '即墨市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2739, 2740, 1363, 25020800),
(1372, '平度市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2741, 2742, 1363, 25020900),
(1373, '莱西市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2743, 2744, 1363, 25021000),
(1374, '淄博市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2746, 2763, 1351, 25030000),
(1375, '淄川区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2747, 2748, 1374, 25030100),
(1376, '张店区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2749, 2750, 1374, 25030200),
(1377, '博山区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2751, 2752, 1374, 25030300),
(1378, '临淄区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2753, 2754, 1374, 25030400),
(1379, '周村区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2755, 2756, 1374, 25030500),
(1380, '桓台县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2757, 2758, 1374, 25030600),
(1381, '高青县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2759, 2760, 1374, 25030700),
(1382, '沂源县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2761, 2762, 1374, 25030800),
(1383, '枣庄市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2764, 2777, 1351, 25040000),
(1384, '市中区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2765, 2766, 1383, 25040100),
(1385, '薛城区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2767, 2768, 1383, 25040200),
(1386, '峄城区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2769, 2770, 1383, 25040300),
(1387, '台儿庄区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2771, 2772, 1383, 25040400),
(1388, '山亭区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2773, 2774, 1383, 25040500),
(1389, '滕州市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2775, 2776, 1383, 25040600),
(1390, '东营市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2778, 2789, 1351, 25050000),
(1391, '东营区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2779, 2780, 1390, 25050100),
(1392, '河口区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2781, 2782, 1390, 25050200),
(1393, '垦利区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2783, 2784, 1390, 25050300),
(1394, '利津县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2785, 2786, 1390, 25050400),
(1395, '广饶县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2787, 2788, 1390, 25050500),
(1396, '烟台市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2790, 2815, 1351, 25060000),
(1397, '芝罘区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2791, 2792, 1396, 25060100),
(1398, '福山区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2793, 2794, 1396, 25060200),
(1399, '牟平区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2795, 2796, 1396, 25060300),
(1400, '莱山区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2797, 2798, 1396, 25060400),
(1401, '长岛县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2799, 2800, 1396, 25060500),
(1402, '龙口市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2801, 2802, 1396, 25060600),
(1403, '莱阳市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2803, 2804, 1396, 25060700),
(1404, '莱州市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2805, 2806, 1396, 25060800),
(1405, '蓬莱市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2807, 2808, 1396, 25060900),
(1406, '招远市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2809, 2810, 1396, 25061000),
(1407, '栖霞市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2811, 2812, 1396, 25061100),
(1408, '海阳市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2813, 2814, 1396, 25061200),
(1409, '潍坊市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2816, 2841, 1351, 25070000),
(1410, '潍城区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2817, 2818, 1409, 25070100),
(1411, '寒亭区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2819, 2820, 1409, 25070200),
(1412, '坊子区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2821, 2822, 1409, 25070300),
(1413, '奎文区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2823, 2824, 1409, 25070400),
(1414, '临朐县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2825, 2826, 1409, 25070500),
(1415, '昌乐县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2827, 2828, 1409, 25070600),
(1416, '青州市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2829, 2830, 1409, 25070700),
(1417, '诸城市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2831, 2832, 1409, 25070800),
(1418, '寿光市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2833, 2834, 1409, 25070900),
(1419, '安丘市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2835, 2836, 1409, 25071000),
(1420, '高密市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2837, 2838, 1409, 25071100),
(1421, '昌邑市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2839, 2840, 1409, 25071200),
(1422, '济宁市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2842, 2865, 1351, 25080000),
(1423, '任城区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2843, 2844, 1422, 25080100),
(1424, '兖州区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2845, 2846, 1422, 25080200),
(1425, '微山县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2847, 2848, 1422, 25080300),
(1426, '鱼台县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2849, 2850, 1422, 25080400),
(1427, '金乡县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2851, 2852, 1422, 25080500),
(1428, '嘉祥县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2853, 2854, 1422, 25080600),
(1429, '汶上县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2855, 2856, 1422, 25080700),
(1430, '泗水县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2857, 2858, 1422, 25080800),
(1431, '梁山县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2859, 2860, 1422, 25080900),
(1432, '曲阜市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2861, 2862, 1422, 25081000),
(1433, '邹城市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2863, 2864, 1422, 25081100),
(1434, '泰安市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2866, 2879, 1351, 25090000),
(1435, '泰山区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2867, 2868, 1434, 25090100),
(1436, '岱岳区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2869, 2870, 1434, 25090200),
(1437, '宁阳县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2871, 2872, 1434, 25090300),
(1438, '东平县', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2873, 2874, 1434, 25090400),
(1439, '新泰市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2875, 2876, 1434, 25090500),
(1440, '肥城市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2877, 2878, 1434, 25090600),
(1441, '威海市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2880, 2889, 1351, 25100000),
(1442, '环翠区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2881, 2882, 1441, 25100100),
(1443, '文登区', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2883, 2884, 1441, 25100200),
(1444, '荣成市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2885, 2886, 1441, 25100300),
(1445, '乳山市', 0, '2018-07-03 09:21:09', '2019-07-06 06:29:35', 2887, 2888, 1441, 25100400),
(1446, '日照市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2890, 2899, 1351, 25110000),
(1447, '东港区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2891, 2892, 1446, 25110100),
(1448, '岚山区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2893, 2894, 1446, 25110200),
(1449, '五莲县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2895, 2896, 1446, 25110300),
(1450, '莒县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2897, 2898, 1446, 25110400),
(1451, '莱芜市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2900, 2905, 1351, 25120000),
(1452, '莱城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2901, 2902, 1451, 25120100),
(1453, '钢城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2903, 2904, 1451, 25120200),
(1454, '临沂市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2906, 2931, 1351, 25130000),
(1455, '兰山区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2907, 2908, 1454, 25130100),
(1456, '罗庄区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2909, 2910, 1454, 25130200),
(1457, '河东区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2911, 2912, 1454, 25130300),
(1458, '沂南县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2913, 2914, 1454, 25130400),
(1459, '郯城县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2915, 2916, 1454, 25130500),
(1460, '沂水县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2917, 2918, 1454, 25130600),
(1461, '兰陵县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2919, 2920, 1454, 25130700),
(1462, '费县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2921, 2922, 1454, 25130800),
(1463, '平邑县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2923, 2924, 1454, 25130900),
(1464, '莒南县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2925, 2926, 1454, 25131000),
(1465, '蒙阴县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2927, 2928, 1454, 25131100),
(1466, '临沭县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2929, 2930, 1454, 25131200),
(1467, '德州市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2932, 2955, 1351, 25140000),
(1468, '德城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2933, 2934, 1467, 25140100),
(1469, '陵城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2935, 2936, 1467, 25140200),
(1470, '宁津县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2937, 2938, 1467, 25140300),
(1471, '庆云县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2939, 2940, 1467, 25140400),
(1472, '临邑县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2941, 2942, 1467, 25140500),
(1473, '齐河县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2943, 2944, 1467, 25140600),
(1474, '平原县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2945, 2946, 1467, 25140700),
(1475, '夏津县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2947, 2948, 1467, 25140800),
(1476, '武城县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2949, 2950, 1467, 25140900),
(1477, '乐陵市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2951, 2952, 1467, 25141000),
(1478, '禹城市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2953, 2954, 1467, 25141100),
(1479, '聊城市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2956, 2973, 1351, 25150000),
(1480, '东昌府区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2957, 2958, 1479, 25150100),
(1481, '阳谷县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2959, 2960, 1479, 25150200),
(1482, '莘县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2961, 2962, 1479, 25150300),
(1483, '茌平县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:35', 2963, 2964, 1479, 25150400),
(1484, '东阿县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2965, 2966, 1479, 25150500),
(1485, '冠县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2967, 2968, 1479, 25150600),
(1486, '高唐县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2969, 2970, 1479, 25150700),
(1487, '临清市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2971, 2972, 1479, 25150800),
(1488, '滨州市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2974, 2989, 1351, 25160000),
(1489, '滨城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2975, 2976, 1488, 25160100),
(1490, '沾化区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2977, 2978, 1488, 25160200),
(1491, '惠民县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2979, 2980, 1488, 25160300),
(1492, '阳信县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2981, 2982, 1488, 25160400),
(1493, '无棣县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2983, 2984, 1488, 25160500),
(1494, '博兴县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2985, 2986, 1488, 25160600),
(1495, '邹平县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2987, 2988, 1488, 25160700),
(1496, '菏泽市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2990, 3009, 1351, 25170000),
(1497, '牡丹区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2991, 2992, 1496, 25170100),
(1498, '定陶区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2993, 2994, 1496, 25170200),
(1499, '曹县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2995, 2996, 1496, 25170300),
(1500, '单县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2997, 2998, 1496, 25170400),
(1501, '成武县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 2999, 3000, 1496, 25170500),
(1502, '巨野县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3001, 3002, 1496, 25170600),
(1503, '郓城县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3003, 3004, 1496, 25170700),
(1504, '鄄城县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3005, 3006, 1496, 25170800),
(1505, '东明县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3007, 3008, 1496, 25170900),
(1506, '河南省', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3011, 3366, NULL, 26000000),
(1507, '郑州市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3012, 3037, 1506, 26010000),
(1508, '中原区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3013, 3014, 1507, 26010100),
(1509, '二七区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3015, 3016, 1507, 26010200),
(1510, '管城回族区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3017, 3018, 1507, 26010300),
(1511, '金水区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3019, 3020, 1507, 26010400),
(1512, '上街区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3021, 3022, 1507, 26010500),
(1513, '惠济区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3023, 3024, 1507, 26010600),
(1514, '中牟县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3025, 3026, 1507, 26010700),
(1515, '巩义市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3027, 3028, 1507, 26010800),
(1516, '荥阳市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3029, 3030, 1507, 26010900),
(1517, '新密市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3031, 3032, 1507, 26011000),
(1518, '新郑市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3033, 3034, 1507, 26011100),
(1519, '登封市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3035, 3036, 1507, 26011200),
(1520, '开封市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3038, 3059, 1506, 26020000),
(1521, '龙亭区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3039, 3040, 1520, 26020100),
(1522, '顺河回族区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3041, 3042, 1520, 26020200),
(1523, '鼓楼区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3043, 3044, 1520, 26020300),
(1524, '禹王台区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3045, 3046, 1520, 26020400),
(1525, '金明区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3047, 3048, 1520, 26020500),
(1526, '祥符区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3049, 3050, 1520, 26020600),
(1527, '杞县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3051, 3052, 1520, 26020700),
(1528, '通许县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3053, 3054, 1520, 26020800),
(1529, '尉氏县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3055, 3056, 1520, 26020900),
(1530, '兰考县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3057, 3058, 1520, 26021000),
(1531, '洛阳市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3060, 3091, 1506, 26030000),
(1532, '老城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3061, 3062, 1531, 26030100),
(1533, '西工区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3063, 3064, 1531, 26030200),
(1534, '�河回族区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3065, 3066, 1531, 26030300),
(1535, '涧西区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3067, 3068, 1531, 26030400),
(1536, '吉利区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3069, 3070, 1531, 26030500),
(1537, '洛龙区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3071, 3072, 1531, 26030600),
(1538, '孟津县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3073, 3074, 1531, 26030700),
(1539, '新安县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3075, 3076, 1531, 26030800),
(1540, '栾川县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3077, 3078, 1531, 26030900),
(1541, '嵩县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3079, 3080, 1531, 26031000),
(1542, '汝阳县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3081, 3082, 1531, 26031100),
(1543, '宜阳县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3083, 3084, 1531, 26031200),
(1544, '洛宁县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3085, 3086, 1531, 26031300),
(1545, '伊川县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3087, 3088, 1531, 26031400),
(1546, '偃师市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3089, 3090, 1531, 26031500),
(1547, '平顶山市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3092, 3113, 1506, 26040000),
(1548, '新华区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3093, 3094, 1547, 26040100),
(1549, '卫东区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3095, 3096, 1547, 26040200),
(1550, '石龙区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3097, 3098, 1547, 26040300),
(1551, '湛河区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3099, 3100, 1547, 26040400),
(1552, '宝丰县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3101, 3102, 1547, 26040500),
(1553, '叶县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3103, 3104, 1547, 26040600),
(1554, '鲁山县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3105, 3106, 1547, 26040700),
(1555, '郏县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3107, 3108, 1547, 26040800),
(1556, '舞钢市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3109, 3110, 1547, 26040900),
(1557, '汝州市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3111, 3112, 1547, 26041000),
(1558, '安阳市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3114, 3133, 1506, 26050000),
(1559, '文峰区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3115, 3116, 1558, 26050100),
(1560, '北关区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3117, 3118, 1558, 26050200),
(1561, '殷都区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3119, 3120, 1558, 26050300),
(1562, '龙安区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3121, 3122, 1558, 26050400),
(1563, '安阳县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3123, 3124, 1558, 26050500),
(1564, '汤阴县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3125, 3126, 1558, 26050600),
(1565, '滑县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3127, 3128, 1558, 26050700),
(1566, '内黄县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3129, 3130, 1558, 26050800),
(1567, '林州市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3131, 3132, 1558, 26050900),
(1568, '鹤壁市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3134, 3145, 1506, 26060000),
(1569, '鹤山区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3135, 3136, 1568, 26060100),
(1570, '山城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3137, 3138, 1568, 26060200),
(1571, '淇滨区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3139, 3140, 1568, 26060300),
(1572, '浚县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3141, 3142, 1568, 26060400),
(1573, '淇县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3143, 3144, 1568, 26060500),
(1574, '新乡市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3146, 3171, 1506, 26070000),
(1575, '红旗区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3147, 3148, 1574, 26070100),
(1576, '卫滨区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3149, 3150, 1574, 26070200),
(1577, '凤泉区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3151, 3152, 1574, 26070300),
(1578, '牧野区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3153, 3154, 1574, 26070400),
(1579, '新乡县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3155, 3156, 1574, 26070500),
(1580, '获嘉县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3157, 3158, 1574, 26070600),
(1581, '原阳县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3159, 3160, 1574, 26070700),
(1582, '延津县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3161, 3162, 1574, 26070800),
(1583, '封丘县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3163, 3164, 1574, 26070900),
(1584, '长垣县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3165, 3166, 1574, 26071000),
(1585, '卫辉市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3167, 3168, 1574, 26071100),
(1586, '辉县市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3169, 3170, 1574, 26071200),
(1587, '焦作市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3172, 3193, 1506, 26080000),
(1588, '解放区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3173, 3174, 1587, 26080100),
(1589, '中站区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3175, 3176, 1587, 26080200),
(1590, '马村区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3177, 3178, 1587, 26080300),
(1591, '山阳区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3179, 3180, 1587, 26080400),
(1592, '修武县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3181, 3182, 1587, 26080500),
(1593, '博爱县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3183, 3184, 1587, 26080600),
(1594, '武陟县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3185, 3186, 1587, 26080700),
(1595, '温县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3187, 3188, 1587, 26080800),
(1596, '沁阳市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3189, 3190, 1587, 26080900),
(1597, '孟州市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3191, 3192, 1587, 26081000),
(1598, '濮阳市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3194, 3207, 1506, 26090000),
(1599, '华龙区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3195, 3196, 1598, 26090100),
(1600, '清丰县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3197, 3198, 1598, 26090200),
(1601, '南乐县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3199, 3200, 1598, 26090300),
(1602, '范县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3201, 3202, 1598, 26090400),
(1603, '台前县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3203, 3204, 1598, 26090500),
(1604, '濮阳县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3205, 3206, 1598, 26090600),
(1605, '许昌市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3208, 3221, 1506, 26100000),
(1606, '魏都区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3209, 3210, 1605, 26100100),
(1607, '许昌县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3211, 3212, 1605, 26100200),
(1608, '鄢陵县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3213, 3214, 1605, 26100300),
(1609, '襄城县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3215, 3216, 1605, 26100400),
(1610, '禹州市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3217, 3218, 1605, 26100500),
(1611, '长葛市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3219, 3220, 1605, 26100600),
(1612, '漯河市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3222, 3233, 1506, 26110000),
(1613, '源汇区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3223, 3224, 1612, 26110100),
(1614, '郾城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3225, 3226, 1612, 26110200),
(1615, '召陵区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3227, 3228, 1612, 26110300),
(1616, '舞阳县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3229, 3230, 1612, 26110400),
(1617, '临颍县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3231, 3232, 1612, 26110500),
(1618, '三门峡市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3234, 3247, 1506, 26120000),
(1619, '湖滨区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3235, 3236, 1618, 26120100),
(1620, '陕州区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3237, 3238, 1618, 26120200),
(1621, '渑池县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3239, 3240, 1618, 26120300),
(1622, '卢氏县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3241, 3242, 1618, 26120400),
(1623, '义马市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3243, 3244, 1618, 26120500),
(1624, '灵宝市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3245, 3246, 1618, 26120600),
(1625, '南阳市', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3248, 3275, 1506, 26130000),
(1626, '宛城区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3249, 3250, 1625, 26130100),
(1627, '卧龙区', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3251, 3252, 1625, 26130200),
(1628, '南召县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3253, 3254, 1625, 26130300),
(1629, '方城县', 0, '2018-07-03 09:21:10', '2019-07-06 06:29:36', 3255, 3256, 1625, 26130400),
(1630, '西峡县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3257, 3258, 1625, 26130500),
(1631, '镇平县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3259, 3260, 1625, 26130600),
(1632, '内乡县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3261, 3262, 1625, 26130700),
(1633, '淅川县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3263, 3264, 1625, 26130800),
(1634, '社旗县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3265, 3266, 1625, 26130900),
(1635, '唐河县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3267, 3268, 1625, 26131000),
(1636, '新野县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3269, 3270, 1625, 26131100),
(1637, '桐柏县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3271, 3272, 1625, 26131200),
(1638, '邓州市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3273, 3274, 1625, 26131300),
(1639, '商丘市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3276, 3295, 1506, 26140000),
(1640, '梁园区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3277, 3278, 1639, 26140100),
(1641, '睢阳区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3279, 3280, 1639, 26140200),
(1642, '民权县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3281, 3282, 1639, 26140300),
(1643, '睢县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3283, 3284, 1639, 26140400),
(1644, '宁陵县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3285, 3286, 1639, 26140500),
(1645, '柘城县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3287, 3288, 1639, 26140600),
(1646, '虞城县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3289, 3290, 1639, 26140700),
(1647, '夏邑县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3291, 3292, 1639, 26140800),
(1648, '永城市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3293, 3294, 1639, 26140900),
(1649, '信阳市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3296, 3317, 1506, 26150000),
(1650, '�河区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3297, 3298, 1649, 26150100),
(1651, '平桥区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3299, 3300, 1649, 26150200),
(1652, '罗山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3301, 3302, 1649, 26150300),
(1653, '光山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3303, 3304, 1649, 26150400),
(1654, '新县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3305, 3306, 1649, 26150500),
(1655, '商城县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3307, 3308, 1649, 26150600),
(1656, '固始县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3309, 3310, 1649, 26150700),
(1657, '潢川县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3311, 3312, 1649, 26150800),
(1658, '淮滨县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3313, 3314, 1649, 26150900),
(1659, '息县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3315, 3316, 1649, 26151000),
(1660, '周口市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3318, 3339, 1506, 26160000),
(1661, '川汇区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3319, 3320, 1660, 26160100),
(1662, '扶沟县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3321, 3322, 1660, 26160200),
(1663, '西华县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3323, 3324, 1660, 26160300),
(1664, '商水县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3325, 3326, 1660, 26160400),
(1665, '沈丘县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3327, 3328, 1660, 26160500),
(1666, '郸城县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3329, 3330, 1660, 26160600),
(1667, '淮阳县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3331, 3332, 1660, 26160700),
(1668, '太康县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3333, 3334, 1660, 26160800),
(1669, '鹿邑县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3335, 3336, 1660, 26160900),
(1670, '项城市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3337, 3338, 1660, 26161000),
(1671, '驻马店市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3340, 3361, 1506, 26170000),
(1672, '驿城区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3341, 3342, 1671, 26170100),
(1673, '西平县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3343, 3344, 1671, 26170200),
(1674, '上蔡县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3345, 3346, 1671, 26170300),
(1675, '平舆县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3347, 3348, 1671, 26170400),
(1676, '正阳县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3349, 3350, 1671, 26170500),
(1677, '确山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3351, 3352, 1671, 26170600),
(1678, '泌阳县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3353, 3354, 1671, 26170700),
(1679, '汝南县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3355, 3356, 1671, 26170800),
(1680, '遂平县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3357, 3358, 1671, 26170900),
(1681, '新蔡县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3359, 3360, 1671, 26171000),
(1682, '省直辖县级行政区划', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3362, 3365, 1506, 26180000),
(1683, '济源市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3363, 3364, 1682, 26180100),
(1684, '湖北省', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3367, 3602, NULL, 27000000),
(1685, '武汉市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3368, 3395, 1684, 27010000),
(1686, '江岸区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3369, 3370, 1685, 27010100),
(1687, '江汉区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3371, 3372, 1685, 27010200),
(1688, '�口区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3373, 3374, 1685, 27010300),
(1689, '汉阳区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3375, 3376, 1685, 27010400),
(1690, '武昌区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3377, 3378, 1685, 27010500),
(1691, '青山区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3379, 3380, 1685, 27010600),
(1692, '洪山区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3381, 3382, 1685, 27010700),
(1693, '东西湖区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3383, 3384, 1685, 27010800),
(1694, '汉南区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3385, 3386, 1685, 27010900),
(1695, '蔡甸区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3387, 3388, 1685, 27011000);";

        $sql4 = "INSERT INTO `area` (`id`, `name`, `disabled`, `created_at`, `updated_at`, `_lft`, `_rgt`, `parent_id`, `code`) VALUES
(1696, '江夏区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3389, 3390, 1685, 27011100),
(1697, '黄陂区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3391, 3392, 1685, 27011200),
(1698, '新洲区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3393, 3394, 1685, 27011300),
(1699, '黄石市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3396, 3409, 1684, 27020000),
(1700, '黄石港区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3397, 3398, 1699, 27020100),
(1701, '西塞山区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3399, 3400, 1699, 27020200),
(1702, '下陆区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3401, 3402, 1699, 27020300),
(1703, '铁山区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3403, 3404, 1699, 27020400),
(1704, '阳新县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3405, 3406, 1699, 27020500),
(1705, '大冶市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3407, 3408, 1699, 27020600),
(1706, '十堰市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3410, 3427, 1684, 27030000),
(1707, '茅箭区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3411, 3412, 1706, 27030100),
(1708, '张湾区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3413, 3414, 1706, 27030200),
(1709, '郧阳区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3415, 3416, 1706, 27030300),
(1710, '郧西县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3417, 3418, 1706, 27030400),
(1711, '竹山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:36', 3419, 3420, 1706, 27030500),
(1712, '竹溪县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3421, 3422, 1706, 27030600),
(1713, '房县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3423, 3424, 1706, 27030700),
(1714, '丹江口市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3425, 3426, 1706, 27030800),
(1715, '宜昌市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3428, 3455, 1684, 27040000),
(1716, '西陵区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3429, 3430, 1715, 27040100),
(1717, '伍家岗区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3431, 3432, 1715, 27040200),
(1718, '点军区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3433, 3434, 1715, 27040300),
(1719, '猇亭区', 0, '2018-07-03 09:21:11', '2020-11-16 02:58:17', 3435, 3436, 1715, 27040400),
(1720, '夷陵区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3437, 3438, 1715, 27040500),
(1721, '远安县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3439, 3440, 1715, 27040600),
(1722, '兴山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3441, 3442, 1715, 27040700),
(1723, '秭归县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3443, 3444, 1715, 27040800),
(1724, '长阳土家族自治县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3445, 3446, 1715, 27040900),
(1725, '五峰土家族自治县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3447, 3448, 1715, 27041000),
(1726, '宜都市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3449, 3450, 1715, 27041100),
(1727, '当阳市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3451, 3452, 1715, 27041200),
(1728, '枝江市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3453, 3454, 1715, 27041300),
(1729, '襄阳市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3456, 3475, 1684, 27050000),
(1730, '襄城区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3457, 3458, 1729, 27050100),
(1731, '樊城区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3459, 3460, 1729, 27050200),
(1732, '襄州区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3461, 3462, 1729, 27050300),
(1733, '南漳县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3463, 3464, 1729, 27050400),
(1734, '谷城县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3465, 3466, 1729, 27050500),
(1735, '保康县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3467, 3468, 1729, 27050600),
(1736, '老河口市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3469, 3470, 1729, 27050700),
(1737, '枣阳市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3471, 3472, 1729, 27050800),
(1738, '宜城市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3473, 3474, 1729, 27050900),
(1739, '鄂州市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3476, 3483, 1684, 27060000),
(1740, '梁子湖区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3477, 3478, 1739, 27060100),
(1741, '华容区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3479, 3480, 1739, 27060200),
(1742, '鄂城区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3481, 3482, 1739, 27060300),
(1743, '荆门市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3484, 3495, 1684, 27070000),
(1744, '东宝区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3485, 3486, 1743, 27070100),
(1745, '掇刀区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3487, 3488, 1743, 27070200),
(1746, '京山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3489, 3490, 1743, 27070300),
(1747, '沙洋县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3491, 3492, 1743, 27070400),
(1748, '钟祥市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3493, 3494, 1743, 27070500),
(1749, '孝感市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3496, 3511, 1684, 27080000),
(1750, '孝南区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3497, 3498, 1749, 27080100),
(1751, '孝昌县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3499, 3500, 1749, 27080200),
(1752, '大悟县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3501, 3502, 1749, 27080300),
(1753, '云梦县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3503, 3504, 1749, 27080400),
(1754, '应城市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3505, 3506, 1749, 27080500),
(1755, '安陆市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3507, 3508, 1749, 27080600),
(1756, '汉川市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3509, 3510, 1749, 27080700),
(1757, '荆州市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3512, 3529, 1684, 27090000),
(1758, '沙市区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3513, 3514, 1757, 27090100),
(1759, '荆州区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3515, 3516, 1757, 27090200),
(1760, '公安县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3517, 3518, 1757, 27090300),
(1761, '监利县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3519, 3520, 1757, 27090400),
(1762, '江陵县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3521, 3522, 1757, 27090500),
(1763, '石首市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3523, 3524, 1757, 27090600),
(1764, '洪湖市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3525, 3526, 1757, 27090700),
(1765, '松滋市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3527, 3528, 1757, 27090800),
(1766, '黄冈市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3530, 3551, 1684, 27100000),
(1767, '黄州区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3531, 3532, 1766, 27100100),
(1768, '团风县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3533, 3534, 1766, 27100200),
(1769, '红安县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3535, 3536, 1766, 27100300),
(1770, '罗田县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3537, 3538, 1766, 27100400),
(1771, '英山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3539, 3540, 1766, 27100500),
(1772, '浠水县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3541, 3542, 1766, 27100600),
(1773, '蕲春县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3543, 3544, 1766, 27100700),
(1774, '黄梅县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3545, 3546, 1766, 27100800),
(1775, '麻城市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3547, 3548, 1766, 27100900),
(1776, '武穴市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3549, 3550, 1766, 27101000),
(1777, '咸宁市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3552, 3565, 1684, 27110000),
(1778, '咸安区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3553, 3554, 1777, 27110100),
(1779, '嘉鱼县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3555, 3556, 1777, 27110200),
(1780, '通城县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3557, 3558, 1777, 27110300),
(1781, '崇阳县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3559, 3560, 1777, 27110400),
(1782, '通山县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3561, 3562, 1777, 27110500),
(1783, '赤壁市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3563, 3564, 1777, 27110600),
(1784, '随州市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3566, 3573, 1684, 27120000),
(1785, '曾都区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3567, 3568, 1784, 27120100),
(1786, '随县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3569, 3570, 1784, 27120200),
(1787, '广水市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3571, 3572, 1784, 27120300),
(1788, '恩施土家族苗族自治州', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3574, 3591, 1684, 27130000),
(1789, '恩施市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3575, 3576, 1788, 27130100),
(1790, '利川市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3577, 3578, 1788, 27130200),
(1791, '建始县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3579, 3580, 1788, 27130300),
(1792, '巴东县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3581, 3582, 1788, 27130400),
(1793, '宣恩县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3583, 3584, 1788, 27130500),
(1794, '咸丰县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3585, 3586, 1788, 27130600),
(1795, '来凤县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3587, 3588, 1788, 27130700),
(1796, '鹤峰县', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3589, 3590, 1788, 27130800),
(1797, '省直辖县级行政区划', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3592, 3601, 1684, 27140000),
(1798, '仙桃市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3593, 3594, 1797, 27140100),
(1799, '潜江市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3595, 3596, 1797, 27140200),
(1800, '天门市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3597, 3598, 1797, 27140300),
(1801, '神农架林区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3599, 3600, 1797, 27140400),
(1802, '湖南省', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3603, 3876, NULL, 28000000),
(1803, '长沙市', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3604, 3623, 1802, 28010000),
(1804, '芙蓉区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3605, 3606, 1803, 28010100),
(1805, '天心区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3607, 3608, 1803, 28010200),
(1806, '岳麓区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3609, 3610, 1803, 28010300),
(1807, '开福区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3611, 3612, 1803, 28010400),
(1808, '雨花区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3613, 3614, 1803, 28010500),
(1809, '望城区', 0, '2018-07-03 09:21:11', '2019-07-06 06:29:37', 3615, 3616, 1803, 28010600),
(1810, '长沙县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3617, 3618, 1803, 28010700),
(1811, '宁乡县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3619, 3620, 1803, 28010800),
(1812, '浏阳市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3621, 3622, 1803, 28010900),
(1813, '株洲市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3624, 3643, 1802, 28020000),
(1814, '荷塘区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3625, 3626, 1813, 28020100),
(1815, '芦淞区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3627, 3628, 1813, 28020200),
(1816, '石峰区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3629, 3630, 1813, 28020300),
(1817, '天元区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3631, 3632, 1813, 28020400),
(1818, '株洲县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3633, 3634, 1813, 28020500),
(1819, '攸县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3635, 3636, 1813, 28020600),
(1820, '茶陵县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3637, 3638, 1813, 28020700),
(1821, '炎陵县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3639, 3640, 1813, 28020800),
(1822, '醴陵市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3641, 3642, 1813, 28020900),
(1823, '湘潭市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3644, 3655, 1802, 28030000),
(1824, '雨湖区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3645, 3646, 1823, 28030100),
(1825, '岳塘区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3647, 3648, 1823, 28030200),
(1826, '湘潭县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3649, 3650, 1823, 28030300),
(1827, '湘乡市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3651, 3652, 1823, 28030400),
(1828, '韶山市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3653, 3654, 1823, 28030500),
(1829, '衡阳市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3656, 3681, 1802, 28040000),
(1830, '珠晖区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3657, 3658, 1829, 28040100),
(1831, '雁峰区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3659, 3660, 1829, 28040200),
(1832, '石鼓区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3661, 3662, 1829, 28040300),
(1833, '蒸湘区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3663, 3664, 1829, 28040400),
(1834, '南岳区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3665, 3666, 1829, 28040500),
(1835, '衡阳县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3667, 3668, 1829, 28040600),
(1836, '衡南县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3669, 3670, 1829, 28040700),
(1837, '衡山县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3671, 3672, 1829, 28040800),
(1838, '衡东县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3673, 3674, 1829, 28040900),
(1839, '祁东县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3675, 3676, 1829, 28041000),
(1840, '耒阳市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3677, 3678, 1829, 28041100),
(1841, '常宁市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3679, 3680, 1829, 28041200),
(1842, '邵阳市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3682, 3707, 1802, 28050000),
(1843, '双清区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3683, 3684, 1842, 28050100),
(1844, '大祥区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3685, 3686, 1842, 28050200),
(1845, '北塔区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3687, 3688, 1842, 28050300),
(1846, '邵东县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3689, 3690, 1842, 28050400),
(1847, '新邵县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3691, 3692, 1842, 28050500),
(1848, '邵阳县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3693, 3694, 1842, 28050600),
(1849, '隆回县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3695, 3696, 1842, 28050700),
(1850, '洞口县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3697, 3698, 1842, 28050800),
(1851, '绥宁县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3699, 3700, 1842, 28050900),
(1852, '新宁县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3701, 3702, 1842, 28051000),
(1853, '城步苗族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3703, 3704, 1842, 28051100),
(1854, '武冈市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3705, 3706, 1842, 28051200),
(1855, '岳阳市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3708, 3727, 1802, 28060000),
(1856, '岳阳楼区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3709, 3710, 1855, 28060100),
(1857, '云溪区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3711, 3712, 1855, 28060200),
(1858, '君山区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3713, 3714, 1855, 28060300),
(1859, '岳阳县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3715, 3716, 1855, 28060400),
(1860, '华容县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3717, 3718, 1855, 28060500),
(1861, '湘阴县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3719, 3720, 1855, 28060600),
(1862, '平江县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3721, 3722, 1855, 28060700),
(1863, '汨罗市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3723, 3724, 1855, 28060800),
(1864, '临湘市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3725, 3726, 1855, 28060900),
(1865, '常德市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3728, 3747, 1802, 28070000),
(1866, '武陵区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3729, 3730, 1865, 28070100),
(1867, '鼎城区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3731, 3732, 1865, 28070200),
(1868, '安乡县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3733, 3734, 1865, 28070300),
(1869, '汉寿县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3735, 3736, 1865, 28070400),
(1870, '澧县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3737, 3738, 1865, 28070500),
(1871, '临澧县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3739, 3740, 1865, 28070600),
(1872, '桃源县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3741, 3742, 1865, 28070700),
(1873, '石门县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3743, 3744, 1865, 28070800),
(1874, '津市市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3745, 3746, 1865, 28070900),
(1875, '张家界市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3748, 3757, 1802, 28080000),
(1876, '永定区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3749, 3750, 1875, 28080100),
(1877, '武陵源区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3751, 3752, 1875, 28080200),
(1878, '慈利县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3753, 3754, 1875, 28080300),
(1879, '桑植县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3755, 3756, 1875, 28080400),
(1880, '益阳市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3758, 3771, 1802, 28090000),
(1881, '资阳区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3759, 3760, 1880, 28090100),
(1882, '赫山区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3761, 3762, 1880, 28090200),
(1883, '南县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3763, 3764, 1880, 28090300),
(1884, '桃江县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3765, 3766, 1880, 28090400),
(1885, '安化县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3767, 3768, 1880, 28090500),
(1886, '沅江市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3769, 3770, 1880, 28090600),
(1887, '郴州市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3772, 3795, 1802, 28100000),
(1888, '北湖区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3773, 3774, 1887, 28100100),
(1889, '苏仙区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3775, 3776, 1887, 28100200),
(1890, '桂阳县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3777, 3778, 1887, 28100300),
(1891, '宜章县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3779, 3780, 1887, 28100400),
(1892, '永兴县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3781, 3782, 1887, 28100500),
(1893, '嘉禾县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3783, 3784, 1887, 28100600),
(1894, '临武县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3785, 3786, 1887, 28100700),
(1895, '汝城县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3787, 3788, 1887, 28100800),
(1896, '桂东县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3789, 3790, 1887, 28100900),
(1897, '安仁县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3791, 3792, 1887, 28101000),
(1898, '资兴市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3793, 3794, 1887, 28101100),
(1899, '永州市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3796, 3819, 1802, 28110000),
(1900, '零陵区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3797, 3798, 1899, 28110100),
(1901, '冷水滩区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3799, 3800, 1899, 28110200),
(1902, '祁阳县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3801, 3802, 1899, 28110300),
(1903, '东安县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3803, 3804, 1899, 28110400),
(1904, '双牌县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3805, 3806, 1899, 28110500),
(1905, '道县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3807, 3808, 1899, 28110600),
(1906, '江永县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3809, 3810, 1899, 28110700),
(1907, '宁远县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3811, 3812, 1899, 28110800),
(1908, '蓝山县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3813, 3814, 1899, 28110900),
(1909, '新田县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3815, 3816, 1899, 28111000),
(1910, '江华瑶族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3817, 3818, 1899, 28111100),
(1911, '怀化市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3820, 3845, 1802, 28120000),
(1912, '鹤城区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3821, 3822, 1911, 28120100),
(1913, '中方县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3823, 3824, 1911, 28120200),
(1914, '沅陵县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3825, 3826, 1911, 28120300),
(1915, '辰溪县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3827, 3828, 1911, 28120400),
(1916, '溆浦县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3829, 3830, 1911, 28120500),
(1917, '会同县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3831, 3832, 1911, 28120600),
(1918, '麻阳苗族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3833, 3834, 1911, 28120700),
(1919, '新晃侗族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3835, 3836, 1911, 28120800),
(1920, '芷江侗族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3837, 3838, 1911, 28120900),
(1921, '靖州苗族侗族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3839, 3840, 1911, 28121000),
(1922, '通道侗族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3841, 3842, 1911, 28121100),
(1923, '洪江市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3843, 3844, 1911, 28121200),
(1924, '娄底市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3846, 3857, 1802, 28130000),
(1925, '娄星区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3847, 3848, 1924, 28130100),
(1926, '双峰县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3849, 3850, 1924, 28130200),
(1927, '新化县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3851, 3852, 1924, 28130300),
(1928, '冷水江市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3853, 3854, 1924, 28130400),
(1929, '涟源市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3855, 3856, 1924, 28130500),
(1930, '湘西土家族苗族自治州', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3858, 3875, 1802, 28140000),
(1931, '吉首市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3859, 3860, 1930, 28140100),
(1932, '泸溪县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:37', 3861, 3862, 1930, 28140200),
(1933, '凤凰县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3863, 3864, 1930, 28140300),
(1934, '花垣县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3865, 3866, 1930, 28140400),
(1935, '保靖县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3867, 3868, 1930, 28140500),
(1936, '古丈县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3869, 3870, 1930, 28140600),
(1937, '永顺县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3871, 3872, 1930, 28140700),
(1938, '龙山县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3873, 3874, 1930, 28140800),
(1939, '广东省', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3877, 4270, NULL, 29000000),
(1940, '广州市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3878, 3901, 1939, 29010000),
(1941, '荔湾区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3879, 3880, 1940, 29010100),
(1942, '越秀区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3881, 3882, 1940, 29010200),
(1943, '海珠区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3883, 3884, 1940, 29010300),
(1944, '天河区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3885, 3886, 1940, 29010400),
(1945, '白云区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3887, 3888, 1940, 29010500),
(1946, '黄埔区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3889, 3890, 1940, 29010600),
(1947, '番禺区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3891, 3892, 1940, 29010700),
(1948, '花都区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3893, 3894, 1940, 29010800),
(1949, '南沙区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3895, 3896, 1940, 29010900),
(1950, '从化区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3897, 3898, 1940, 29011000),
(1951, '增城区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3899, 3900, 1940, 29011100),
(1952, '韶关市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3902, 3923, 1939, 29020000),
(1953, '武江区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3903, 3904, 1952, 29020100),
(1954, '浈江区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3905, 3906, 1952, 29020200),
(1955, '曲江区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3907, 3908, 1952, 29020300),
(1956, '始兴县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3909, 3910, 1952, 29020400),
(1957, '仁化县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3911, 3912, 1952, 29020500),
(1958, '翁源县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3913, 3914, 1952, 29020600),
(1959, '乳源瑶族自治县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3915, 3916, 1952, 29020700),
(1960, '新丰县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3917, 3918, 1952, 29020800),
(1961, '乐昌市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3919, 3920, 1952, 29020900),
(1962, '南雄市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3921, 3922, 1952, 29021000),
(1963, '深圳市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3924, 3945, 1939, 29030000),
(1964, '罗湖区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3925, 3926, 1963, 29030100),
(1965, '福田区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3927, 3928, 1963, 29030200),
(1966, '南山区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3929, 3930, 1963, 29030300),
(1967, '宝安区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3931, 3932, 1963, 29030400),
(1968, '龙岗区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3933, 3934, 1963, 29030500),
(1969, '盐田区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3935, 3936, 1963, 29030600),
(1970, '珠海市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3946, 3953, 1939, 29040000),
(1971, '香洲区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3947, 3948, 1970, 29040100),
(1972, '斗门区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3949, 3950, 1970, 29040200),
(1973, '金湾区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3951, 3952, 1970, 29040300),
(1974, '汕头市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3954, 3969, 1939, 29050000),
(1975, '龙湖区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3955, 3956, 1974, 29050100),
(1976, '金平区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3957, 3958, 1974, 29050200),
(1977, '濠江区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3959, 3960, 1974, 29050300),
(1978, '潮阳区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3961, 3962, 1974, 29050400),
(1979, '潮南区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3963, 3964, 1974, 29050500),
(1980, '澄海区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3965, 3966, 1974, 29050600),
(1981, '南澳县', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3967, 3968, 1974, 29050700),
(1982, '佛山市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3970, 3981, 1939, 29060000),
(1983, '禅城区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3971, 3972, 1982, 29060100),
(1984, '南海区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3973, 3974, 1982, 29060200),
(1985, '顺德区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3975, 3976, 1982, 29060300),
(1986, '三水区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3977, 3978, 1982, 29060400),
(1987, '高明区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3979, 3980, 1982, 29060500),
(1988, '江门市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3982, 3997, 1939, 29070000),
(1989, '蓬江区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3983, 3984, 1988, 29070100),
(1990, '江海区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3985, 3986, 1988, 29070200),
(1991, '新会区', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3987, 3988, 1988, 29070300),
(1992, '台山市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3989, 3990, 1988, 29070400),
(1993, '开平市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3991, 3992, 1988, 29070500),
(1994, '鹤山市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3993, 3994, 1988, 29070600),
(1995, '恩平市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3995, 3996, 1988, 29070700),
(1996, '湛江市', 0, '2018-07-03 09:21:12', '2019-07-06 06:29:38', 3998, 4017, 1939, 29080000),
(1997, '赤坎区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 3999, 4000, 1996, 29080100),
(1998, '霞山区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4001, 4002, 1996, 29080200),
(1999, '坡头区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4003, 4004, 1996, 29080300),
(2000, '麻章区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4005, 4006, 1996, 29080400),
(2001, '遂溪县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4007, 4008, 1996, 29080500),
(2002, '徐闻县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4009, 4010, 1996, 29080600),
(2003, '廉江市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4011, 4012, 1996, 29080700),
(2004, '雷州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4013, 4014, 1996, 29080800),
(2005, '吴川市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4015, 4016, 1996, 29080900),
(2006, '茂名市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4018, 4029, 1939, 29090000),
(2007, '茂南区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4019, 4020, 2006, 29090100),
(2008, '电白区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4021, 4022, 2006, 29090200),
(2009, '高州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4023, 4024, 2006, 29090300),
(2010, '化州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4025, 4026, 2006, 29090400),
(2011, '信宜市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4027, 4028, 2006, 29090500),
(2012, '肇庆市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4030, 4047, 1939, 29100000),
(2013, '端州区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4031, 4032, 2012, 29100100),
(2014, '鼎湖区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4033, 4034, 2012, 29100200),
(2015, '高要区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4035, 4036, 2012, 29100300),
(2016, '广宁县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4037, 4038, 2012, 29100400),
(2017, '怀集县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4039, 4040, 2012, 29100500),
(2018, '封开县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4041, 4042, 2012, 29100600),
(2019, '德庆县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4043, 4044, 2012, 29100700),
(2020, '四会市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4045, 4046, 2012, 29100800),
(2021, '惠州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4048, 4059, 1939, 29110000),
(2022, '惠城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4049, 4050, 2021, 29110100),
(2023, '惠阳区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4051, 4052, 2021, 29110200),
(2024, '博罗县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4053, 4054, 2021, 29110300),
(2025, '惠东县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4055, 4056, 2021, 29110400),
(2026, '龙门县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4057, 4058, 2021, 29110500),
(2027, '梅州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4060, 4077, 1939, 29120000),
(2028, '梅江区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4061, 4062, 2027, 29120100),
(2029, '梅县区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4063, 4064, 2027, 29120200),
(2030, '大埔县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4065, 4066, 2027, 29120300),
(2031, '丰顺县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4067, 4068, 2027, 29120400),
(2032, '五华县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4069, 4070, 2027, 29120500),
(2033, '平远县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4071, 4072, 2027, 29120600),
(2034, '蕉岭县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4073, 4074, 2027, 29120700),
(2035, '兴宁市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4075, 4076, 2027, 29120800),
(2036, '汕尾市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4078, 4087, 1939, 29130000),
(2037, '城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4079, 4080, 2036, 29130100),
(2038, '海丰县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4081, 4082, 2036, 29130200),
(2039, '陆河县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4083, 4084, 2036, 29130300),
(2040, '陆丰市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4085, 4086, 2036, 29130400),
(2041, '河源市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4088, 4101, 1939, 29140000),
(2042, '源城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4089, 4090, 2041, 29140100),
(2043, '紫金县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4091, 4092, 2041, 29140200),
(2044, '龙川县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4093, 4094, 2041, 29140300),
(2045, '连平县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4095, 4096, 2041, 29140400),
(2046, '和平县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4097, 4098, 2041, 29140500),
(2047, '东源县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4099, 4100, 2041, 29140600),
(2048, '阳江市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4102, 4111, 1939, 29150000),
(2049, '江城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4103, 4104, 2048, 29150100),
(2050, '阳东区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4105, 4106, 2048, 29150200),
(2051, '阳西县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4107, 4108, 2048, 29150300),
(2052, '阳春市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4109, 4110, 2048, 29150400),
(2053, '清远市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4112, 4129, 1939, 29160000),
(2054, '清城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4113, 4114, 2053, 29160100),
(2055, '清新区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4115, 4116, 2053, 29160200),
(2056, '佛冈县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4117, 4118, 2053, 29160300),
(2057, '阳山县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4119, 4120, 2053, 29160400),
(2058, '连山壮族瑶族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4121, 4122, 2053, 29160500),
(2059, '连南瑶族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4123, 4124, 2053, 29160600),
(2060, '英德市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4125, 4126, 2053, 29160700),
(2061, '连州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4127, 4128, 2053, 29160800),
(2062, '东莞市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4130, 4187, 1939, 29170000),
(2063, '中山市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4188, 4237, 1939, 29180000),
(2064, '潮州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4238, 4245, 1939, 29190000),
(2065, '湘桥区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4239, 4240, 2064, 29190100),
(2066, '潮安区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4241, 4242, 2064, 29190200),
(2067, '饶平县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4243, 4244, 2064, 29190300),
(2068, '揭阳市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4246, 4257, 1939, 29200000),
(2069, '榕城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4247, 4248, 2068, 29200100),
(2070, '揭东区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4249, 4250, 2068, 29200200),
(2071, '揭西县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4251, 4252, 2068, 29200300),
(2072, '惠来县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4253, 4254, 2068, 29200400),
(2073, '普宁市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4255, 4256, 2068, 29200500),
(2074, '云浮市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4258, 4269, 1939, 29210000),
(2075, '云城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4259, 4260, 2074, 29210100),
(2076, '云安区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4261, 4262, 2074, 29210200),
(2077, '新兴县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4263, 4264, 2074, 29210300),
(2078, '郁南县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4265, 4266, 2074, 29210400),
(2079, '罗定市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4267, 4268, 2074, 29210500),
(2080, '广西壮族自治区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4271, 4522, NULL, 30000000),
(2081, '南宁市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4272, 4297, 2080, 30010000),
(2082, '兴宁区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4273, 4274, 2081, 30010100),
(2083, '青秀区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4275, 4276, 2081, 30010200),
(2084, '江南区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4277, 4278, 2081, 30010300),
(2085, '西乡塘区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4279, 4280, 2081, 30010400),
(2086, '良庆区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4281, 4282, 2081, 30010500),
(2087, '邕宁区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4283, 4284, 2081, 30010600),
(2088, '武鸣区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4285, 4286, 2081, 30010700),
(2089, '隆安县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4287, 4288, 2081, 30010800),
(2090, '马山县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4289, 4290, 2081, 30010900),
(2091, '上林县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4291, 4292, 2081, 30011000),
(2092, '宾阳县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4293, 4294, 2081, 30011100),
(2093, '横县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4295, 4296, 2081, 30011200),
(2094, '柳州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4298, 4319, 2080, 30020000),
(2095, '城中区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4299, 4300, 2094, 30020100),
(2096, '鱼峰区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4301, 4302, 2094, 30020200),
(2097, '柳南区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4303, 4304, 2094, 30020300),
(2098, '柳北区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4305, 4306, 2094, 30020400),
(2099, '柳江区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4307, 4308, 2094, 30020500),
(2100, '柳城县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4309, 4310, 2094, 30020600),
(2101, '鹿寨县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4311, 4312, 2094, 30020700),
(2102, '融安县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4313, 4314, 2094, 30020800),
(2103, '融水苗族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4315, 4316, 2094, 30020900),
(2104, '三江侗族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4317, 4318, 2094, 30021000),
(2105, '桂林市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4320, 4355, 2080, 30030000),
(2106, '秀峰区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4321, 4322, 2105, 30030100),
(2107, '叠彩区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4323, 4324, 2105, 30030200),
(2108, '象山区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4325, 4326, 2105, 30030300),
(2109, '七星区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4327, 4328, 2105, 30030400),
(2110, '雁山区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4329, 4330, 2105, 30030500),
(2111, '临桂区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4331, 4332, 2105, 30030600),
(2112, '阳朔县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4333, 4334, 2105, 30030700),
(2113, '灵川县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4335, 4336, 2105, 30030800),
(2114, '全州县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4337, 4338, 2105, 30030900),
(2115, '兴安县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4339, 4340, 2105, 30031000),
(2116, '永福县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4341, 4342, 2105, 30031100),
(2117, '灌阳县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4343, 4344, 2105, 30031200),
(2118, '龙胜各族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4345, 4346, 2105, 30031300),
(2119, '资源县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4347, 4348, 2105, 30031400),
(2120, '平乐县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4349, 4350, 2105, 30031500),
(2121, '荔浦县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4351, 4352, 2105, 30031600),
(2122, '恭城瑶族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4353, 4354, 2105, 30031700),
(2123, '梧州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4356, 4371, 2080, 30040000),
(2124, '万秀区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4357, 4358, 2123, 30040100),
(2125, '长洲区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4359, 4360, 2123, 30040200),
(2126, '龙圩区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4361, 4362, 2123, 30040300),
(2127, '苍梧县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4363, 4364, 2123, 30040400),
(2128, '藤县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4365, 4366, 2123, 30040500),
(2129, '蒙山县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4367, 4368, 2123, 30040600),
(2130, '岑溪市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4369, 4370, 2123, 30040700),
(2131, '北海市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4372, 4381, 2080, 30050000),
(2132, '海城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4373, 4374, 2131, 30050100),
(2133, '银海区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4375, 4376, 2131, 30050200),
(2134, '铁山港区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4377, 4378, 2131, 30050300),
(2135, '合浦县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4379, 4380, 2131, 30050400),
(2136, '防城港市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4382, 4391, 2080, 30060000),
(2137, '港口区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4383, 4384, 2136, 30060100),
(2138, '防城区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4385, 4386, 2136, 30060200),
(2139, '上思县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4387, 4388, 2136, 30060300),
(2140, '东兴市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4389, 4390, 2136, 30060400),
(2141, '钦州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4392, 4401, 2080, 30070000),
(2142, '钦南区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4393, 4394, 2141, 30070100),
(2143, '钦北区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4395, 4396, 2141, 30070200),
(2144, '灵山县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4397, 4398, 2141, 30070300),
(2145, '浦北县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4399, 4400, 2141, 30070400),
(2146, '贵港市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4402, 4413, 2080, 30080000),
(2147, '港北区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4403, 4404, 2146, 30080100),
(2148, '港南区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4405, 4406, 2146, 30080200),
(2149, '覃塘区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4407, 4408, 2146, 30080300),
(2150, '平南县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4409, 4410, 2146, 30080400),
(2151, '桂平市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4411, 4412, 2146, 30080500),
(2152, '玉林市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4414, 4429, 2080, 30090000),
(2153, '玉州区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4415, 4416, 2152, 30090100),
(2154, '福绵区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4417, 4418, 2152, 30090200),
(2155, '容县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4419, 4420, 2152, 30090300),
(2156, '陆川县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4421, 4422, 2152, 30090400),
(2157, '博白县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4423, 4424, 2152, 30090500),
(2158, '兴业县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4425, 4426, 2152, 30090600),
(2159, '北流市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4427, 4428, 2152, 30090700),
(2160, '百色市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4430, 4455, 2080, 30100000),
(2161, '右江区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4431, 4432, 2160, 30100100),
(2162, '田阳县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4433, 4434, 2160, 30100200),
(2163, '田东县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4435, 4436, 2160, 30100300),
(2164, '平果县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4437, 4438, 2160, 30100400),
(2165, '德保县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:38', 4439, 4440, 2160, 30100500),
(2166, '那坡县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4441, 4442, 2160, 30100600),
(2167, '凌云县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4443, 4444, 2160, 30100700),
(2168, '乐业县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4445, 4446, 2160, 30100800),
(2169, '田林县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4447, 4448, 2160, 30100900),
(2170, '西林县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4449, 4450, 2160, 30101000),
(2171, '隆林各族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4451, 4452, 2160, 30101100),
(2172, '靖西市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4453, 4454, 2160, 30101200),
(2173, '贺州市', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4456, 4467, 2080, 30110000),
(2174, '八步区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4457, 4458, 2173, 30110100),
(2175, '平桂区', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4459, 4460, 2173, 30110200),
(2176, '昭平县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4461, 4462, 2173, 30110300),
(2177, '钟山县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4463, 4464, 2173, 30110400),
(2178, '富川瑶族自治县', 0, '2018-07-03 09:21:13', '2019-07-06 06:29:39', 4465, 4466, 2173, 30110500),
(2179, '河池市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4468, 4491, 2080, 30120000),
(2180, '金城江区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4469, 4470, 2179, 30120100),
(2181, '南丹县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4471, 4472, 2179, 30120200),
(2182, '天峨县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4473, 4474, 2179, 30120300),
(2183, '凤山县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4475, 4476, 2179, 30120400),
(2184, '东兰县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4477, 4478, 2179, 30120500),
(2185, '罗城仫佬族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4479, 4480, 2179, 30120600),
(2186, '环江毛南族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4481, 4482, 2179, 30120700),
(2187, '巴马瑶族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4483, 4484, 2179, 30120800),
(2188, '都安瑶族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4485, 4486, 2179, 30120900),
(2189, '大化瑶族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4487, 4488, 2179, 30121000),
(2190, '宜州市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4489, 4490, 2179, 30121100),
(2191, '来宾市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4492, 4505, 2080, 30130000),
(2192, '兴宾区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4493, 4494, 2191, 30130100),
(2193, '忻城县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4495, 4496, 2191, 30130200),
(2194, '象州县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4497, 4498, 2191, 30130300),
(2195, '武宣县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4499, 4500, 2191, 30130400),
(2196, '金秀瑶族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4501, 4502, 2191, 30130500),
(2197, '合山市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4503, 4504, 2191, 30130600),
(2198, '崇左市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4506, 4521, 2080, 30140000),
(2199, '江州区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4507, 4508, 2198, 30140100),
(2200, '扶绥县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4509, 4510, 2198, 30140200),
(2201, '宁明县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4511, 4512, 2198, 30140300),
(2202, '龙州县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4513, 4514, 2198, 30140400),
(2203, '大新县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4515, 4516, 2198, 30140500),
(2204, '天等县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4517, 4518, 2198, 30140600),
(2205, '凭祥市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4519, 4520, 2198, 30140700),
(2206, '海南省', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4523, 4588, NULL, 31000000),
(2207, '海口市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4524, 4533, 2206, 31010000),
(2208, '秀英区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4525, 4526, 2207, 31010100),
(2209, '龙华区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4527, 4528, 2207, 31010200),
(2210, '琼山区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4529, 4530, 2207, 31010300),
(2211, '美兰区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4531, 4532, 2207, 31010400),
(2212, '三亚市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4534, 4545, 2206, 31020000),
(2213, '市辖区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4535, 4536, 2212, 31020100),
(2214, '海棠区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4537, 4538, 2212, 31020200),
(2215, '吉阳区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4539, 4540, 2212, 31020300),
(2216, '天涯区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4541, 4542, 2212, 31020400),
(2217, '崖州区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4543, 4544, 2212, 31020500),
(2218, '三沙市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4546, 4553, 2206, 31030000),
(2219, '西沙群岛', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4547, 4548, 2218, 31030100),
(2220, '南沙群岛', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4549, 4550, 2218, 31030200),
(2221, '中沙群岛的岛礁及其海域', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4551, 4552, 2218, 31030300),
(2222, '儋州市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4554, 4555, 2206, 31040000),
(2223, '省直辖县级行政区划', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4556, 4587, 2206, 31050000),
(2224, '五指山市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4557, 4558, 2223, 31050100),
(2225, '琼海市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4559, 4560, 2223, 31050200),
(2226, '文昌市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4561, 4562, 2223, 31050300),
(2227, '万宁市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4563, 4564, 2223, 31050400),
(2228, '东方市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4565, 4566, 2223, 31050500),
(2229, '定安县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4567, 4568, 2223, 31050600),
(2230, '屯昌县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4569, 4570, 2223, 31050700),
(2231, '澄迈县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4571, 4572, 2223, 31050800),
(2232, '临高县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4573, 4574, 2223, 31050900),
(2233, '白沙黎族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4575, 4576, 2223, 31051000),
(2234, '昌江黎族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4577, 4578, 2223, 31051100),
(2235, '乐东黎族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4579, 4580, 2223, 31051200),
(2236, '陵水黎族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4581, 4582, 2223, 31051300),
(2237, '保亭黎族苗族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4583, 4584, 2223, 31051400),
(2238, '琼中黎族苗族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4585, 4586, 2223, 31051500),
(2239, '重庆', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4589, 4670, NULL, 32000000),
(2240, '重庆市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4590, 4639, 2239, 32010000),
(2241, '万州区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4591, 4592, 2240, 32010100),
(2242, '涪陵区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4593, 4594, 2240, 32010200),
(2243, '渝中区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4595, 4596, 2240, 32010300),
(2244, '大渡口区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4597, 4598, 2240, 32010400),
(2245, '江北区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4599, 4600, 2240, 32010500),
(2246, '沙坪坝区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4601, 4602, 2240, 32010600),
(2247, '九龙坡区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4603, 4604, 2240, 32010700);";
        $sql5 = "INSERT INTO `area` (`id`, `name`, `disabled`, `created_at`, `updated_at`, `_lft`, `_rgt`, `parent_id`, `code`) VALUES
(2248, '南岸区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4605, 4606, 2240, 32010800),
(2249, '北碚区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4607, 4608, 2240, 32010900),
(2250, '綦江区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4609, 4610, 2240, 32011000),
(2251, '大足区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4611, 4612, 2240, 32011100),
(2252, '渝北区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4613, 4614, 2240, 32011200),
(2253, '巴南区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4615, 4616, 2240, 32011300),
(2254, '黔江区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4617, 4618, 2240, 32011400),
(2255, '长寿区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4619, 4620, 2240, 32011500),
(2256, '江津区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4621, 4622, 2240, 32011600),
(2257, '合川区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4623, 4624, 2240, 32011700),
(2258, '永川区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4625, 4626, 2240, 32011800),
(2259, '南川区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4627, 4628, 2240, 32011900),
(2260, '璧山区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4629, 4630, 2240, 32012000),
(2261, '铜梁区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4631, 4632, 2240, 32012100),
(2262, '潼南区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4633, 4634, 2240, 32012200),
(2263, '荣昌区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4635, 4636, 2240, 32012300),
(2264, '开州区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4637, 4638, 2240, 32012400),
(2265, '县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4640, 4669, 2239, 32020000),
(2266, '梁平县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4641, 4642, 2265, 32020100),
(2267, '城口县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4643, 4644, 2265, 32020200),
(2268, '丰都县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4645, 4646, 2265, 32020300),
(2269, '垫江县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4647, 4648, 2265, 32020400),
(2270, '武隆县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4649, 4650, 2265, 32020500),
(2271, '忠县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4651, 4652, 2265, 32020600),
(2272, '云阳县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4653, 4654, 2265, 32020700),
(2273, '奉节县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4655, 4656, 2265, 32020800),
(2274, '巫山县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4657, 4658, 2265, 32020900),
(2275, '巫溪县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4659, 4660, 2265, 32021000),
(2276, '石柱土家族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4661, 4662, 2265, 32021100),
(2277, '秀山土家族苗族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4663, 4664, 2265, 32021200),
(2278, '酉阳土家族苗族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4665, 4666, 2265, 32021300),
(2279, '彭水苗族土家族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4667, 4668, 2265, 32021400),
(2280, '四川省', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4671, 5080, NULL, 33000000),
(2281, '成都市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4672, 4713, 2280, 33010000),
(2282, '锦江区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4673, 4674, 2281, 33010100),
(2283, '青羊区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4675, 4676, 2281, 33010200),
(2284, '金牛区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4677, 4678, 2281, 33010300),
(2285, '武侯区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4679, 4680, 2281, 33010400),
(2286, '成华区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4681, 4682, 2281, 33010500),
(2287, '龙泉驿区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4683, 4684, 2281, 33010600),
(2288, '青白江区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4685, 4686, 2281, 33010700),
(2289, '新都区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4687, 4688, 2281, 33010800),
(2290, '温江区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4689, 4690, 2281, 33010900),
(2291, '双流区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4691, 4692, 2281, 33011000),
(2292, '金堂县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4693, 4694, 2281, 33011100),
(2293, '郫县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4695, 4696, 2281, 33011200),
(2294, '大邑县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4697, 4698, 2281, 33011300),
(2295, '蒲江县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4699, 4700, 2281, 33011400),
(2296, '新津县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4701, 4702, 2281, 33011500),
(2297, '都江堰市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4703, 4704, 2281, 33011600),
(2298, '彭州市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4705, 4706, 2281, 33011700),
(2299, '邛崃市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4707, 4708, 2281, 33011800),
(2300, '崇州市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4709, 4710, 2281, 33011900),
(2301, '简阳市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4711, 4712, 2281, 33012000),
(2302, '自贡市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4714, 4727, 2280, 33020000),
(2303, '自流井区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4715, 4716, 2302, 33020100),
(2304, '贡井区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4717, 4718, 2302, 33020200),
(2305, '大安区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4719, 4720, 2302, 33020300),
(2306, '沿滩区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4721, 4722, 2302, 33020400),
(2307, '荣县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4723, 4724, 2302, 33020500),
(2308, '富顺县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4725, 4726, 2302, 33020600),
(2309, '攀枝花市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4728, 4739, 2280, 33030000),
(2310, '东区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4729, 4730, 2309, 33030100),
(2311, '西区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4731, 4732, 2309, 33030200),
(2312, '仁和区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4733, 4734, 2309, 33030300),
(2313, '米易县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4735, 4736, 2309, 33030400),
(2314, '盐边县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4737, 4738, 2309, 33030500),
(2315, '泸州市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4740, 4755, 2280, 33040000),
(2316, '江阳区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4741, 4742, 2315, 33040100),
(2317, '纳溪区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4743, 4744, 2315, 33040200),
(2318, '龙马潭区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4745, 4746, 2315, 33040300),
(2319, '泸县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4747, 4748, 2315, 33040400),
(2320, '合江县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4749, 4750, 2315, 33040500),
(2321, '叙永县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4751, 4752, 2315, 33040600),
(2322, '古蔺县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4753, 4754, 2315, 33040700),
(2323, '德阳市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4756, 4769, 2280, 33050000),
(2324, '旌阳区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4757, 4758, 2323, 33050100),
(2325, '中江县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4759, 4760, 2323, 33050200),
(2326, '罗江县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4761, 4762, 2323, 33050300),
(2327, '广汉市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4763, 4764, 2323, 33050400),
(2328, '什邡市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4765, 4766, 2323, 33050500),
(2329, '绵竹市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4767, 4768, 2323, 33050600),
(2330, '绵阳市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4770, 4789, 2280, 33060000),
(2331, '涪城区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4771, 4772, 2330, 33060100),
(2332, '游仙区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4773, 4774, 2330, 33060200),
(2333, '安州区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4775, 4776, 2330, 33060300),
(2334, '三台县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4777, 4778, 2330, 33060400),
(2335, '盐亭县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4779, 4780, 2330, 33060500),
(2336, '梓潼县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4781, 4782, 2330, 33060600),
(2337, '北川羌族自治县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4783, 4784, 2330, 33060700),
(2338, '平武县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4785, 4786, 2330, 33060800),
(2339, '江油市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4787, 4788, 2330, 33060900),
(2340, '广元市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4790, 4805, 2280, 33070000),
(2341, '利州区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4791, 4792, 2340, 33070100),
(2342, '昭化区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4793, 4794, 2340, 33070200),
(2343, '朝天区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4795, 4796, 2340, 33070300),
(2344, '旺苍县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4797, 4798, 2340, 33070400),
(2345, '青川县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4799, 4800, 2340, 33070500),
(2346, '剑阁县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4801, 4802, 2340, 33070600),
(2347, '苍溪县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4803, 4804, 2340, 33070700),
(2348, '遂宁市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4806, 4817, 2280, 33080000),
(2349, '船山区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4807, 4808, 2348, 33080100),
(2350, '安居区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4809, 4810, 2348, 33080200),
(2351, '蓬溪县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4811, 4812, 2348, 33080300),
(2352, '射洪县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4813, 4814, 2348, 33080400),
(2353, '大英县', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4815, 4816, 2348, 33080500),
(2354, '内江市', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4818, 4829, 2280, 33090000),
(2355, '市中区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4819, 4820, 2354, 33090100),
(2356, '东兴区', 0, '2018-07-03 09:21:14', '2019-07-06 06:29:39', 4821, 4822, 2354, 33090200),
(2357, '威远县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4823, 4824, 2354, 33090300),
(2358, '资中县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4825, 4826, 2354, 33090400),
(2359, '隆昌县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4827, 4828, 2354, 33090500),
(2360, '乐山市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4830, 4853, 2280, 33100000),
(2361, '市中区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4831, 4832, 2360, 33100100),
(2362, '沙湾区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4833, 4834, 2360, 33100200),
(2363, '五通桥区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4835, 4836, 2360, 33100300),
(2364, '金口河区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4837, 4838, 2360, 33100400),
(2365, '犍为县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4839, 4840, 2360, 33100500),
(2366, '井研县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4841, 4842, 2360, 33100600),
(2367, '夹江县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4843, 4844, 2360, 33100700),
(2368, '沐川县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4845, 4846, 2360, 33100800),
(2369, '峨边彝族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4847, 4848, 2360, 33100900),
(2370, '马边彝族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4849, 4850, 2360, 33101000),
(2371, '峨眉山市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:39', 4851, 4852, 2360, 33101100),
(2372, '南充市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4854, 4873, 2280, 33110000),
(2373, '顺庆区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4855, 4856, 2372, 33110100),
(2374, '高坪区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4857, 4858, 2372, 33110200),
(2375, '嘉陵区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4859, 4860, 2372, 33110300),
(2376, '南部县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4861, 4862, 2372, 33110400),
(2377, '营山县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4863, 4864, 2372, 33110500),
(2378, '蓬安县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4865, 4866, 2372, 33110600),
(2379, '仪陇县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4867, 4868, 2372, 33110700),
(2380, '西充县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4869, 4870, 2372, 33110800),
(2381, '阆中市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4871, 4872, 2372, 33110900),
(2382, '眉山市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4874, 4887, 2280, 33120000),
(2383, '东坡区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4875, 4876, 2382, 33120100),
(2384, '彭山区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4877, 4878, 2382, 33120200),
(2385, '仁寿县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4879, 4880, 2382, 33120300),
(2386, '洪雅县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4881, 4882, 2382, 33120400),
(2387, '丹棱县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4883, 4884, 2382, 33120500),
(2388, '青神县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4885, 4886, 2382, 33120600),
(2389, '宜宾市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4888, 4909, 2280, 33130000),
(2390, '翠屏区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4889, 4890, 2389, 33130100),
(2391, '南溪区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4891, 4892, 2389, 33130200),
(2392, '宜宾县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4893, 4894, 2389, 33130300),
(2393, '江安县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4895, 4896, 2389, 33130400),
(2394, '长宁县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4897, 4898, 2389, 33130500),
(2395, '高县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4899, 4900, 2389, 33130600),
(2396, '珙县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4901, 4902, 2389, 33130700),
(2397, '筠连县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4903, 4904, 2389, 33130800),
(2398, '兴文县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4905, 4906, 2389, 33130900),
(2399, '屏山县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4907, 4908, 2389, 33131000),
(2400, '广安市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4910, 4923, 2280, 33140000),
(2401, '广安区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4911, 4912, 2400, 33140100),
(2402, '前锋区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4913, 4914, 2400, 33140200),
(2403, '岳池县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4915, 4916, 2400, 33140300),
(2404, '武胜县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4917, 4918, 2400, 33140400),
(2405, '邻水县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4919, 4920, 2400, 33140500),
(2406, '华蓥市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4921, 4922, 2400, 33140600),
(2407, '达州市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4924, 4939, 2280, 33150000),
(2408, '通川区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4925, 4926, 2407, 33150100),
(2409, '达川区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4927, 4928, 2407, 33150200),
(2410, '宣汉县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4929, 4930, 2407, 33150300),
(2411, '开江县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4931, 4932, 2407, 33150400),
(2412, '大竹县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4933, 4934, 2407, 33150500),
(2413, '渠县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4935, 4936, 2407, 33150600),
(2414, '万源市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4937, 4938, 2407, 33150700),
(2415, '雅安市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4940, 4957, 2280, 33160000),
(2416, '雨城区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4941, 4942, 2415, 33160100),
(2417, '名山区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4943, 4944, 2415, 33160200),
(2418, '荥经县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4945, 4946, 2415, 33160300),
(2419, '汉源县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4947, 4948, 2415, 33160400),
(2420, '石棉县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4949, 4950, 2415, 33160500),
(2421, '天全县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4951, 4952, 2415, 33160600),
(2422, '芦山县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4953, 4954, 2415, 33160700),
(2423, '宝兴县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4955, 4956, 2415, 33160800),
(2424, '巴中市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4958, 4969, 2280, 33170000),
(2425, '巴州区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4959, 4960, 2424, 33170100),
(2426, '恩阳区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4961, 4962, 2424, 33170200),
(2427, '通江县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4963, 4964, 2424, 33170300),
(2428, '南江县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4965, 4966, 2424, 33170400),
(2429, '平昌县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4967, 4968, 2424, 33170500),
(2430, '资阳市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4970, 4977, 2280, 33180000),
(2431, '雁江区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4971, 4972, 2430, 33180100),
(2432, '安岳县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4973, 4974, 2430, 33180200),
(2433, '乐至县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4975, 4976, 2430, 33180300),
(2434, '阿坝藏族羌族自治州', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4978, 5005, 2280, 33190000),
(2435, '马尔康市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4979, 4980, 2434, 33190100),
(2436, '汶川县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4981, 4982, 2434, 33190200),
(2437, '理县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4983, 4984, 2434, 33190300),
(2438, '茂县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4985, 4986, 2434, 33190400),
(2439, '松潘县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4987, 4988, 2434, 33190500),
(2440, '九寨沟县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4989, 4990, 2434, 33190600),
(2441, '金川县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4991, 4992, 2434, 33190700),
(2442, '小金县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4993, 4994, 2434, 33190800),
(2443, '黑水县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4995, 4996, 2434, 33190900),
(2444, '壤塘县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4997, 4998, 2434, 33191000),
(2445, '阿坝县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 4999, 5000, 2434, 33191100),
(2446, '若尔盖县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5001, 5002, 2434, 33191200),
(2447, '红原县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5003, 5004, 2434, 33191300),
(2448, '甘孜藏族自治州', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5006, 5043, 2280, 33200000),
(2449, '康定市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5007, 5008, 2448, 33200100),
(2450, '泸定县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5009, 5010, 2448, 33200200),
(2451, '丹巴县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5011, 5012, 2448, 33200300),
(2452, '九龙县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5013, 5014, 2448, 33200400),
(2453, '雅江县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5015, 5016, 2448, 33200500),
(2454, '道孚县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5017, 5018, 2448, 33200600),
(2455, '炉霍县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5019, 5020, 2448, 33200700),
(2456, '甘孜县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5021, 5022, 2448, 33200800),
(2457, '新龙县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5023, 5024, 2448, 33200900),
(2458, '德格县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5025, 5026, 2448, 33201000),
(2459, '白玉县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5027, 5028, 2448, 33201100),
(2460, '石渠县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5029, 5030, 2448, 33201200),
(2461, '色达县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5031, 5032, 2448, 33201300),
(2462, '理塘县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5033, 5034, 2448, 33201400),
(2463, '巴塘县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5035, 5036, 2448, 33201500),
(2464, '乡城县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5037, 5038, 2448, 33201600),
(2465, '稻城县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5039, 5040, 2448, 33201700),
(2466, '得荣县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5041, 5042, 2448, 33201800),
(2467, '凉山彝族自治州', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5044, 5079, 2280, 33210000),
(2468, '西昌市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5045, 5046, 2467, 33210100),
(2469, '木里藏族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5047, 5048, 2467, 33210200),
(2470, '盐源县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5049, 5050, 2467, 33210300),
(2471, '德昌县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5051, 5052, 2467, 33210400),
(2472, '会理县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5053, 5054, 2467, 33210500),
(2473, '会东县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5055, 5056, 2467, 33210600),
(2474, '宁南县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5057, 5058, 2467, 33210700),
(2475, '普格县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5059, 5060, 2467, 33210800),
(2476, '布拖县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5061, 5062, 2467, 33210900),
(2477, '金阳县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5063, 5064, 2467, 33211000),
(2478, '昭觉县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5065, 5066, 2467, 33211100),
(2479, '喜德县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5067, 5068, 2467, 33211200),
(2480, '冕宁县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5069, 5070, 2467, 33211300),
(2481, '越西县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5071, 5072, 2467, 33211400),
(2482, '甘洛县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5073, 5074, 2467, 33211500),
(2483, '美姑县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5075, 5076, 2467, 33211600),
(2484, '雷波县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5077, 5078, 2467, 33211700),
(2485, '贵州省', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5081, 5276, NULL, 34000000),
(2486, '贵阳市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5082, 5103, 2485, 34010000),
(2487, '南明区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5083, 5084, 2486, 34010100),
(2488, '云岩区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5085, 5086, 2486, 34010200),
(2489, '花溪区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5087, 5088, 2486, 34010300),
(2490, '乌当区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5089, 5090, 2486, 34010400),
(2491, '白云区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5091, 5092, 2486, 34010500),
(2492, '观山湖区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5093, 5094, 2486, 34010600),
(2493, '开阳县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5095, 5096, 2486, 34010700),
(2494, '息烽县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5097, 5098, 2486, 34010800),
(2495, '修文县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5099, 5100, 2486, 34010900),
(2496, '清镇市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5101, 5102, 2486, 34011000),
(2497, '六盘水市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5104, 5113, 2485, 34020000),
(2498, '钟山区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5105, 5106, 2497, 34020100),
(2499, '六枝特区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5107, 5108, 2497, 34020200),
(2500, '水城县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5109, 5110, 2497, 34020300),
(2501, '盘县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5111, 5112, 2497, 34020400),
(2502, '遵义市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5114, 5143, 2485, 34030000),
(2503, '红花岗区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5115, 5116, 2502, 34030100),
(2504, '汇川区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5117, 5118, 2502, 34030200),
(2505, '播州区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5119, 5120, 2502, 34030300),
(2506, '桐梓县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5121, 5122, 2502, 34030400),
(2507, '绥阳县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5123, 5124, 2502, 34030500),
(2508, '正安县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5125, 5126, 2502, 34030600),
(2509, '道真仡佬族苗族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5127, 5128, 2502, 34030700),
(2510, '务川仡佬族苗族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5129, 5130, 2502, 34030800),
(2511, '凤冈县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5131, 5132, 2502, 34030900),
(2512, '湄潭县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5133, 5134, 2502, 34031000),
(2513, '余庆县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5135, 5136, 2502, 34031100),
(2514, '习水县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5137, 5138, 2502, 34031200),
(2515, '赤水市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5139, 5140, 2502, 34031300),
(2516, '仁怀市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5141, 5142, 2502, 34031400),
(2517, '安顺市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5144, 5157, 2485, 34040000),
(2518, '西秀区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5145, 5146, 2517, 34040100),
(2519, '平坝区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5147, 5148, 2517, 34040200),
(2520, '普定县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5149, 5150, 2517, 34040300),
(2521, '镇宁布依族苗族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5151, 5152, 2517, 34040400),
(2522, '关岭布依族苗族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5153, 5154, 2517, 34040500),
(2523, '紫云苗族布依族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5155, 5156, 2517, 34040600),
(2524, '毕节市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5158, 5175, 2485, 34050000),
(2525, '七星关区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5159, 5160, 2524, 34050100),
(2526, '大方县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5161, 5162, 2524, 34050200),
(2527, '黔西县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5163, 5164, 2524, 34050300),
(2528, '金沙县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5165, 5166, 2524, 34050400),
(2529, '织金县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5167, 5168, 2524, 34050500),
(2530, '纳雍县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5169, 5170, 2524, 34050600),
(2531, '威宁彝族回族苗族自治县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5171, 5172, 2524, 34050700),
(2532, '赫章县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5173, 5174, 2524, 34050800),
(2533, '铜仁市', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5176, 5197, 2485, 34060000),
(2534, '碧江区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5177, 5178, 2533, 34060100),
(2535, '万山区', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5179, 5180, 2533, 34060200),
(2536, '江口县', 0, '2018-07-03 09:21:15', '2019-07-06 06:29:40', 5181, 5182, 2533, 34060300),
(2537, '玉屏侗族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5183, 5184, 2533, 34060400),
(2538, '石阡县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5185, 5186, 2533, 34060500),
(2539, '思南县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5187, 5188, 2533, 34060600),
(2540, '印江土家族苗族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5189, 5190, 2533, 34060700),
(2541, '德江县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5191, 5192, 2533, 34060800),
(2542, '沿河土家族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5193, 5194, 2533, 34060900),
(2543, '松桃苗族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5195, 5196, 2533, 34061000),
(2544, '黔西南布依族苗族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5198, 5215, 2485, 34070000),
(2545, '兴义市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5199, 5200, 2544, 34070100),
(2546, '兴仁县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5201, 5202, 2544, 34070200),
(2547, '普安县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5203, 5204, 2544, 34070300),
(2548, '晴隆县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5205, 5206, 2544, 34070400),
(2549, '贞丰县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5207, 5208, 2544, 34070500),
(2550, '望谟县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5209, 5210, 2544, 34070600),
(2551, '册亨县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5211, 5212, 2544, 34070700),
(2552, '安龙县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5213, 5214, 2544, 34070800),
(2553, '黔东南苗族侗族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5216, 5249, 2485, 34080000),
(2554, '凯里市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5217, 5218, 2553, 34080100),
(2555, '黄平县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5219, 5220, 2553, 34080200),
(2556, '施秉县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5221, 5222, 2553, 34080300),
(2557, '三穗县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5223, 5224, 2553, 34080400),
(2558, '镇远县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5225, 5226, 2553, 34080500),
(2559, '岑巩县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5227, 5228, 2553, 34080600),
(2560, '天柱县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5229, 5230, 2553, 34080700),
(2561, '锦屏县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5231, 5232, 2553, 34080800),
(2562, '剑河县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5233, 5234, 2553, 34080900),
(2563, '台江县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5235, 5236, 2553, 34081000),
(2564, '黎平县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5237, 5238, 2553, 34081100),
(2565, '榕江县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5239, 5240, 2553, 34081200),
(2566, '从江县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5241, 5242, 2553, 34081300),
(2567, '雷山县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5243, 5244, 2553, 34081400),
(2568, '麻江县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5245, 5246, 2553, 34081500),
(2569, '丹寨县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5247, 5248, 2553, 34081600),
(2570, '黔南布依族苗族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5250, 5275, 2485, 34090000),
(2571, '都匀市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5251, 5252, 2570, 34090100),
(2572, '福泉市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5253, 5254, 2570, 34090200),
(2573, '荔波县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5255, 5256, 2570, 34090300),
(2574, '贵定县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5257, 5258, 2570, 34090400),
(2575, '瓮安县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5259, 5260, 2570, 34090500),
(2576, '独山县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5261, 5262, 2570, 34090600),
(2577, '平塘县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5263, 5264, 2570, 34090700),
(2578, '罗甸县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5265, 5266, 2570, 34090800),
(2579, '长顺县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5267, 5268, 2570, 34090900),
(2580, '龙里县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5269, 5270, 2570, 34091000),
(2581, '惠水县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5271, 5272, 2570, 34091100),
(2582, '三都水族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5273, 5274, 2570, 34091200),
(2583, '云南省', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5277, 5568, NULL, 35000000),
(2584, '昆明市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5278, 5307, 2583, 35010000),
(2585, '五华区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5279, 5280, 2584, 35010100),
(2586, '盘龙区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5281, 5282, 2584, 35010200),
(2587, '官渡区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5283, 5284, 2584, 35010300),
(2588, '西山区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5285, 5286, 2584, 35010400),
(2589, '东川区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5287, 5288, 2584, 35010500),
(2590, '呈贡区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5289, 5290, 2584, 35010600),
(2591, '晋宁县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:40', 5291, 5292, 2584, 35010700),
(2592, '富民县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5293, 5294, 2584, 35010800),
(2593, '宜良县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5295, 5296, 2584, 35010900),
(2594, '石林彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5297, 5298, 2584, 35011000),
(2595, '嵩明县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5299, 5300, 2584, 35011100),
(2596, '禄劝彝族苗族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5301, 5302, 2584, 35011200),
(2597, '寻甸回族彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5303, 5304, 2584, 35011300),
(2598, '安宁市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5305, 5306, 2584, 35011400),
(2599, '曲靖市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5308, 5327, 2583, 35020000),
(2600, '麒麟区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5309, 5310, 2599, 35020100),
(2601, '沾益区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5311, 5312, 2599, 35020200),
(2602, '马龙县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5313, 5314, 2599, 35020300),
(2603, '陆良县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5315, 5316, 2599, 35020400),
(2604, '师宗县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5317, 5318, 2599, 35020500),
(2605, '罗平县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5319, 5320, 2599, 35020600),
(2606, '富源县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5321, 5322, 2599, 35020700),
(2607, '会泽县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5323, 5324, 2599, 35020800),
(2608, '宣威市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5325, 5326, 2599, 35020900),
(2609, '玉溪市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5328, 5347, 2583, 35030000),
(2610, '红塔区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5329, 5330, 2609, 35030100),
(2611, '江川区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5331, 5332, 2609, 35030200),
(2612, '澄江县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5333, 5334, 2609, 35030300),
(2613, '通海县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5335, 5336, 2609, 35030400),
(2614, '华宁县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5337, 5338, 2609, 35030500),
(2615, '易门县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5339, 5340, 2609, 35030600),
(2616, '峨山彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5341, 5342, 2609, 35030700),
(2617, '新平彝族傣族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5343, 5344, 2609, 35030800),
(2618, '元江哈尼族彝族傣族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5345, 5346, 2609, 35030900),
(2619, '保山市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5348, 5359, 2583, 35040000),
(2620, '隆阳区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5349, 5350, 2619, 35040100),
(2621, '施甸县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5351, 5352, 2619, 35040200),
(2622, '龙陵县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5353, 5354, 2619, 35040300),
(2623, '昌宁县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5355, 5356, 2619, 35040400),
(2624, '腾冲市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5357, 5358, 2619, 35040500),
(2625, '昭通市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5360, 5383, 2583, 35050000),
(2626, '昭阳区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5361, 5362, 2625, 35050100),
(2627, '鲁甸县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5363, 5364, 2625, 35050200),
(2628, '巧家县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5365, 5366, 2625, 35050300),
(2629, '盐津县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5367, 5368, 2625, 35050400),
(2630, '大关县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5369, 5370, 2625, 35050500),
(2631, '永善县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5371, 5372, 2625, 35050600),
(2632, '绥江县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5373, 5374, 2625, 35050700),
(2633, '镇雄县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5375, 5376, 2625, 35050800),
(2634, '彝良县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5377, 5378, 2625, 35050900),
(2635, '威信县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5379, 5380, 2625, 35051000),
(2636, '水富县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5381, 5382, 2625, 35051100),
(2637, '丽江市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5384, 5395, 2583, 35060000),
(2638, '古城区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5385, 5386, 2637, 35060100),
(2639, '玉龙纳西族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5387, 5388, 2637, 35060200),
(2640, '永胜县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5389, 5390, 2637, 35060300),
(2641, '华坪县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5391, 5392, 2637, 35060400),
(2642, '宁蒗彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5393, 5394, 2637, 35060500),
(2643, '普洱市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5396, 5417, 2583, 35070000),
(2644, '思茅区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5397, 5398, 2643, 35070100),
(2645, '宁洱哈尼族彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5399, 5400, 2643, 35070200),
(2646, '墨江哈尼族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5401, 5402, 2643, 35070300),
(2647, '景东彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5403, 5404, 2643, 35070400),
(2648, '景谷傣族彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5405, 5406, 2643, 35070500),
(2649, '镇沅彝族哈尼族拉祜族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5407, 5408, 2643, 35070600),
(2650, '江城哈尼族彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5409, 5410, 2643, 35070700),
(2651, '孟连傣族拉祜族佤族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5411, 5412, 2643, 35070800),
(2652, '澜沧拉祜族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5413, 5414, 2643, 35070900),
(2653, '西盟佤族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5415, 5416, 2643, 35071000),
(2654, '临沧市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5418, 5435, 2583, 35080000),
(2655, '临翔区', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5419, 5420, 2654, 35080100),
(2656, '凤庆县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5421, 5422, 2654, 35080200),
(2657, '云县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5423, 5424, 2654, 35080300),
(2658, '永德县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5425, 5426, 2654, 35080400),
(2659, '镇康县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5427, 5428, 2654, 35080500),
(2660, '双江拉祜族佤族布朗族傣族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5429, 5430, 2654, 35080600),
(2661, '耿马傣族佤族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5431, 5432, 2654, 35080700),
(2662, '沧源佤族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5433, 5434, 2654, 35080800),
(2663, '楚雄彝族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5436, 5457, 2583, 35090000),
(2664, '楚雄市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5437, 5438, 2663, 35090100),
(2665, '双柏县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5439, 5440, 2663, 35090200),
(2666, '牟定县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5441, 5442, 2663, 35090300),
(2667, '南华县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5443, 5444, 2663, 35090400),
(2668, '姚安县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5445, 5446, 2663, 35090500),
(2669, '大姚县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5447, 5448, 2663, 35090600),
(2670, '永仁县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5449, 5450, 2663, 35090700),
(2671, '元谋县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5451, 5452, 2663, 35090800),
(2672, '武定县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5453, 5454, 2663, 35090900),
(2673, '禄丰县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5455, 5456, 2663, 35091000),
(2674, '红河哈尼族彝族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5458, 5485, 2583, 35100000),
(2675, '个旧市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5459, 5460, 2674, 35100100),
(2676, '开远市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5461, 5462, 2674, 35100200),
(2677, '蒙自市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5463, 5464, 2674, 35100300),
(2678, '弥勒市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5465, 5466, 2674, 35100400),
(2679, '屏边苗族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5467, 5468, 2674, 35100500),
(2680, '建水县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5469, 5470, 2674, 35100600),
(2681, '石屏县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5471, 5472, 2674, 35100700),
(2682, '泸西县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5473, 5474, 2674, 35100800),
(2683, '元阳县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5475, 5476, 2674, 35100900),
(2684, '红河县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5477, 5478, 2674, 35101000),
(2685, '金平苗族瑶族傣族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5479, 5480, 2674, 35101100),
(2686, '绿春县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5481, 5482, 2674, 35101200),
(2687, '河口瑶族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5483, 5484, 2674, 35101300),
(2688, '文山壮族苗族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5486, 5503, 2583, 35110000),
(2689, '文山市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5487, 5488, 2688, 35110100),
(2690, '砚山县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5489, 5490, 2688, 35110200),
(2691, '西畴县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5491, 5492, 2688, 35110300),
(2692, '麻栗坡县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5493, 5494, 2688, 35110400),
(2693, '马关县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5495, 5496, 2688, 35110500),
(2694, '丘北县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5497, 5498, 2688, 35110600),
(2695, '广南县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5499, 5500, 2688, 35110700),
(2696, '富宁县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5501, 5502, 2688, 35110800),
(2697, '西双版纳傣族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5504, 5511, 2583, 35120000),
(2698, '景洪市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5505, 5506, 2697, 35120100),
(2699, '勐海县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5507, 5508, 2697, 35120200),
(2700, '勐腊县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5509, 5510, 2697, 35120300),
(2701, '大理白族自治州', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5512, 5537, 2583, 35130000),
(2702, '大理市', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5513, 5514, 2701, 35130100),
(2703, '漾濞彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5515, 5516, 2701, 35130200),
(2704, '祥云县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5517, 5518, 2701, 35130300),
(2705, '宾川县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5519, 5520, 2701, 35130400),
(2706, '弥渡县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5521, 5522, 2701, 35130500),
(2707, '南涧彝族自治县', 0, '2018-07-03 09:21:16', '2019-07-06 06:29:41', 5523, 5524, 2701, 35130600),
(2708, '巍山彝族回族自治县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5525, 5526, 2701, 35130700),
(2709, '永平县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5527, 5528, 2701, 35130800),
(2710, '云龙县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5529, 5530, 2701, 35130900),
(2711, '洱源县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5531, 5532, 2701, 35131000),
(2712, '剑川县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5533, 5534, 2701, 35131100),
(2713, '鹤庆县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5535, 5536, 2701, 35131200),
(2714, '德宏傣族景颇族自治州', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5538, 5549, 2583, 35140000),
(2715, '瑞丽市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5539, 5540, 2714, 35140100),
(2716, '芒市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5541, 5542, 2714, 35140200),
(2717, '梁河县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5543, 5544, 2714, 35140300),
(2718, '盈江县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5545, 5546, 2714, 35140400),
(2719, '陇川县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5547, 5548, 2714, 35140500),
(2720, '怒江傈僳族自治州', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5550, 5559, 2583, 35150000),
(2721, '泸水市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5551, 5552, 2720, 35150100),
(2722, '福贡县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5553, 5554, 2720, 35150200),
(2723, '贡山独龙族怒族自治县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5555, 5556, 2720, 35150300),
(2724, '兰坪白族普米族自治县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5557, 5558, 2720, 35150400),
(2725, '迪庆藏族自治州', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5560, 5567, 2583, 35160000),
(2726, '香格里拉市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5561, 5562, 2725, 35160100),
(2727, '德钦县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5563, 5564, 2725, 35160200),
(2728, '维西傈僳族自治县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5565, 5566, 2725, 35160300),
(2729, '西藏自治区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5569, 5732, NULL, 36000000),
(2730, '拉萨市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5570, 5587, 2729, 36010000),
(2731, '城关区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5571, 5572, 2730, 36010100),
(2732, '堆龙德庆区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5573, 5574, 2730, 36010200),
(2733, '林周县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5575, 5576, 2730, 36010300),
(2734, '当雄县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5577, 5578, 2730, 36010400),
(2735, '尼木县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5579, 5580, 2730, 36010500),
(2736, '曲水县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5581, 5582, 2730, 36010600),
(2737, '达孜县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5583, 5584, 2730, 36010700),
(2738, '墨竹工卡县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5585, 5586, 2730, 36010800),
(2739, '日喀则市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5588, 5625, 2729, 36020000),
(2740, '桑珠孜区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5589, 5590, 2739, 36020100),
(2741, '南木林县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5591, 5592, 2739, 36020200),
(2742, '江孜县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5593, 5594, 2739, 36020300),
(2743, '定日县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5595, 5596, 2739, 36020400),
(2744, '萨迦县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5597, 5598, 2739, 36020500),
(2745, '拉孜县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5599, 5600, 2739, 36020600),
(2746, '昂仁县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5601, 5602, 2739, 36020700),
(2747, '谢通门县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5603, 5604, 2739, 36020800),
(2748, '白朗县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5605, 5606, 2739, 36020900),
(2749, '仁布县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5607, 5608, 2739, 36021000),
(2750, '康马县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5609, 5610, 2739, 36021100),
(2751, '定结县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5611, 5612, 2739, 36021200),
(2752, '仲巴县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5613, 5614, 2739, 36021300),
(2753, '亚东县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5615, 5616, 2739, 36021400),
(2754, '吉隆县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5617, 5618, 2739, 36021500),
(2755, '聂拉木县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5619, 5620, 2739, 36021600),
(2756, '萨嘎县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5621, 5622, 2739, 36021700),
(2757, '岗巴县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5623, 5624, 2739, 36021800),
(2758, '昌都市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5626, 5649, 2729, 36030000),
(2759, '卡若区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5627, 5628, 2758, 36030100),
(2760, '江达县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5629, 5630, 2758, 36030200),
(2761, '贡觉县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5631, 5632, 2758, 36030300),
(2762, '类乌齐县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5633, 5634, 2758, 36030400),
(2763, '丁青县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5635, 5636, 2758, 36030500),
(2764, '察雅县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5637, 5638, 2758, 36030600),
(2765, '八宿县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5639, 5640, 2758, 36030700),
(2766, '左贡县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5641, 5642, 2758, 36030800),
(2767, '芒康县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5643, 5644, 2758, 36030900),
(2768, '洛隆县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5645, 5646, 2758, 36031000),
(2769, '边坝县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5647, 5648, 2758, 36031100),
(2770, '林芝市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5650, 5665, 2729, 36040000),
(2771, '巴宜区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5651, 5652, 2770, 36040100),
(2772, '工布江达县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5653, 5654, 2770, 36040200),
(2773, '米林县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5655, 5656, 2770, 36040300),
(2774, '墨脱县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5657, 5658, 2770, 36040400),
(2775, '波密县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5659, 5660, 2770, 36040500),
(2776, '察隅县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5661, 5662, 2770, 36040600),
(2777, '朗县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5663, 5664, 2770, 36040700),
(2778, '山南市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5666, 5691, 2729, 36050000),
(2779, '乃东区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5667, 5668, 2778, 36050100),
(2780, '扎囊县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5669, 5670, 2778, 36050200),
(2781, '贡嘎县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5671, 5672, 2778, 36050300),
(2782, '桑日县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5673, 5674, 2778, 36050400),
(2783, '琼结县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5675, 5676, 2778, 36050500),
(2784, '曲松县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5677, 5678, 2778, 36050600),
(2785, '措美县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5679, 5680, 2778, 36050700),
(2786, '洛扎县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5681, 5682, 2778, 36050800),
(2787, '加查县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5683, 5684, 2778, 36050900),
(2788, '隆子县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5685, 5686, 2778, 36051000),
(2789, '错那县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5687, 5688, 2778, 36051100),
(2790, '浪卡子县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5689, 5690, 2778, 36051200),
(2791, '那曲地区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5692, 5715, 2729, 36060000),
(2792, '那曲县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5693, 5694, 2791, 36060100),
(2793, '嘉黎县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5695, 5696, 2791, 36060200),
(2794, '比如县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5697, 5698, 2791, 36060300),
(2795, '聂荣县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5699, 5700, 2791, 36060400),
(2796, '安多县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5701, 5702, 2791, 36060500),
(2797, '申扎县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5703, 5704, 2791, 36060600);";

        $sql6 = "INSERT INTO `area` (`id`, `name`, `disabled`, `created_at`, `updated_at`, `_lft`, `_rgt`, `parent_id`, `code`) VALUES
(2798, '索县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5705, 5706, 2791, 36060700),
(2799, '班戈县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5707, 5708, 2791, 36060800),
(2800, '巴青县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5709, 5710, 2791, 36060900),
(2801, '尼玛县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5711, 5712, 2791, 36061000),
(2802, '双湖县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5713, 5714, 2791, 36061100),
(2803, '阿里地区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5716, 5731, 2729, 36070000),
(2804, '普兰县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5717, 5718, 2803, 36070100),
(2805, '札达县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5719, 5720, 2803, 36070200),
(2806, '噶尔县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5721, 5722, 2803, 36070300),
(2807, '日土县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5723, 5724, 2803, 36070400),
(2808, '革吉县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5725, 5726, 2803, 36070500),
(2809, '改则县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5727, 5728, 2803, 36070600),
(2810, '措勤县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5729, 5730, 2803, 36070700),
(2811, '陕西省', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5733, 5968, NULL, 37000000),
(2812, '西安市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5734, 5761, 2811, 37010000),
(2813, '新城区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5735, 5736, 2812, 37010100),
(2814, '碑林区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5737, 5738, 2812, 37010200),
(2815, '莲湖区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5739, 5740, 2812, 37010300),
(2816, '灞桥区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:41', 5741, 5742, 2812, 37010400),
(2817, '未央区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5743, 5744, 2812, 37010500),
(2818, '雁塔区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5745, 5746, 2812, 37010600),
(2819, '阎良区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5747, 5748, 2812, 37010700),
(2820, '临潼区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5749, 5750, 2812, 37010800),
(2821, '长安区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5751, 5752, 2812, 37010900),
(2822, '高陵区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5753, 5754, 2812, 37011000),
(2823, '蓝田县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5755, 5756, 2812, 37011100),
(2824, '周至县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5757, 5758, 2812, 37011200),
(2825, '户县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5759, 5760, 2812, 37011300),
(2826, '铜川市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5762, 5771, 2811, 37020000),
(2827, '王益区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5763, 5764, 2826, 37020100),
(2828, '印台区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5765, 5766, 2826, 37020200),
(2829, '耀州区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5767, 5768, 2826, 37020300),
(2830, '宜君县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5769, 5770, 2826, 37020400),
(2831, '宝鸡市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5772, 5797, 2811, 37030000),
(2832, '渭滨区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5773, 5774, 2831, 37030100),
(2833, '金台区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5775, 5776, 2831, 37030200),
(2834, '陈仓区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5777, 5778, 2831, 37030300),
(2835, '凤翔县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5779, 5780, 2831, 37030400),
(2836, '岐山县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5781, 5782, 2831, 37030500),
(2837, '扶风县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5783, 5784, 2831, 37030600),
(2838, '眉县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5785, 5786, 2831, 37030700),
(2839, '陇县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5787, 5788, 2831, 37030800),
(2840, '千阳县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5789, 5790, 2831, 37030900),
(2841, '麟游县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5791, 5792, 2831, 37031000),
(2842, '凤县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5793, 5794, 2831, 37031100),
(2843, '太白县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5795, 5796, 2831, 37031200),
(2844, '咸阳市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5798, 5827, 2811, 37040000),
(2845, '秦都区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5799, 5800, 2844, 37040100),
(2846, '杨陵区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5801, 5802, 2844, 37040200),
(2847, '渭城区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5803, 5804, 2844, 37040300),
(2848, '三原县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5805, 5806, 2844, 37040400),
(2849, '泾阳县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5807, 5808, 2844, 37040500),
(2850, '乾县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5809, 5810, 2844, 37040600),
(2851, '礼泉县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5811, 5812, 2844, 37040700),
(2852, '永寿县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5813, 5814, 2844, 37040800),
(2853, '彬县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5815, 5816, 2844, 37040900),
(2854, '长武县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5817, 5818, 2844, 37041000),
(2855, '旬邑县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5819, 5820, 2844, 37041100),
(2856, '淳化县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5821, 5822, 2844, 37041200),
(2857, '武功县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5823, 5824, 2844, 37041300),
(2858, '兴平市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5825, 5826, 2844, 37041400),
(2859, '渭南市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5828, 5851, 2811, 37050000),
(2860, '临渭区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5829, 5830, 2859, 37050100),
(2861, '华州区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5831, 5832, 2859, 37050200),
(2862, '潼关县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5833, 5834, 2859, 37050300),
(2863, '大荔县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5835, 5836, 2859, 37050400),
(2864, '合阳县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5837, 5838, 2859, 37050500),
(2865, '澄城县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5839, 5840, 2859, 37050600),
(2866, '蒲城县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5841, 5842, 2859, 37050700),
(2867, '白水县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5843, 5844, 2859, 37050800),
(2868, '富平县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5845, 5846, 2859, 37050900),
(2869, '韩城市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5847, 5848, 2859, 37051000),
(2870, '华阴市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5849, 5850, 2859, 37051100),
(2871, '延安市', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5852, 5879, 2811, 37060000),
(2872, '宝塔区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5853, 5854, 2871, 37060100),
(2873, '安塞区', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5855, 5856, 2871, 37060200),
(2874, '延长县', 0, '2018-07-03 09:21:17', '2019-07-06 06:29:42', 5857, 5858, 2871, 37060300),
(2875, '延川县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5859, 5860, 2871, 37060400),
(2876, '子长县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5861, 5862, 2871, 37060500),
(2877, '志丹县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5863, 5864, 2871, 37060600),
(2878, '吴起县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5865, 5866, 2871, 37060700),
(2879, '甘泉县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5867, 5868, 2871, 37060800),
(2880, '富县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5869, 5870, 2871, 37060900),
(2881, '洛川县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5871, 5872, 2871, 37061000),
(2882, '宜川县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5873, 5874, 2871, 37061100),
(2883, '黄龙县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5875, 5876, 2871, 37061200),
(2884, '黄陵县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5877, 5878, 2871, 37061300),
(2885, '汉中市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5880, 5903, 2811, 37070000),
(2886, '汉台区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5881, 5882, 2885, 37070100),
(2887, '南郑县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5883, 5884, 2885, 37070200),
(2888, '城固县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5885, 5886, 2885, 37070300),
(2889, '洋县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5887, 5888, 2885, 37070400),
(2890, '西乡县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5889, 5890, 2885, 37070500),
(2891, '勉县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5891, 5892, 2885, 37070600),
(2892, '宁强县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5893, 5894, 2885, 37070700),
(2893, '略阳县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5895, 5896, 2885, 37070800),
(2894, '镇巴县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5897, 5898, 2885, 37070900),
(2895, '留坝县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5899, 5900, 2885, 37071000),
(2896, '佛坪县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5901, 5902, 2885, 37071100),
(2897, '榆林市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5904, 5929, 2811, 37080000),
(2898, '榆阳区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5905, 5906, 2897, 37080100),
(2899, '横山区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5907, 5908, 2897, 37080200),
(2900, '神木县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5909, 5910, 2897, 37080300),
(2901, '府谷县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5911, 5912, 2897, 37080400),
(2902, '靖边县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5913, 5914, 2897, 37080500),
(2903, '定边县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5915, 5916, 2897, 37080600),
(2904, '绥德县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5917, 5918, 2897, 37080700),
(2905, '米脂县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5919, 5920, 2897, 37080800),
(2906, '佳县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5921, 5922, 2897, 37080900),
(2907, '吴堡县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5923, 5924, 2897, 37081000),
(2908, '清涧县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5925, 5926, 2897, 37081100),
(2909, '子洲县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5927, 5928, 2897, 37081200),
(2910, '安康市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5930, 5951, 2811, 37090000),
(2911, '汉滨区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5931, 5932, 2910, 37090100),
(2912, '汉阴县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5933, 5934, 2910, 37090200),
(2913, '石泉县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5935, 5936, 2910, 37090300),
(2914, '宁陕县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5937, 5938, 2910, 37090400),
(2915, '紫阳县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5939, 5940, 2910, 37090500),
(2916, '岚皋县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5941, 5942, 2910, 37090600),
(2917, '平利县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5943, 5944, 2910, 37090700),
(2918, '镇坪县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5945, 5946, 2910, 37090800),
(2919, '旬阳县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5947, 5948, 2910, 37090900),
(2920, '白河县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5949, 5950, 2910, 37091000),
(2921, '商洛市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5952, 5967, 2811, 37100000),
(2922, '商州区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5953, 5954, 2921, 37100100),
(2923, '洛南县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5955, 5956, 2921, 37100200),
(2924, '丹凤县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5957, 5958, 2921, 37100300),
(2925, '商南县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5959, 5960, 2921, 37100400),
(2926, '山阳县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5961, 5962, 2921, 37100500),
(2927, '镇安县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5963, 5964, 2921, 37100600),
(2928, '柞水县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5965, 5966, 2921, 37100700),
(2929, '甘肃省', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5969, 6172, NULL, 38000000),
(2930, '兰州市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5970, 5987, 2929, 38010000),
(2931, '城关区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5971, 5972, 2930, 38010100),
(2932, '七里河区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5973, 5974, 2930, 38010200),
(2933, '西固区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5975, 5976, 2930, 38010300),
(2934, '安宁区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5977, 5978, 2930, 38010400),
(2935, '红古区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5979, 5980, 2930, 38010500),
(2936, '永登县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5981, 5982, 2930, 38010600),
(2937, '皋兰县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5983, 5984, 2930, 38010700),
(2938, '榆中县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5985, 5986, 2930, 38010800),
(2939, '嘉峪关市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5988, 5991, 2929, 38020000),
(2940, '市辖区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5989, 5990, 2939, 38020100),
(2941, '金昌市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5992, 5997, 2929, 38030000),
(2942, '金川区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5993, 5994, 2941, 38030100),
(2943, '永昌县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5995, 5996, 2941, 38030200),
(2944, '白银市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5998, 6009, 2929, 38040000),
(2945, '白银区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 5999, 6000, 2944, 38040100),
(2946, '平川区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6001, 6002, 2944, 38040200),
(2947, '靖远县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6003, 6004, 2944, 38040300),
(2948, '会宁县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6005, 6006, 2944, 38040400),
(2949, '景泰县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6007, 6008, 2944, 38040500),
(2950, '天水市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6010, 6025, 2929, 38050000),
(2951, '秦州区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6011, 6012, 2950, 38050100),
(2952, '麦积区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6013, 6014, 2950, 38050200),
(2953, '清水县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6015, 6016, 2950, 38050300),
(2954, '秦安县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6017, 6018, 2950, 38050400),
(2955, '甘谷县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6019, 6020, 2950, 38050500),
(2956, '武山县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6021, 6022, 2950, 38050600),
(2957, '张家川回族自治县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6023, 6024, 2950, 38050700),
(2958, '武威市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6026, 6035, 2929, 38060000),
(2959, '凉州区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6027, 6028, 2958, 38060100),
(2960, '民勤县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6029, 6030, 2958, 38060200),
(2961, '古浪县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6031, 6032, 2958, 38060300),
(2962, '天祝藏族自治县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6033, 6034, 2958, 38060400),
(2963, '张掖市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6036, 6049, 2929, 38070000),
(2964, '甘州区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6037, 6038, 2963, 38070100),
(2965, '肃南裕固族自治县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6039, 6040, 2963, 38070200),
(2966, '民乐县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6041, 6042, 2963, 38070300),
(2967, '临泽县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6043, 6044, 2963, 38070400),
(2968, '高台县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6045, 6046, 2963, 38070500),
(2969, '山丹县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6047, 6048, 2963, 38070600),
(2970, '平凉市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6050, 6065, 2929, 38080000),
(2971, '崆峒区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6051, 6052, 2970, 38080100),
(2972, '泾川县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6053, 6054, 2970, 38080200),
(2973, '灵台县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6055, 6056, 2970, 38080300),
(2974, '崇信县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6057, 6058, 2970, 38080400),
(2975, '华亭县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6059, 6060, 2970, 38080500),
(2976, '庄浪县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6061, 6062, 2970, 38080600),
(2977, '静宁县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6063, 6064, 2970, 38080700),
(2978, '酒泉市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6066, 6081, 2929, 38090000),
(2979, '肃州区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6067, 6068, 2978, 38090100),
(2980, '金塔县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6069, 6070, 2978, 38090200),
(2981, '瓜州县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6071, 6072, 2978, 38090300),
(2982, '肃北蒙古族自治县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6073, 6074, 2978, 38090400),
(2983, '阿克塞哈萨克族自治县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6075, 6076, 2978, 38090500),
(2984, '玉门市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6077, 6078, 2978, 38090600),
(2985, '敦煌市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6079, 6080, 2978, 38090700),
(2986, '庆阳市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6082, 6099, 2929, 38100000),
(2987, '西峰区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6083, 6084, 2986, 38100100),
(2988, '庆城县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6085, 6086, 2986, 38100200),
(2989, '环县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6087, 6088, 2986, 38100300),
(2990, '华池县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6089, 6090, 2986, 38100400),
(2991, '合水县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6091, 6092, 2986, 38100500),
(2992, '正宁县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6093, 6094, 2986, 38100600),
(2993, '宁县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6095, 6096, 2986, 38100700),
(2994, '镇原县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6097, 6098, 2986, 38100800),
(2995, '定西市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6100, 6115, 2929, 38110000),
(2996, '安定区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6101, 6102, 2995, 38110100),
(2997, '通渭县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6103, 6104, 2995, 38110200),
(2998, '陇西县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6105, 6106, 2995, 38110300),
(2999, '渭源县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6107, 6108, 2995, 38110400),
(3000, '临洮县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6109, 6110, 2995, 38110500),
(3001, '漳县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6111, 6112, 2995, 38110600),
(3002, '岷县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6113, 6114, 2995, 38110700),
(3003, '陇南市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6116, 6135, 2929, 38120000),
(3004, '武都区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6117, 6118, 3003, 38120100),
(3005, '成县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6119, 6120, 3003, 38120200),
(3006, '文县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6121, 6122, 3003, 38120300),
(3007, '宕昌县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6123, 6124, 3003, 38120400),
(3008, '康县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6125, 6126, 3003, 38120500),
(3009, '西和县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6127, 6128, 3003, 38120600),
(3010, '礼县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6129, 6130, 3003, 38120700),
(3011, '徽县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6131, 6132, 3003, 38120800),
(3012, '两当县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6133, 6134, 3003, 38120900),
(3013, '临夏回族自治州', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6136, 6153, 2929, 38130000),
(3014, '临夏市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6137, 6138, 3013, 38130100),
(3015, '临夏县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6139, 6140, 3013, 38130200),
(3016, '康乐县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6141, 6142, 3013, 38130300),
(3017, '永靖县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6143, 6144, 3013, 38130400),
(3018, '广河县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6145, 6146, 3013, 38130500),
(3019, '和政县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6147, 6148, 3013, 38130600),
(3020, '东乡族自治县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6149, 6150, 3013, 38130700),
(3021, '积石山保安族东乡族撒拉族自治县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6151, 6152, 3013, 38130800),
(3022, '甘南藏族自治州', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6154, 6171, 2929, 38140000),
(3023, '合作市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6155, 6156, 3022, 38140100),
(3024, '临潭县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6157, 6158, 3022, 38140200),
(3025, '卓尼县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6159, 6160, 3022, 38140300),
(3026, '舟曲县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6161, 6162, 3022, 38140400),
(3027, '迭部县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6163, 6164, 3022, 38140500),
(3028, '玛曲县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6165, 6166, 3022, 38140600),
(3029, '碌曲县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6167, 6168, 3022, 38140700),
(3030, '夏河县', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6169, 6170, 3022, 38140800),
(3031, '青海省', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6173, 6276, NULL, 39000000),
(3032, '西宁市', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6174, 6189, 3031, 39010000),
(3033, '城东区', 0, '2018-07-03 09:21:18', '2019-07-06 06:29:42', 6175, 6176, 3032, 39010100),
(3034, '城中区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:42', 6177, 6178, 3032, 39010200),
(3035, '城西区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:42', 6179, 6180, 3032, 39010300),
(3036, '城北区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:42', 6181, 6182, 3032, 39010400),
(3037, '大通回族土族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:42', 6183, 6184, 3032, 39010500),
(3038, '湟中县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:42', 6185, 6186, 3032, 39010600),
(3039, '湟源县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:42', 6187, 6188, 3032, 39010700),
(3040, '海东市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6190, 6203, 3031, 39020000),
(3041, '乐都区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6191, 6192, 3040, 39020100),
(3042, '平安区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6193, 6194, 3040, 39020200),
(3043, '民和回族土族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6195, 6196, 3040, 39020300),
(3044, '互助土族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6197, 6198, 3040, 39020400),
(3045, '化隆回族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6199, 6200, 3040, 39020500),
(3046, '循化撒拉族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6201, 6202, 3040, 39020600),
(3047, '海北藏族自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6204, 6213, 3031, 39030000),
(3048, '门源回族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6205, 6206, 3047, 39030100),
(3049, '祁连县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6207, 6208, 3047, 39030200),
(3050, '海晏县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6209, 6210, 3047, 39030300),
(3051, '刚察县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6211, 6212, 3047, 39030400),
(3052, '黄南藏族自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6214, 6223, 3031, 39040000),
(3053, '同仁县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6215, 6216, 3052, 39040100),
(3054, '尖扎县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6217, 6218, 3052, 39040200),
(3055, '泽库县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6219, 6220, 3052, 39040300),
(3056, '河南蒙古族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6221, 6222, 3052, 39040400),
(3057, '海南藏族自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6224, 6235, 3031, 39050000),
(3058, '共和县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6225, 6226, 3057, 39050100),
(3059, '同德县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6227, 6228, 3057, 39050200),
(3060, '贵德县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6229, 6230, 3057, 39050300),
(3061, '兴海县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6231, 6232, 3057, 39050400),
(3062, '贵南县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6233, 6234, 3057, 39050500),
(3063, '果洛藏族自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6236, 6249, 3031, 39060000),
(3064, '玛沁县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6237, 6238, 3063, 39060100),
(3065, '班玛县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6239, 6240, 3063, 39060200),
(3066, '甘德县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6241, 6242, 3063, 39060300),
(3067, '达日县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6243, 6244, 3063, 39060400),
(3068, '久治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6245, 6246, 3063, 39060500),
(3069, '玛多县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6247, 6248, 3063, 39060600),
(3070, '玉树藏族自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6250, 6263, 3031, 39070000),
(3071, '玉树市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6251, 6252, 3070, 39070100),
(3072, '杂多县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6253, 6254, 3070, 39070200),
(3073, '称多县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6255, 6256, 3070, 39070300),
(3074, '治多县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6257, 6258, 3070, 39070400),
(3075, '囊谦县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6259, 6260, 3070, 39070500),
(3076, '曲麻莱县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6261, 6262, 3070, 39070600),
(3077, '海西蒙古族藏族自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6264, 6275, 3031, 39080000),
(3078, '格尔木市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6265, 6266, 3077, 39080100),
(3079, '德令哈市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6267, 6268, 3077, 39080200),
(3080, '乌兰县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6269, 6270, 3077, 39080300),
(3081, '都兰县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6271, 6272, 3077, 39080400),
(3082, '天峻县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6273, 6274, 3077, 39080500),
(3083, '宁夏回族自治区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6277, 6332, NULL, 40000000),
(3084, '银川市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6278, 6291, 3083, 40010000),
(3085, '兴庆区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6279, 6280, 3084, 40010100),
(3086, '西夏区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6281, 6282, 3084, 40010200),
(3087, '金凤区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6283, 6284, 3084, 40010300),
(3088, '永宁县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6285, 6286, 3084, 40010400),
(3089, '贺兰县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6287, 6288, 3084, 40010500),
(3090, '灵武市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6289, 6290, 3084, 40010600),
(3091, '石嘴山市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6292, 6299, 3083, 40020000),
(3092, '大武口区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6293, 6294, 3091, 40020100),
(3093, '惠农区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6295, 6296, 3091, 40020200),
(3094, '平罗县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6297, 6298, 3091, 40020300),
(3095, '吴忠市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6300, 6311, 3083, 40030000),
(3096, '利通区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6301, 6302, 3095, 40030100),
(3097, '红寺堡区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6303, 6304, 3095, 40030200),
(3098, '盐池县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6305, 6306, 3095, 40030300),
(3099, '同心县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6307, 6308, 3095, 40030400),
(3100, '青铜峡市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6309, 6310, 3095, 40030500),
(3101, '固原市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6312, 6323, 3083, 40040000),
(3102, '原州区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6313, 6314, 3101, 40040100),
(3103, '西吉县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6315, 6316, 3101, 40040200),
(3104, '隆德县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6317, 6318, 3101, 40040300),
(3105, '泾源县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6319, 6320, 3101, 40040400),
(3106, '彭阳县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6321, 6322, 3101, 40040500),
(3107, '中卫市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6324, 6331, 3083, 40050000),
(3108, '沙坡头区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6325, 6326, 3107, 40050100),
(3109, '中宁县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6327, 6328, 3107, 40050200),
(3110, '海原县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6329, 6330, 3107, 40050300),
(3111, '新疆维吾尔自治区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6333, 6566, NULL, 41000000),
(3112, '乌鲁木齐市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6334, 6351, 3111, 41010000),
(3113, '天山区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6335, 6336, 3112, 41010100),
(3114, '沙依巴克区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6337, 6338, 3112, 41010200),
(3115, '新市区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6339, 6340, 3112, 41010300),
(3116, '水磨沟区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6341, 6342, 3112, 41010400),
(3117, '头屯河区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6343, 6344, 3112, 41010500),
(3118, '达坂城区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6345, 6346, 3112, 41010600),
(3119, '米东区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6347, 6348, 3112, 41010700),
(3120, '乌鲁木齐县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6349, 6350, 3112, 41010800),
(3121, '克拉玛依市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6352, 6361, 3111, 41020000),
(3122, '独山子区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6353, 6354, 3121, 41020100),
(3123, '克拉玛依区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6355, 6356, 3121, 41020200),
(3124, '白碱滩区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6357, 6358, 3121, 41020300),
(3125, '乌尔禾区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6359, 6360, 3121, 41020400),
(3126, '吐鲁番市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6362, 6369, 3111, 41030000),
(3127, '高昌区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6363, 6364, 3126, 41030100),
(3128, '鄯善县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6365, 6366, 3126, 41030200),
(3129, '托克逊县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6367, 6368, 3126, 41030300),
(3130, '哈密市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6370, 6377, 3111, 41040000),
(3131, '伊州区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6371, 6372, 3130, 41040100),
(3132, '巴里坤哈萨克自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6373, 6374, 3130, 41040200),
(3133, '伊吾县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6375, 6376, 3130, 41040300),
(3134, '昌吉回族自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6378, 6393, 3111, 41050000),
(3135, '昌吉市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6379, 6380, 3134, 41050100),
(3136, '阜康市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6381, 6382, 3134, 41050200),
(3137, '呼图壁县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6383, 6384, 3134, 41050300),
(3138, '玛纳斯县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6385, 6386, 3134, 41050400),
(3139, '奇台县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6387, 6388, 3134, 41050500),
(3140, '吉木萨尔县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6389, 6390, 3134, 41050600),
(3141, '木垒哈萨克自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6391, 6392, 3134, 41050700),
(3142, '博尔塔拉蒙古自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6394, 6403, 3111, 41060000),
(3143, '博乐市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6395, 6396, 3142, 41060100),
(3144, '阿拉山口市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6397, 6398, 3142, 41060200),
(3145, '精河县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6399, 6400, 3142, 41060300),
(3146, '温泉县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6401, 6402, 3142, 41060400),
(3147, '巴音郭楞蒙古自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6404, 6423, 3111, 41070000),
(3148, '库尔勒市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6405, 6406, 3147, 41070100),
(3149, '轮台县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6407, 6408, 3147, 41070200),
(3150, '尉犁县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6409, 6410, 3147, 41070300),
(3151, '若羌县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6411, 6412, 3147, 41070400),
(3152, '且末县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6413, 6414, 3147, 41070500),
(3153, '焉耆回族自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6415, 6416, 3147, 41070600),
(3154, '和静县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6417, 6418, 3147, 41070700),
(3155, '和硕县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6419, 6420, 3147, 41070800),
(3156, '博湖县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6421, 6422, 3147, 41070900),
(3157, '阿克苏地区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6424, 6443, 3111, 41080000),
(3158, '阿克苏市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6425, 6426, 3157, 41080100),
(3159, '温宿县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6427, 6428, 3157, 41080200),
(3160, '库车县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6429, 6430, 3157, 41080300),
(3161, '沙雅县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6431, 6432, 3157, 41080400),
(3162, '新和县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6433, 6434, 3157, 41080500),
(3163, '拜城县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6435, 6436, 3157, 41080600),
(3164, '乌什县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6437, 6438, 3157, 41080700),
(3165, '阿瓦提县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6439, 6440, 3157, 41080800),
(3166, '柯坪县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6441, 6442, 3157, 41080900),
(3167, '克孜勒苏柯尔克孜自治州', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6444, 6453, 3111, 41090000),
(3168, '阿图什市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6445, 6446, 3167, 41090100),
(3169, '阿克陶县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6447, 6448, 3167, 41090200),
(3170, '阿合奇县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6449, 6450, 3167, 41090300),
(3171, '乌恰县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6451, 6452, 3167, 41090400),
(3172, '喀什地区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6454, 6479, 3111, 41100000),
(3173, '喀什市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6455, 6456, 3172, 41100100),
(3174, '疏附县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6457, 6458, 3172, 41100200),
(3175, '疏勒县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6459, 6460, 3172, 41100300),
(3176, '英吉沙县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6461, 6462, 3172, 41100400),
(3177, '泽普县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6463, 6464, 3172, 41100500),
(3178, '莎车县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6465, 6466, 3172, 41100600),
(3179, '叶城县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6467, 6468, 3172, 41100700),
(3180, '麦盖提县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6469, 6470, 3172, 41100800),
(3181, '岳普湖县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6471, 6472, 3172, 41100900),
(3182, '伽师县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6473, 6474, 3172, 41101000),
(3183, '巴楚县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6475, 6476, 3172, 41101100),
(3184, '塔什库尔干塔吉克自治县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6477, 6478, 3172, 41101200),
(3185, '和田地区', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6480, 6497, 3111, 41110000),
(3186, '和田市', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6481, 6482, 3185, 41110100),
(3187, '和田县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6483, 6484, 3185, 41110200),
(3188, '墨玉县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6485, 6486, 3185, 41110300),
(3189, '皮山县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6487, 6488, 3185, 41110400),
(3190, '洛浦县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6489, 6490, 3185, 41110500),
(3191, '策勒县', 0, '2018-07-03 09:21:19', '2019-07-06 06:29:43', 6491, 6492, 3185, 41110600),
(3192, '于田县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6493, 6494, 3185, 41110700),
(3193, '民丰县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6495, 6496, 3185, 41110800),
(3194, '伊犁哈萨克自治州', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6498, 6521, 3111, 41120000),
(3195, '伊宁市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6499, 6500, 3194, 41120100),
(3196, '奎屯市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6501, 6502, 3194, 41120200),
(3197, '霍尔果斯市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6503, 6504, 3194, 41120300),
(3198, '伊宁县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6505, 6506, 3194, 41120400),
(3199, '察布查尔锡伯自治县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6507, 6508, 3194, 41120500),
(3200, '霍城县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6509, 6510, 3194, 41120600),
(3201, '巩留县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6511, 6512, 3194, 41120700),
(3202, '新源县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6513, 6514, 3194, 41120800),
(3203, '昭苏县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6515, 6516, 3194, 41120900),
(3204, '特克斯县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6517, 6518, 3194, 41121000),
(3205, '尼勒克县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6519, 6520, 3194, 41121100),
(3206, '塔城地区', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6522, 6537, 3111, 41130000),
(3207, '塔城市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6523, 6524, 3206, 41130100),
(3208, '乌苏市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6525, 6526, 3206, 41130200),
(3209, '额敏县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6527, 6528, 3206, 41130300),
(3210, '沙湾县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6529, 6530, 3206, 41130400),
(3211, '托里县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6531, 6532, 3206, 41130500),
(3212, '裕民县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6533, 6534, 3206, 41130600),
(3213, '和布克赛尔蒙古自治县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6535, 6536, 3206, 41130700),
(3214, '阿勒泰地区', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6538, 6553, 3111, 41140000),
(3215, '阿勒泰市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6539, 6540, 3214, 41140100),
(3216, '布尔津县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6541, 6542, 3214, 41140200),
(3217, '富蕴县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6543, 6544, 3214, 41140300),
(3218, '福海县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6545, 6546, 3214, 41140400),
(3219, '哈巴河县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6547, 6548, 3214, 41140500),
(3220, '青河县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6549, 6550, 3214, 41140600),
(3221, '吉木乃县', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6551, 6552, 3214, 41140700),
(3222, '自治区直辖县级行政区划', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6554, 6565, 3111, 41150000),
(3223, '石河子市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6555, 6556, 3222, 41150100),
(3224, '阿拉尔市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6557, 6558, 3222, 41150200),
(3225, '图木舒克市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6559, 6560, 3222, 41150300),
(3226, '五家渠市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6561, 6562, 3222, 41150400),
(3227, '铁门关市', 0, '2018-07-03 09:21:20', '2019-07-06 06:29:43', 6563, 6564, 3222, 41150500),
(3228, '东城街道', 0, '2020-05-19 01:33:03', '2020-05-19 01:33:03', 4131, 4132, 2062, 29170100),
(3229, '南城街道', 0, '2020-05-19 01:33:07', '2020-05-19 01:33:07', 4133, 4134, 2062, 29170200),
(3230, '万江街道', 0, '2020-05-19 01:33:12', '2020-05-19 01:33:12', 4135, 4136, 2062, 29170300),
(3231, '莞城街道', 0, '2020-05-19 01:33:17', '2020-05-19 01:33:17', 4137, 4138, 2062, 29170400),
(3232, '石碣镇', 0, '2020-05-19 01:33:20', '2020-05-19 01:33:20', 4139, 4140, 2062, 29170500),
(3233, '石龙镇', 0, '2020-05-19 01:33:24', '2020-05-19 01:33:24', 4141, 4142, 2062, 29170600),
(3234, '茶山镇', 0, '2020-05-19 01:33:28', '2020-05-19 01:33:28', 4143, 4144, 2062, 29170700),
(3235, '石排镇', 0, '2020-05-19 01:33:31', '2020-05-19 01:33:31', 4145, 4146, 2062, 29170800),
(3236, '企石镇', 0, '2020-05-19 01:33:35', '2020-05-19 01:33:35', 4147, 4148, 2062, 29170900),
(3237, '横沥镇', 0, '2020-05-19 01:33:38', '2020-05-19 01:33:38', 4149, 4150, 2062, 29171000),
(3238, '桥头镇', 0, '2020-05-19 01:33:42', '2020-05-19 01:33:42', 4151, 4152, 2062, 29171100),
(3239, '谢岗镇', 0, '2020-05-19 01:33:45', '2020-05-19 01:33:45', 4153, 4154, 2062, 29171200),
(3240, '东坑镇', 0, '2020-05-19 01:33:48', '2020-05-19 01:33:48', 4155, 4156, 2062, 29171300),
(3241, '常平镇', 0, '2020-05-19 01:33:52', '2020-05-19 01:33:52', 4157, 4158, 2062, 29171400),
(3242, '寮步镇', 0, '2020-05-19 01:33:56', '2020-05-19 01:33:56', 4159, 4160, 2062, 29171500),
(3243, '樟木头镇', 0, '2020-05-19 01:33:59', '2020-05-19 01:33:59', 4161, 4162, 2062, 29171600),
(3244, '大朗镇', 0, '2020-05-19 01:34:03', '2020-05-19 01:34:03', 4163, 4164, 2062, 29171700),
(3245, '黄江镇', 0, '2020-05-19 01:34:07', '2020-05-19 01:34:07', 4165, 4166, 2062, 29171800),
(3246, '清溪镇', 0, '2020-05-19 01:34:10', '2020-05-19 01:34:10', 4167, 4168, 2062, 29171900),
(3247, '塘厦镇', 0, '2020-05-19 01:34:13', '2020-05-19 01:34:13', 4169, 4170, 2062, 29172000),
(3250, '长安镇', 0, '2020-05-19 01:34:23', '2020-05-19 01:34:23', 4171, 4172, 2062, 29172300),
(3251, '虎门镇', 0, '2020-05-19 01:34:27', '2020-05-19 01:34:27', 4173, 4174, 2062, 29172400),
(3253, '沙田镇', 0, '2020-05-19 01:34:35', '2020-05-19 01:34:35', 4175, 4176, 2062, 29172600),
(3254, '道滘镇', 0, '2020-05-19 01:34:39', '2020-05-19 01:34:39', 4177, 4178, 2062, 29172700),
(3256, '麻涌镇', 0, '2020-05-19 01:34:46', '2020-05-19 01:34:46', 4179, 4180, 2062, 29172900),
(3257, '望牛墩镇', 0, '2020-05-19 01:34:49', '2020-05-19 01:34:49', 4181, 4182, 2062, 29173000),
(3258, '中堂镇', 0, '2020-05-19 01:34:53', '2020-05-19 01:34:53', 4183, 4184, 2062, 29173100),
(3259, '高埗镇', 0, '2020-05-19 01:34:57', '2020-05-19 01:34:57', 4185, 4186, 2062, 29173200),
(3260, '石岐区街道', 0, '2020-05-19 01:35:31', '2020-05-19 01:35:48', 4189, 4190, 2063, 29180100),
(3261, '东区街道', 0, '2020-05-19 01:36:11', '2020-05-19 01:36:11', 4191, 4192, 2063, 29180200),
(3262, '火炬开发区街道', 0, '2020-05-19 01:36:16', '2020-05-19 01:36:16', 4193, 4194, 2063, 29180300),
(3263, '西区街道', 0, '2020-05-19 01:36:20', '2020-05-19 01:36:20', 4195, 4196, 2063, 29180400),
(3264, '南区街道', 0, '2020-05-19 01:36:24', '2020-05-19 01:36:24', 4197, 4198, 2063, 29180500),
(3265, '五桂山街道', 0, '2020-05-19 01:36:28', '2020-05-19 01:36:28', 4199, 4200, 2063, 29180600),
(3266, '小榄镇', 0, '2020-05-19 01:36:32', '2020-05-19 01:36:32', 4201, 4202, 2063, 29180700),
(3267, '黄圃镇', 0, '2020-05-19 01:36:36', '2020-05-19 01:36:36', 4203, 4204, 2063, 29180800),
(3268, '民众镇', 0, '2020-05-19 01:36:39', '2020-05-19 01:36:39', 4205, 4206, 2063, 29180900),
(3269, '东凤镇', 0, '2020-05-19 01:36:43', '2020-05-19 01:36:43', 4207, 4208, 2063, 29181000),
(3270, '东升镇', 0, '2020-05-19 01:36:48', '2020-05-19 01:36:48', 4209, 4210, 2063, 29181100),
(3271, '古镇镇', 0, '2020-05-19 01:36:53', '2020-05-19 01:36:53', 4211, 4212, 2063, 29181200),
(3272, '沙溪镇', 0, '2020-05-19 01:36:57', '2020-05-19 01:36:57', 4213, 4214, 2063, 29181300),
(3273, '坦洲镇', 0, '2020-05-19 01:37:01', '2020-05-19 01:37:01', 4215, 4216, 2063, 29181400),
(3274, '港口镇', 0, '2020-05-19 01:37:05', '2020-05-19 01:37:05', 4217, 4218, 2063, 29181500),
(3275, '三角镇', 0, '2020-05-19 01:37:09', '2020-05-19 01:37:09', 4219, 4220, 2063, 29181600),
(3276, '横栏镇', 0, '2020-05-19 01:37:13', '2020-05-19 01:37:13', 4221, 4222, 2063, 29181700),
(3277, '南头镇', 0, '2020-05-19 01:37:16', '2020-05-19 01:37:16', 4223, 4224, 2063, 29181800),
(3278, '阜沙镇', 0, '2020-05-19 01:37:22', '2020-05-19 01:37:22', 4225, 4226, 2063, 29181900),
(3279, '南朗镇', 0, '2020-05-19 01:37:25', '2020-05-19 01:37:25', 4227, 4228, 2063, 29182000),
(3280, '三乡镇', 0, '2020-05-19 01:37:29', '2020-05-19 01:37:29', 4229, 4230, 2063, 29182100),
(3281, '板芙镇', 0, '2020-05-19 01:37:32', '2020-05-19 01:37:32', 4231, 4232, 2063, 29182200),
(3282, '大涌镇', 0, '2020-05-19 01:37:36', '2020-05-19 01:37:36', 4233, 4234, 2063, 29182300),
(3283, '神湾镇', 0, '2020-05-19 01:37:39', '2020-05-19 01:37:39', 4235, 4236, 2063, 29182400),
(3284, '龙华区', 0, '2021-07-14 02:41:43', '2021-07-14 02:41:43', 3937, 3938, 1963, 29030700),
(3285, '光明区', 0, '2021-07-14 02:41:54', '2021-07-14 02:41:54', 3939, 3940, 1963, 29030800),
(3286, '坪山区', 0, '2022-06-13 08:52:42', '2022-06-13 08:52:42', 3941, 3942, 1963, 29030900),
(3287, '大鹏新区', 0, '2022-06-13 08:53:16', '2022-06-13 08:53:16', 3943, 3944, 1963, 29031000);";

        \Illuminate\Support\Facades\DB::statement($sql1);
        \Illuminate\Support\Facades\DB::statement($sql2);
        \Illuminate\Support\Facades\DB::statement($sql3);
        \Illuminate\Support\Facades\DB::statement($sql4);
        \Illuminate\Support\Facades\DB::statement($sql5);
        \Illuminate\Support\Facades\DB::statement($sql6);

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('area');
    }
};
