<?php

namespace Modules\Admin\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Dingo\Api\Facade\Route;
use Modules\Admin\Http\Utils\Helper;

class Permission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $user = auth()->user();
        #角色
        $role = $user->roles()->first();
        $role_apis = array_filter(array_column(Helper::getRoleApi($role),'api'));
        $apis = array_filter(array_column(Helper::getAllApi(),'api'));

        $route = str_replace(".", "/", Route::currentRouteName());

        #验证菜单权限
        if(
            !Helper::isAdministrator($role->id)
            && in_array($route,$apis)
            && !in_array($route,$role_apis)
        ){
            abort(403,'没有权限');
        }

        return $next($request);
    }
}
