<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/21
 * @copyright
 */

namespace Modules\Admin\Entities;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Auth;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class AdminUser extends Authenticatable implements JWTSubject
{
    protected $fillable = [
        'username','password', 'name', 'avatar', 'salt'
    ];

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public  function apiLoginAndGetTokenInfo()
    {
        $auth = auth('api');
        return [
            'access_token' => $auth->login($this),
            'token_type' => 'Bearer',
            'expires_in' => $auth->factory()->getTTL() * 60,
        ];
    }

    public  function apiRefreshTokenTokenInfo()
    {
        $auth = auth('api');
        return [
            'access_token' => $auth->refresh(true,true),
            'token_type' => 'Bearer',
            'expires_in' => $auth->factory()->getTTL() * 60,
        ];
    }

    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(AdminRole::class,'admin_role_users','user_id','role_id');
    }
}