<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/21
 * @copyright
 */

namespace Modules\Admin\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Modules\Admin\Http\Utils\Helper;

class AdminRole extends Model
{
    protected $fillable = [
        'name','slug',
    ];
    public static function boot()
    {
        parent::boot();
    }
    public function menu(): BelongsToMany
    {
        return $this->belongsToMany(AdminMenu::class,'admin_role_menus','role_id','menu_id');
    }
}