<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/21
 * @copyright
 */

namespace Modules\Admin\Entities;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Modules\Admin\Http\Utils\Helper;

class AdminMenu extends Model
{
    protected $fillable = [
        'title','key', 'api', 'parent_id', 'icon', 'is_menu'
    ];

    public static function boot()
    {
        parent::boot();

        static::saved(function ($model) {
            Helper::getAllMenu(true);
            Helper::getAllApi(true);
        });
    }

    public function child()
    {
        return $this->hasMany(AdminMenu::class,'parent_id','id');
    }

    public function childrenIds(){
        return $this->child->pluck('id');
    }

    public function descendantsIds(){
        $ids = [];
        $this->getChildrenIds($this,$ids);
        return $ids;
    }

    public function getChildrenIds(AdminMenu $menu,&$ids){
        $child = $menu->child;
        if($child){
            $child->each(function ($item) use (&$ids){
                $ids[] = $item->id;
                $ids = self::getChildrenIds($item,$ids);
            });
        }

        return $ids;
    }
}