<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Utils\Helper;

class AdminUserTransformer extends BaseTransformer
{
    use Macroable;

    protected array $availableIncludes = ['role','department'];

    protected $show_role = false;

    public function __construct($show_role = false)
    {
        $this->show_role = $show_role;
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="用户信息",
     *     type="object",
     *     schema="User",
     *     @OA\Property(property="id", type="integer", description="用户ID"),
     *     @OA\Property(property="username", type="string", description="用户名"),
     *     @OA\Property(property="avatar", type="string", description="头像"),
     *     @OA\Property(property="name", type="string", description="名称"),
     *     @OA\Property(property="phone", type="string", description="手机号码"),
     *     @OA\Property(property="entry_time", type="string", description="入职时间"),
     *     @OA\Property(property="skill", type="string", description="技能"),
     *     @OA\Property(property="job_name", type="string", description="职业"),
     *     @OA\Property(property="job_number", type="string", description="工号"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(AdminUser $user)
    {
        $return = [
            'id', 'username', 'avatar', 'avatar_full_url', 'name','role_id',
            'phone','entry_time','department_id','skill','job_name','job_number','contract_id',
            'created_at', 'updated_at'
        ];
        $return = Helper::mapAttr($user,$return);
        $return['is_admin'] = Helper::isAdministrator($return['id']);

        return $return;
    }

    public function includeRole($user)
    {
        return $user->role?$this->item($user->role, new AdminRoleTransformer()):null;
    }

    public function includeDepartment($user)
    {
        return $user->department?$this->item($user->department, new DepartmentTransformer()):null;
    }
}
