<?php

namespace Modules\Admin\Http\Requests;

use Dingo\Api\Http\FormRequest;
use Dingo\Api\Http\Request;

class BaseRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $method = strtolower($this->method()).'Rules';

        $rules = $this->$method();

        foreach ($rules as &$rule) {
            if (is_string($rule) && strpos($rule, 'bail') === false) {
                $rule = 'bail|'.$rule;
            } elseif (is_array($rule) && !in_array('bail', $rule)) {
                array_unshift($rule, 'bail');
            }
        }

        return $rules;
    }

    protected function postRules()
    {
        return [];
    }

    protected function getRules()
    {
        return [];
    }

    protected function putRules()
    {
        return [];
    }

    protected function deleteRules()
    {
        return [];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * @return bool
     */
    public function isApi()
    {
        if ($this->container['request'] instanceof Request) {
            return true;
        }

        return false;
    }
}
