<?php

namespace Modules\Admin\Http\Controllers;

use Modules\Admin\Http\Requests\FileRequest;
use Modules\Admin\Http\Service\FileService;
use Modules\Admin\Http\Transformers\FileTransformer;

class FilesController extends BaseController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param FileRequest $request
     * @param FileService $file
     *
     * @return \Dingo\Api\Http\Response $response
     *
     * @OA\Post(
     *     tags={"基础接口"},
     *     summary="上传文件",
     *     path="/api/files",
     *     security={
     *         {"jwt_auth": {}}
     *     },
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\MediaType(
     *             mediaType="multipart/form-data",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"type","file"},
     *                 @OA\Property(
     *                     property="type",
     *                     type="string",
     *                     enum={"avatar"}
     *                 ),
     *                 @OA\Property(
     *                     property="file",
     *                     type="string",
     *                     format="binary"
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *          response="201",
     *          description="成功",
     *          @OA\MediaType(
     *              mediaType="application/json",
     *              @OA\Schema(type="object",
     *                  @OA\Property(property="data", type="object", ref="#/components/schemas/File")
     *              )
     *          )
     *      )
     * )
     */
    public function store(FileRequest $request, FileService $file)
    {
        $info = $file->process($request->file, $request->input('type'));

        return $this->response->item($info, new FileTransformer())
            ->setStatusCode(201);
    }
}
