<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Entities\Department;
use Modules\Admin\Http\Utils\Helper;

class DepartmentTransformer extends BaseTransformer
{
    use Macroable;

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="部门信息",
     *     type="object",
     *     schema="Department",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="名称"),
     *     @OA\Property(property="desc", type="string", description="说明"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */
    public function transform(Department $department)
    {
        $return = ['id', 'name', 'desc','created_at'];
        $return = Helper::mapAttr($department,$return);
        return $return;
    }
}
