<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\Announcement;
use Modules\Admin\Http\Utils\Helper;

class AnnouncementTransformer extends BaseTransformer
{
    use Macroable;

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="公告信息",
     *     type="object",
     *     schema="Announcement",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="title", type="string", description="标题"),
     *     @OA\Property(property="content", type="string", description="内容"),
     *     @OA\Property(property="show", type="integer", description="是否显示"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */
    public function transform(Announcement $announcement)
    {
        $return = ['id', 'title', 'content','created_at'];
        $return = Helper::mapAttr($announcement,$return);
        $return['show'] = $announcement->show === 1;
        return $return;
    }
}
