<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/31
 * @copyright
 */

namespace Modules\Admin\Http\Service;

use Modules\Admin\Entities\AdminUser;

class UserService extends BaseService
{
    /**
     * 获取员工工号
     * @desc
     * @return string
     * @since     2023/10/31
     * @modify
     * @author    [ZZM]
     */
    static function createJobNumber()
    {
        $user       = AdminUser::orderBy('id', 'desc')->first();
        $job_number = $user->job_number;

        return 'SMG' . sprintf("%08d", self::findNum($job_number) + 1);
    }

    static function findNum($str = '')
    {
        $str = trim($str);
        if (empty($str))
        {
            return 0;
        }
        $result = '';
        for ($i = 0; $i < strlen($str); $i++)
        {
            if (is_numeric($str[ $i ]))
            {
                $result .= $str[ $i ];
            }
        }

        return (int)$result;
    }

}