<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('files', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->index()->comment('用户ID');
            $table->string('type')->index()->comment('文件类型');
            $table->string('path')->comment('文件路径');
            $table->integer('size')->default(0)->comment('文件大小');
            $table->string('mime')->enablenull()->comment('文件类型');
            $table->string('name')->comment('文件名称');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('files');
    }
};
