<?php

namespace Modules\Admin\Listeners;

use Modules\Admin\Entities\UserLoginLog as UserLoginLogModel;
use Modules\Admin\Events\UserLoginEvents;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class UserLoginListeners
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param UserLoginEvents $event
     *
     * @return void
     */
    public function handle(UserLoginEvents $event)
    {
        $user = $event->user;

        $log = [
            'user_id' => $user->id,
            'ip' => request()->getClientIp(),
        ];

        try {
            UserLoginLogModel::create($log);
        } catch (\Exception $exception) {
            logger($exception->getMessage());
        }
    }
}
