<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('admin_users', function (Blueprint $table) {
            $table->string('phone')->nullable()->comment('手机号码');
            $table->dateTime('entry_time')->nullable()->comment('入职时间');
            $table->integer('department_id')->nullable()->comment('部门ID');
            $table->json('skill')->nullable()->comment('技能');
            $table->string('job_name')->nullable()->nullable()->comment('职位');
            $table->string('job_number')->nullable()->comment('工号');
            $table->integer('contract_id')->nullable()->comment('合同ID');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
