<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Validation\Rule;
use Modules\Admin\Entities\AdminUser;

class DepartmentRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function postRules()
    {
        return [
            'desc' => 'bail|required',
            'name' => 'bail|required',
        ];
    }

    public function putRules()
    {
        return [
            'desc' => 'bail|required',
            'name' => 'bail|required',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => '部门名称不能为空',
            'desc.required' => '部门说明不能为空',
        ];
    }
}
