<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Customers\Http\Transformer;

use Modules\Admin\Http\Utils\Helper;
use Modules\Customers\Entities\Customer;

class CustomerTransformer extends BaseTransformer
{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="用户信息",
     *     type="object",
     *     schema="Customer",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="客户名称"),
     *     @OA\Property(property="company", type="string", description="公司名称"),
     *     @OA\Property(property="industry", type="string", description="行业"),
     *     @OA\Property(property="department", type="string", description="部门"),
     *     @OA\Property(property="duties", type="string", description="职业"),
     *     @OA\Property(property="tel_phone", type="string", description="电话"),
     *     @OA\Property(property="mobile_phone", type="string", description="手机号码"),
     *     @OA\Property(property="wechat", type="string", description="微信号"),
     *     @OA\Property(property="dy", type="string", description="抖音号"),
     *     @OA\Property(property="email", type="string", description="邮箱"),
     *     @OA\Property(property="province", type="string", description="省"),
     *     @OA\Property(property="city", type="string", description="市"),
     *     @OA\Property(property="area", type="string", description="区"),
     *     @OA\Property(property="address", type="string", description="地址"),
     *     @OA\Property(property="follow_status", type="string", description="跟进状态"),
     *     @OA\Property(property="from", type="string", description="客户来源"),
     *     @OA\Property(property="type", type="string", description="客户类型"),
     *     @OA\Property(property="founder", type="string", description="创建者"),
     *     @OA\Property(property="owner", type="string", description="持有者"),
     *     @OA\Property(property="business_license", type="string", description="营业执照"),
     *     @OA\Property(property="identity", type="string", description="身份证"),
     *     @OA\Property(property="bank_account", type="string", description="银行账户"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     * )
     */
    public function transform(Customer $customer)
    {
        $return = [
            'id','name','company','industry', 'department', 'duties', 'tel_phone', 'mobile_phone',
            'wechat','dy','email', 'province', 'city', 'area', 'address','follow_status','follow_status_text',
            'from','from_text','type','type_text','founder', 'owner', 'business_license', 'identity', 'bank_account',
            'created_at',
        ];
        $return = Helper::mapAttr($customer,$return);
        return $return;
    }
}
