<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Customers\Http\Transformer;

use Modules\Admin\Http\Utils\Helper;
use Modules\Customers\Entities\BusinessOpportunity;
use Modules\Customers\Entities\Customer;

class BusinessOpportunityTransformer extends BaseTransformer
{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="用户信息",
     *     type="object",
     *     schema="BusinessOpportunity",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="product_type", type="string", description="产品类型"),
     *     @OA\Property(property="title", type="string", description="标题"),
     *     @OA\Property(property="demand_doc", type="string", description="需求文档"),
     *     @OA\Property(property="customer_desire_time", type="string", description="客户期望时间"),
     *     @OA\Property(property="customer_expect_money", type="string", description="客户预估金额"),
     *     @OA\Property(property="expect_date", type="string", description="预计签单日期"),
     *     @OA\Property(property="estimate_status", type="string", description="评估状态"),
     *     @OA\Property(property="estimate_hour", type="string", description="评估工时"),
     *     @OA\Property(property="estimate_price", type="string", description="评估价格"),
     *     @OA\Property(property="estimate_people", type="string", description="评估人"),
     *     @OA\Property(property="estimate_time", type="string", description="评估时间"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */
    public function transform(BusinessOpportunity $business_opportunity)
    {
        $return = [
            'id','customer_id', 'product_type','product_type_text', 'title', 'demand_doc','demand_doc_full_url', 'customer_desire_time', 'customer_expect_money',
            'expect_date', 'estimate_status','estimate_status_text', 'estimate_hour', 'estimate_price', 'estimate_people', 'estimate_time',
            'created_at',
        ];
        $return = Helper::mapAttr($business_opportunity,$return);
        return $return;
    }
}
