<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/3
 * @copyright
 */

namespace Modules\Customers\Http\Service;

use Modules\Customers\Entities\BusinessOpportunity;

class BusinessOpportunityService
{
    /**
     * 格式化待更新参数
     * @desc
     *
     * @param BusinessOpportunity $business_opportunity 数据模型
     * @param array    $params   请求参数
     *
     * @return array
     * @since     2023/11/2
     * @modify
     * @author    [ZZM]
     */
    static public function formatUpdateParams(BusinessOpportunity $business_opportunity, array $params): array
    {
        $update = [];
        foreach ($params as $field => $value)
        {
            switch ($field)
            {
                case "product_type":
                case "estimate_status":
                case "estimate_hour":
                case "estimate_price":
                    $value = $value ?: 0;
                    break;
                case "customer_desire_time":
                case "estimate_time":
                    $value = $value ?: NULL;
                    break;
                default:
                    $value = $value ?: '';
                    break;
            }

            if ($business_opportunity->{$field} != $value)
            {
                $update[ $field ] = $value;
            }
        }


        return $update;
    }

}