<?php

namespace Modules\Customers\Http\Requests;

use Illuminate\Validation\Rule;
use Modules\Admin\Entities\AdminUser;
use Modules\Customers\Entities\BusinessOpportunity;
use Modules\Customers\Entities\Customer;
use Modules\Customers\Entities\CustomerFollow;

class BusinessOpportunityRequest extends BaseRequest
{

    public function addRules()
    {
        return [
            'customer_id' => 'bail|required|exists:customers,id',
            'product_type' => ['bail','required',Rule::in(array_keys(BusinessOpportunity::$product_type_maps))],
            'title' => 'bail|required',
            'demand_doc' => 'bail|required',
            'customer_desire_time' => ['bail','required','date_format:Y-m-d H:i:s','after:now'],
            'customer_expect_money' => 'bail|required',
        ];
    }

    public function editRules()
    {
        return [
            'customer_id' => 'bail|required|exists:customers,id',
            'product_type' => ['bail','required',Rule::in(array_keys(BusinessOpportunity::$product_type_maps))],
            'title' => 'bail|required',
            'demand_doc' => 'bail|required',
            'customer_desire_time' => ['bail','required','date_format:Y-m-d H:i:s','after:now'],
            'customer_expect_money' => 'bail|required',
        ];
    }



    public function commonMessages()
    {
        return [
            'customer_id.required' => '客户不能为空',
            'customer_id.exists' => '客户不存在',
            'product_type.required' => '产品类型不能为空',
            'product_type.in' => '产品类型不存在',
            'title.required' => '标题不能为空',
            'demand_doc.required' => '需求文档不能为空',
            'customer_desire_time.required' => '期望完成时间不能为空',
            'customer_desire_time.date_format' => '期望完成时间格式错误',
            'customer_desire_time.after' => '期望完成时间必须大于当前时间',
            'customer_expect_money.required' => '预期金额不能为空',
        ];
    }


}
