<?php

namespace Modules\Customers\Http\Requests;

use Dingo\Api\Facade\Route;
use Dingo\Api\Http\FormRequest;
use Dingo\Api\Http\Request;

class BaseRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $method = strtolower($this->getAction()).'Rules';

        if(!method_exists($this, $method)){
            return [];
        }
        $rules = $this->$method();

        foreach ($rules as &$rule) {
            if (is_string($rule) && strpos($rule, 'bail') === false) {
                $rule = 'bail|'.$rule;
            } elseif (is_array($rule) && !in_array('bail', $rule)) {
                array_unshift($rule, 'bail');
            }
        }

        return $rules;
    }

    public function messages()
    {
        $method = strtolower($this->getAction()).'Messages';

        if(!method_exists($this, $method)){
            return $this->commonMessages();
        }
        return $this->$method();
    }

    public function commonMessages(){
        return [];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }


    /**
     * 获取请求的控制器方法
     * @desc
     * @return mixed|string
     * @since     2023/11/2
     * @modify
     * @author    [ZZM]
     */
    public function getAction(){
        $controllerAction = Route::currentRouteAction();;
        [$controller, $method] = explode('@', $controllerAction);
        return $method;
    }
}
