<?php

namespace Modules\Customers\Http\Controllers;

use Modules\Customers\Entities\Customer;
use Modules\Customers\Http\Requests\CustomerRequest;

class PublicCustomersController extends CustomersController
{
    protected $type = 'public';

    /**
     * 领取至我的客户
     * @desc
     *
     * @author    [ZZM]
     * @since     2023/11/2
     * @modify
     */
    public function receivePrivate(CustomerRequest $request){
        $user = $this->user;
        $ids = $request->input('id', []);

        if($ids){
            Customer::whereIn('id', $ids)->public()->update(['owner' => $user->id]);
        }

        return $this->response->noContent();
    }
}
