<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/2
 * @copyright
 */

namespace Modules\Customers\Http\Controllers;

use Modules\Admin\Http\Controllers\BaseController;
use Modules\Customers\Entities\BusinessOpportunity;
use Modules\Customers\Http\Requests\BusinessOpportunityRequest;
use Modules\Customers\Http\Service\BusinessOpportunityService;
use Modules\Customers\Http\Transformer\BusinessOpportunityTransformer;

class BusinessOpportunityController extends BaseController
{

    /**
     * 商机列表
     * @desc
     * @author    [ZZM]
     * @since     2023/11/3
     * @modify
     */
    public function list(BusinessOpportunityRequest $request){
        $params = $request->input('search',[]);

        $list = BusinessOpportunity::paramsSearch($params)->paginate(request('per_page'));

        return $this->response->paginator($list, new BusinessOpportunityTransformer());

    }

    /**
     * 新增商机
     * @desc
     * @author    [ZZM]
     * @since     2023/11/3
     * @modify
     */
    public function add(BusinessOpportunityRequest $request){
        $params = $request->only(
            [
                'customer_id', 'product_type', 'title', 'demand_doc', 'customer_desire_time', 'customer_expect_money',
                'expect_date', 'estimate_status', 'estimate_hour', 'estimate_price', 'estimate_people', 'estimate_time',
            ]
        );

        $params = array_filter($params);

        $business_opportunity = BusinessOpportunity::create($params)->refresh();

        return $this->response->item($business_opportunity, new BusinessOpportunityTransformer());

    }

    /**
     * 编辑商机
     * @desc
     * @author    [ZZM]
     * @since     2023/11/3
     * @modify
     */
    public function edit(BusinessOpportunityRequest $request,$id){
        $params = $request->only(
            [
                'customer_id', 'product_type', 'title', 'demand_doc', 'customer_desire_time', 'customer_expect_money',
                'expect_date', 'estimate_status', 'estimate_hour', 'estimate_price', 'estimate_people', 'estimate_time',
            ]
        );

        $business_opportunity = BusinessOpportunity::where('id', $id)->first();
        if (!$business_opportunity)
        {
            abort(500, '商机不存在');
        }

        $update = BusinessOpportunityService::formatUpdateParams($business_opportunity, $params);

        $business_opportunity->update($update);

        return $this->response->item($business_opportunity, new BusinessOpportunityTransformer());

    }

    /**
     * 商机详情
     * @desc
     *
     * @since     2023/11/3
     * @modify
     * @author    [ZZM]
     */
    public function show(BusinessOpportunityRequest $request,$id){
        $business_opportunity = BusinessOpportunity::where('id', $id)->first();
        if (!$business_opportunity)
        {
            abort(500, '商机不存在');
        }

        return $this->response->item($business_opportunity, new BusinessOpportunityTransformer());
    }

    /**
     * 数据字典
     * @desc
     * @author    [ZZM]
     * @since     2023/11/2
     * @modify
     */
    public function dataMaps(){
        $product_type_maps = BusinessOpportunity::$product_type_maps;
        $product_type_maps = array_map(function ($id, $name) {
            return ['id' => $id, 'name' => $name];
        }, array_keys($product_type_maps), $product_type_maps);

        $estimate_status_maps = BusinessOpportunity::$estimate_status_maps;
        $estimate_status_maps = array_map(function ($id, $name) {
            return ['id' => $id, 'name' => $name];
        }, array_keys($estimate_status_maps), $estimate_status_maps);

        $data = [
            'product_type_maps' => $product_type_maps,
            'estimate_status_maps' => $estimate_status_maps,
        ];
        return $this->response->array(['data'=>$data]);
    }
}