<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/2
 * @copyright
 */

namespace Modules\Customers\Entities;

class Customer extends BaseModel
{
    protected $fillable = [
        'name', 'company', 'industry', 'department', 'duties', 'tel_phone', 'mobile_phone',
        'wechat', 'dy', 'email', 'province', 'city', 'area', 'address', 'follow_status',
        'from', 'type', 'founder', 'owner', 'business_license', 'identity', 'bank_account',
    ];

    protected $search = [
        'name',  'tel_phone', 'mobile_phone','wechat', 'follow_status', 'from', 'type', 'created_at',
    ];

    static public $type_maps = [
        1  => '个人',
        2  => '企业',
        99 => '其他',
    ];

    static public $from_maps = [
        1  => '抖音',
        2  => '客户转介绍',
        3  => '社交推广',
        4  => '空白',
        99 => '其他',
    ];

    protected function searchRule($query,$key,$value){
        switch ($key){
            case "name":
                $query->where($key,'like',"%{$value}%");
                break;
            case "created_at":
                $times = explode(',',$value);
                $query->where(function ($query)use ($times){
                    $query->where('created_at','>=',$times[0]);
                    if(!empty($times[1])){
                        $query->where('created_at','<=',$times[1]);
                    }
                });
                break;
            default:
                $query->where($key,$value);
                break;
        }
        return $query;
    }

    public function getTypeTextAttribute()
    {
        return static::$type_maps[$this->type] ?? '';
    }

    public function getFromTextAttribute()
    {
        return static::$from_maps[$this->from] ?? '';
    }

    public function getFollowStatusTextAttribute()
    {
        return CustomerFollow::$status_maps[$this->follow_status] ?? '';
    }

    public function scopePrivate($query)
    {
        $query->where('owner', auth()->user()->id);
    }

    public function scopePublic($query)
    {
        $query->where('owner', 0);
    }

}