<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/11/2
 * @copyright
 */

namespace Modules\Customers\Entities;

use Illuminate\Database\Eloquent\Model;

class BaseModel extends Model
{
    protected $search = [];

    public function scopeParamsSearch($query,$params)
    {
        foreach ($params as $key => $value){
            $value=  (string)$value;
            if(!in_array($key,$this->search)){
                continue;
            }

            $this->searchRule($query,$key,$value);
        }
    }

    protected function searchRule($query,$key,$value){
        $query->where($key,$value);
    }
}