<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_opportunities', function (Blueprint $table) {
            $table->comment('商机表');
            $table->id();
            $table->integer('customer_id')->default(0)->comment('客户ID');
            $table->integer('product_type')->default(0)->comment('产品类型');
            $table->string('title')->default('')->comment('标题');
            $table->string('demand_doc')->default('')->comment('需求文档');
            $table->dateTime('customer_desire_time')->nullable()->comment('客户期望时间');
            $table->decimal('customer_expect_money',13,2)->default(0)->comment('客户预期金额');
            $table->date('expect_date')->nullable()->comment('预计签单日期');
            $table->integer('estimate_status')->default(0)->comment('评估状态');
            $table->integer('estimate_hour')->default(0)->comment('评估-工时');
            $table->decimal('estimate_price',13,2)->default(0)->comment('评估-价格');
            $table->string('estimate_people')->default('')->comment('评估人');
            $table->dateTime('estimate_time')->nullable()->comment('评估时间');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_opportunitys');
    }
};
