<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/15
 * Time: 9:47
 */
namespace Modules\Admin\Http\Transformer;

use Illuminate\Support\Traits\Macroable;

class AccessTokenTransformer extends BaseTransformer
{
    use Macroable;

    protected $refresh = false;

    public function __construct($refresh = false) {
        $this->refresh = $refresh;
        parent::__construct();

    }

    protected array $availableIncludes = ['user'];

    /**
     * @OA\Schema(
     *     description="Token信息",
     *     type="object",
     *     schema="Token",
     *     @OA\Property(property="access_token", type="string", description="Token"),
     *     @OA\Property(property="token_type", type="string", description="Token类型"),
     *     @OA\Property(property="expires_in", type="integer", description="过期时间"),
     *     @OA\Property(property="user", type="object", description="用户", @OA\Property(property="data", type="object", ref="#/components/schemas/User"))
     * )
     */
    public function transform($user)
    {
        if($this->refresh){
            return $user->apiRefreshTokenTokenInfo();
        }
        return $user->apiLoginAndGetTokenInfo();
    }

    public function includeUser($user)
    {
        return $this->item($user, new AdminUserTransformer());
    }
}
