<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/14
 * Time: 14:47
 */
namespace Modules\Admin\Http\Service;

use Modules\Admin\Entities\File;

class FileService extends BaseService
{
    public function __construct(File $file)
    {
        $this->model = $file;
    }

    public function process($file, $type)
    {
        $config = config('upload', []);
        $folder = $config[$type]['folder'];
        $folder_name = "$folder/".date('Ym', time()).'/'.date('d', time());
        $path = $file->store($folder_name, $config[$type]['filesystem']);

        $info = [];
        $info['user_id'] = \Auth::id();
        $info['type'] = $type;
        $info['path'] = $path;
        $info['size'] = $file->getSize();
        $info['mime'] = $file->getMimeType();
        $info['name'] = $file->getClientOriginalName();

        $this->create($info);

        return $this->model;
    }
}
