<?php

namespace Modules\Admin\Http\Requests;

class RoleRequest extends BaseRequest
{
    public function postRules()
    {
        return [
            'name' => 'bail|required',
            'slug' => 'bail|required',
        ];
    }

    public function putRules()
    {
        return [
            'name' => 'bail|required',
            'slug' => 'bail|required',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => '名称必须',
            'slug.required' => '描述必须',
        ];
    }
}
