<?php

namespace Modules\Admin\Http\Requests;

class FileRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $upload = config('upload', []);
        $types = implode(',', array_keys($upload));
        $validate = isset($upload[$this->type]) ? 'required|file|'.$upload[$this->type]['validate'] : 'required|file';

        return [
            'type' => 'required|in:'.$types,
            'file' => $validate,
        ];
    }

    public function messages()
    {
        return config('upload.'.$this->type.'.validate_msg', []);
    }
}
