<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admin_users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('username', 190)->unique();
            $table->string('password', 60);
            $table->string('name');
            $table->string('avatar')->nullable();
            $table->string('salt');
            $table->integer('role_id');
            $table->timestamps();
        });

        Schema::create('admin_roles', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 50);
            $table->string('slug', 50);
            $table->json('menus')->nullable()->comment('权限');
            $table->timestamps();
        });

        Schema::create('admin_menus', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('parent_id')->default(0)->comment('上级ID');
            $table->integer('order')->default(0)->comment('排序');
            $table->string('key',50)->comment('前端路由标识');
            $table->string('title', 50)->comment('标题');
            $table->string('icon', 50)->nullable();
            $table->string('api')->nullable()->comment('api接口地址');
            $table->boolean('is_menu')->default(1)->comment('是否菜单 0否 1是');
            $table->timestamps();
        });

        Schema::create('admin_operation_logs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id');
            $table->string('path');
            $table->string('method', 10);
            $table->string('ip');
            $table->text('input');
            $table->index('user_id');
            $table->timestamps();
        });

        DB::transaction(function (){
            DB::table("admin_users")->insert([
                                                 "id" => "1",
                                                 "username" => "admin",
                                                 "name" => "admin",
                                                 "salt" => "4IpZw+?%MD1c",
                                                 "password" => password_hash(md5('1234564IpZw+?%MD1c'), PASSWORD_DEFAULT),
                                                 "role_id" => '1',
                                             ]);
            DB::table("admin_roles")->insert([
                                                 "id" => "1",
                                                 "name" => "超级管理员",
                                                 "slug" => "超级管理员",
                                             ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admin_users');
        Schema::dropIfExists('admin_roles');
        Schema::dropIfExists('admin_menus');
        Schema::dropIfExists('admin_operation_logs');
    }
};
