<?php

namespace Modules\Admin\Http\Requests;

class MenuRequest extends BaseRequest
{
    public function postRules()
    {
        if(empty($this->parent_id)){
            $this['parent_id'] = 0;
            $parent_id_rule = ['integer'];
        }else{
            $parent_id_rule = ['integer','exists:admin_menus,id'];
        }

        return [
            'parent_id' => $parent_id_rule,
            'title' => 'bail|required',
            //'path' => ['required'],
            'key' => ['required','unique:admin_menus,key'],
        ];
    }

    public function putRules()
    {
        if(empty($this->parent_id)){
            $this['parent_id'] = 0;
            $parent_id_rule = ['integer'];
        }else{
            $parent_id_rule = ['integer','exists:admin_menus,id'];
        }

        return [
            'parent_id' => $parent_id_rule,
            'title' => 'bail|required',
            'key' => ['required'],
        ];
    }

    public function messages()
    {
        return [
            'title.required' => '菜单名称必须',
            'parent_id.exists' => '父菜单不存在',
            //'api.unique' => '接口地址重复',
            'key.required' => '路由标识必填',
            'key.unique' => '路由标识重复',
        ];
    }
}
