<?php
declare(strict_types=1);

namespace Modules\Admin\Http\Utils;

use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Modules\Admin\Entities\AdminMenu;

class Helper {

    /**
     * 获取全部菜单
     * @desc
     * @return mixed|mixed[]
     * @since     2023/10/23
     * @modify
     * @author    [ZZM]
     */
    static function getAllMenu($refresh = false){
        if(!$refresh && $menu = Cache::get("ALL_MENU")){
            return json_decode($menu,true);
        }
        $menu = AdminMenu::all()->toArray();
        if($menu){
            Cache::put("ALL_MENU",json_encode($menu));
        }
        return $menu;
    }

    /**
     * 获取角色菜单
     * @desc
     *
     * @param $role
     *
     * @return mixed|mixed[]
     * @author    [ZZM]
     * @since     2023/10/23
     * @modify
     */
    static function getRoleMenu($role,$refresh = false){
        if(Helper::isAdministrator($role->id)){
            #超级管理员默认获取全部菜单
            return self::getAllMenu();
        }

        if(!$refresh && $menu = Cache::get("ROLE_MENU_{$role->id}")){
            return json_decode($menu,true);
        }

        $menu = $role->menu;
        $menu = $menu->toArray();

        if($menu){
            Cache::put("ROLE_MENU_{$role->id}",json_encode($menu));
        }

        return $menu;
    }

    /**
     * 是否超级管理员
     * @desc
     *
     * @param $role_id
     *
     * @return bool
     * @author    [ZZM]
     * @since     2023/10/23
     * @modify
     */
    static function isAdministrator($role_id){
        return $role_id == 1;
    }

    static function makeTree(array $elements, $parentId = 0) {
        $branch = [];

        foreach ($elements as $element) {
            if ($element['parent_id'] == $parentId) {
                $children = self::makeTree($elements, $element['id']);
                if ($children) {
                    $element['children'] = $children;
                }
                $branch[] = $element;
            }
        }

        return $branch;
    }

    /**
     * 随机字符串
     * @desc
     *
     * @param int $length
     *
     * @return string
     * @author    [ZZM]
     * @since     2023/10/21
     * @modify
     */
    static function generateRandomString($length = 12) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&*()-_+=<>?';
        $charLength = strlen($characters);
        $randomString = '';

        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charLength - 1)];
        }

        return $randomString;
    }

    static function mapAttr($obj, $keys = [])
    {
        $request = request();
        $temp = [];
        $fields = $request->get('fields', '');
        $fields = $fields == '' ? [] : explode(',', $fields);
        $exclude_fields = $request->get('exclude_fields', '');
        $exclude_fields = $exclude_fields == '' ? [] : explode(',', $exclude_fields);

        foreach ($keys as $index => $key) {
            if (!is_numeric($index)) {
                if (is_string($key) && \Illuminate\Support\Str::startsWith($key, '_call:')) {
                    [$class, $method, $arg_str] = explode('@', substr($key, 6).'@@');
                    $args = explode(',', $arg_str);
                    array_unshift($args, $obj);
                    $temp[$index] = (new $class())->$method(...$args);
                } else {
                    $temp[$index] = $key;
                }
            } else {
                if (strpos($key, '.')) {
                    [$relation, $attr] = explode('.', $key);
                    $temp[$key] = optional($obj->$relation)->$attr;
                } else {
                    if (!empty($fields) && !in_array($key, $fields)) {
                        continue;
                    }

                    if (in_array($key, $exclude_fields)) {
                        continue;
                    }

                    if (is_string($key) && \Illuminate\Support\Str::endsWith($key, '_full_url')) {
                        $key2 = substr($key, 0, -9);
                        $temp[$key] = $obj->$key ?? file_url($obj->$key2);
                    } else {
                        $temp[$key] = (is_object($obj->$key) && ($obj->$key instanceof Carbon)) ? $obj->$key->toDateTimeString() : $obj->$key;
                    }
                }
            }
        }
        return $temp;
    }
}
