<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Utils\Helper;

class AdminUserTransformer extends BaseTransformer
{
    use Macroable;

    protected $hideDetail = false;

    public function __construct($hideDetail = false)
    {
        $this->hideDetail = $hideDetail;
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="用户信息",
     *     type="object",
     *     schema="User",
     *     @OA\Property(property="id", type="integer", description="用户ID"),
     *     @OA\Property(property="username", type="string", description="用户名"),
     *     @OA\Property(property="avatar", type="string", description="头像"),
     *     @OA\Property(property="name", type="string", description="名称"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(AdminUser $user)
    {
        $return = ['id', 'username', 'avatar', 'name', 'created_at', 'updated_at'];

        return Helper::mapAttr($user,$return);
    }
}
